/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.Util;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.Messages;
import jenkins.plugins.publish_over.PubSelector;
import jenkins.plugins.publish_over.SelectAllPubSelector;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParamPublish
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String parameterName;

    @DataBoundConstructor
    public ParamPublish(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public PubSelector createSelector(BPBuildInfo buildInfo) {
        if (Util.fixEmptyAndTrim((String)this.parameterName) == null) {
            return SelectAllPubSelector.SELECT_ALL;
        }
        String regexp = buildInfo.getCurrentBuildEnv().getEnvVars().get(this.parameterName);
        if (regexp == null) {
            throw new BapPublisherException(Messages.exception_paramPublish_noParameter(this.parameterName));
        }
        try {
            Pattern pattern = Pattern.compile(regexp);
            return new Selector(buildInfo, pattern);
        }
        catch (PatternSyntaxException pse) {
            throw new BapPublisherException(Messages.exception_paramPublish_badPattern(this.parameterName, regexp, pse.getMessage()), pse);
        }
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.parameterName);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, ParamPublish that) {
        return builder.append((Object)this.parameterName, (Object)that.parameterName);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("parameterName", (Object)this.parameterName);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (ParamPublish)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public static final class Selector
    implements PubSelector {
        private static final long serialVersionUID = 1L;
        private final BPBuildInfo buildInfo;
        private final Pattern pattern;

        public Selector(BPBuildInfo buildInfo, Pattern pattern) {
            this.buildInfo = buildInfo;
            this.pattern = pattern;
        }

        @Override
        public boolean selected(BapPublisher publisher) {
            String label = null;
            if (publisher.getLabel() == null || Util.fixEmptyAndTrim((String)publisher.getLabel().getLabel()) == null) {
                label = "";
            } else {
                String rawLabel = publisher.getLabel().getLabel().trim();
                label = Util.replaceMacro((String)rawLabel, this.buildInfo.getEnvVars());
            }
            if (this.pattern.matcher(label).matches()) {
                this.buildInfo.println(Messages.console_paramPublish_match(label, this.pattern.pattern(), publisher.getConfigName()));
                return true;
            }
            this.buildInfo.println(Messages.console_paramPublish_skip(label, this.pattern.pattern(), publisher.getConfigName()));
            return false;
        }
    }
}

