/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.BapTransferException;
import jenkins.plugins.publish_over.Credentials;
import jenkins.plugins.publish_over.Messages;
import jenkins.plugins.publish_over.PublisherLabel;
import jenkins.plugins.publish_over.Retry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BapPublisher<TRANSFER extends BPTransfer>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BapPublisher.class.getName());
    private String configName;
    private boolean verbose;
    private ArrayList<TRANSFER> transfers;
    private boolean useWorkspaceInPromotion;
    private boolean usePromotionTimestamp;
    private Retry retry;
    private PublisherLabel label;
    private Credentials credentials;

    public BapPublisher() {
    }

    public BapPublisher(String configName, boolean verbose, ArrayList<TRANSFER> transfers, boolean useWorkspaceInPromotion, boolean usePromotionTimestamp, Retry retry, PublisherLabel label, Credentials credentials) {
        this.configName = configName;
        this.verbose = verbose;
        this.setTransfers(transfers);
        this.useWorkspaceInPromotion = useWorkspaceInPromotion;
        this.usePromotionTimestamp = usePromotionTimestamp;
        this.retry = retry;
        this.label = label;
        this.credentials = credentials;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public final boolean isUseWorkspaceInPromotion() {
        return this.useWorkspaceInPromotion;
    }

    public final void setUseWorkspaceInPromotion(boolean useWorkspaceInPromotion) {
        this.useWorkspaceInPromotion = useWorkspaceInPromotion;
    }

    public final boolean isUsePromotionTimestamp() {
        return this.usePromotionTimestamp;
    }

    public final void setUsePromotionTimestamp(boolean usePromotionTimestamp) {
        this.usePromotionTimestamp = usePromotionTimestamp;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final ArrayList<TRANSFER> getTransfers() {
        return this.transfers;
    }

    public final void setTransfers(ArrayList<TRANSFER> transfers) {
        this.transfers = transfers == null ? new ArrayList() : transfers;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public PublisherLabel getLabel() {
        return this.label;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    private int sumTransfers(List<Integer> transferred) {
        int total = 0;
        for (int tx : transferred) {
            total += tx;
        }
        return total;
    }

    private void printNumberOfFilesTransferred(BPBuildInfo buildInfo, List<Integer> transferred) {
        int total = this.sumTransfers(transferred);
        Object countString = Integer.toString(total);
        if (transferred.size() > 1) {
            countString = total + " ( " + StringUtils.join(transferred, (String)" + ") + " )";
        }
        buildInfo.println(Messages.console_transferredXFiles(countString));
    }

    public void setEffectiveEnvironmentInBuildInfo(BPBuildInfo buildInfo) {
        buildInfo.setVerbose(this.verbose);
        BPBuildEnv current = buildInfo.getCurrentBuildEnv();
        BPBuildEnv target = buildInfo.getTargetBuildEnv();
        if (target == null) {
            buildInfo.setEnvVars(current.getEnvVars());
            buildInfo.setBaseDirectory(current.getBaseDirectory());
            buildInfo.setBuildTime(current.getBuildTime());
        } else {
            buildInfo.setBaseDirectory(this.useWorkspaceInPromotion ? current.getBaseDirectory() : target.getBaseDirectory());
            buildInfo.setBuildTime(this.usePromotionTimestamp ? current.getBuildTime() : target.getBuildTime());
            TreeMap<String, String> effectiveEnvVars = current.getEnvVarsWithPrefix("promotion_");
            effectiveEnvVars.putAll(target.getEnvVars());
            buildInfo.setEnvVars(effectiveEnvVars);
        }
    }

    public void perform(BPHostConfiguration hostConfig, BPBuildInfo buildInfo) throws Exception {
        Performer performer = new Performer(hostConfig, buildInfo);
        this.printNumberOfFilesTransferred(buildInfo, performer.perform());
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.configName).append(this.verbose).append(this.transfers).append(this.useWorkspaceInPromotion).append(this.usePromotionTimestamp).append((Object)this.retry).append((Object)this.label).append((Object)this.credentials);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapPublisher that) {
        return builder.append((Object)this.configName, (Object)that.configName).append(this.verbose, that.verbose).append(this.transfers, that.transfers).append(this.useWorkspaceInPromotion, that.useWorkspaceInPromotion).append(this.usePromotionTimestamp, that.usePromotionTimestamp).append((Object)this.retry, (Object)that.retry).append((Object)this.label, (Object)that.label).append((Object)this.credentials, (Object)that.credentials);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("configName", (Object)this.configName).append("verbose", this.verbose).append("transfers", this.transfers).append("useWorkspaceInPromotion", this.useWorkspaceInPromotion).append("usePromotionTimestamp", this.usePromotionTimestamp).append("retry", (Object)this.retry).append("label", (Object)this.label).append("credentials", (Object)this.credentials);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BapPublisher)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    private final class Performer {
        private final BPHostConfiguration hostConfig;
        private final BPBuildInfo buildInfo;
        private BPClient client;
        private int remainingTries;
        private final ArrayList<TRANSFER> remainingTransfers = new ArrayList();
        private final List<Integer> transferred = new ArrayList<Integer>();
        private boolean transferComplete;
        private BPTransfer.TransferState transferState;
        private Exception exception;

        protected Performer(BPHostConfiguration hostConfig, BPBuildInfo buildInfo) {
            this.hostConfig = hostConfig;
            this.buildInfo = buildInfo;
            this.remainingTries = BapPublisher.this.retry == null ? 0 : BapPublisher.this.retry.getRetries();
            this.remainingTransfers.addAll(BapPublisher.this.transfers);
        }

        private List<Integer> perform() throws Exception {
            do {
                try {
                    if (BapPublisher.this.credentials != null) {
                        this.buildInfo.put("credentials", BapPublisher.this.credentials);
                    }
                    this.buildInfo.println(Messages.console_connecting(BapPublisher.this.configName));
                    this.client = this.hostConfig.createClient(this.buildInfo, BapPublisher.this);
                    while (!this.remainingTransfers.isEmpty()) {
                        this.beginTransfers();
                        this.transfer();
                        this.endTransfers();
                    }
                    List<Integer> list = this.transferred;
                    return list;
                }
                catch (BapTransferException bte) {
                    this.transferState = bte.getState();
                    this.exception = (Exception)bte.getCause();
                }
                catch (Exception e) {
                    this.exception = e;
                }
                finally {
                    if (BapPublisher.this.credentials != null) {
                        this.buildInfo.remove("credentials");
                    }
                    if (this.client != null) {
                        this.buildInfo.println(Messages.console_disconnecting(BapPublisher.this.configName));
                        this.client.disconnectQuietly();
                    }
                }
            } while (this.remainingTries-- > 0 && this.delay());
            throw this.exception;
        }

        private boolean delay() {
            LOGGER.log(Level.WARNING, Messages.log_exceptionCaught_retrying(), this.exception);
            this.buildInfo.println(Messages.console_retryDelay(this.exception.getLocalizedMessage(), BapPublisher.this.retry.getRetryDelay()));
            try {
                Thread.sleep(BapPublisher.this.retry.getRetryDelay());
            }
            catch (InterruptedException ie) {
                throw new BapPublisherException(Messages.exception_retryDelayInterrupted(), ie);
            }
            return true;
        }

        private void beginTransfers() {
            this.client.beginTransfers((BPTransfer)this.remainingTransfers.get(0));
        }

        private void transfer() throws Exception {
            if (this.transferComplete) {
                return;
            }
            BPTransfer transfer = (BPTransfer)this.remainingTransfers.get(0);
            if (!transfer.hasConfiguredSourceFiles()) {
                this.transferred.add(0);
                this.transferComplete = true;
                return;
            }
            if (this.transferState == null) {
                this.transferred.add(transfer.transfer(this.buildInfo, this.client));
            } else {
                this.transferred.add(transfer.transfer(this.buildInfo, this.client, this.transferState));
            }
            this.transferComplete = true;
        }

        private void endTransfers() {
            this.client.endTransfers((BPTransfer)this.remainingTransfers.get(0));
            this.remainingTransfers.remove(0);
            this.transferState = null;
            this.transferComplete = false;
        }
    }
}

