/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.TreeMap;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.Messages;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BPBuildInfo
extends BPBuildEnv {
    private static final long serialVersionUID = 1L;
    public static final String PROMOTION_ENV_VARS_PREFIX = "promotion_";
    public static final String OVERRIDE_CREDENTIALS_CONTEXT_KEY = "credentials";
    private FilePath configDir;
    private TaskListener listener;
    private boolean verbose;
    private String consoleMsgPrefix;
    private BPBuildEnv currentBuildEnv;
    private BPBuildEnv targetBuildEnv;
    private final TreeMap<String, Serializable> context = new TreeMap();

    public BPBuildInfo() {
    }

    public BPBuildInfo(TaskListener listener, String consoleMsgPrefix, FilePath configDir, BPBuildEnv currentBuildEnv, BPBuildEnv targetBuildEnv) {
        this.listener = listener;
        this.consoleMsgPrefix = consoleMsgPrefix;
        this.configDir = configDir;
        this.currentBuildEnv = currentBuildEnv;
        this.targetBuildEnv = targetBuildEnv;
    }

    public FilePath getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(FilePath configDir) {
        this.configDir = configDir;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public void setListener(TaskListener listener) {
        this.listener = listener;
    }

    public String getConsoleMsgPrefix() {
        return this.consoleMsgPrefix;
    }

    public void setConsoleMsgPrefix(String consoleMsgPrefix) {
        this.consoleMsgPrefix = consoleMsgPrefix;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BPBuildEnv getCurrentBuildEnv() {
        return this.currentBuildEnv;
    }

    public void setCurrentBuildEnv(BPBuildEnv currentBuildEnv) {
        this.currentBuildEnv = currentBuildEnv;
    }

    public BPBuildEnv getTargetBuildEnv() {
        return this.targetBuildEnv;
    }

    public void setTargetBuildEnv(BPBuildEnv targetBuildEnv) {
        this.targetBuildEnv = targetBuildEnv;
    }

    public Serializable get(String key) {
        return this.context.get(key);
    }

    public void put(String key, Serializable value) {
        this.context.put(key, value);
    }

    public Serializable remove(String key) {
        return this.context.remove(key);
    }

    public boolean onMaster() {
        return !this.configDir.isRemote();
    }

    public byte[] readFileFromMaster(String filePath) {
        FilePath file = this.configDir.child(filePath);
        InputStream inputStream = null;
        try {
            inputStream = file.read();
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException | InterruptedException ioe) {
            throw new BapPublisherException(Messages.exception_readFile(filePath, ioe.getLocalizedMessage()), ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String getRelativePathToFile(FilePath filePath, String removePrefix) throws IOException, InterruptedException {
        String relativePathToFile = this.getRelativeDir(filePath, removePrefix);
        int lastDirIdx = relativePathToFile.lastIndexOf(47);
        if (lastDirIdx == -1) {
            return "";
        }
        return relativePathToFile.substring(0, lastDirIdx);
    }

    public String getRelativeDir(FilePath filePath, String removePrefix) throws IOException, InterruptedException {
        String normalizedPath = filePath.toURI().normalize().getPath();
        String relativePath = normalizedPath.replace(this.getNormalizedBaseDirectory(), "");
        if (Util.fixEmptyAndTrim((String)removePrefix) != null) {
            String expanded = Util.fixEmptyAndTrim((String)Util.replaceMacro((String)removePrefix.trim(), this.getEnvVars()));
            relativePath = this.removePrefix(relativePath, expanded);
        }
        return relativePath;
    }

    private String removePrefix(String relativePathToFile, String expandedPrefix) {
        if (expandedPrefix == null) {
            return relativePathToFile;
        }
        String toRemove = Util.fixEmptyAndTrim((String)FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)(expandedPrefix + "/"))));
        if (toRemove != null) {
            if (toRemove.charAt(0) == '/') {
                toRemove = toRemove.substring(1);
            }
            if (!relativePathToFile.startsWith(toRemove)) {
                throw new BapPublisherException(Messages.exception_removePrefix_noMatch(relativePathToFile, toRemove));
            }
            return relativePathToFile.substring(toRemove.length());
        }
        return relativePathToFile;
    }

    public void println(String message) {
        if (this.listener != null) {
            this.listener.getLogger().println(this.consoleMsgPrefix + message);
        }
    }

    public void printIfVerbose(String message) {
        if (this.verbose) {
            this.println(message);
        }
    }

    @Override
    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).append("currentBuildEnv", (Object)this.currentBuildEnv).append("targetBuildEnv", (Object)this.targetBuildEnv).toString();
    }
}

