/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractMavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public class MavenExecutionResultHandler
extends AbstractMavenEventHandler<MavenExecutionResult> {
    public MavenExecutionResultHandler(MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    protected boolean _handle(MavenExecutionResult result) {
        Xpp3Dom root = new Xpp3Dom("MavenExecutionResult");
        root.setAttribute("class", result.getClass().getName());
        for (MavenProject project : result.getTopologicallySortedProjects()) {
            BuildSummary summary = result.getBuildSummary(project);
            if (summary == null) {
                Xpp3Dom comment = new Xpp3Dom("comment");
                comment.setValue("No build summary found for maven project: " + project);
                root.addChild(comment);
                continue;
            }
            Xpp3Dom buildSummary = this.newElement("buildSummary", project);
            root.addChild(buildSummary);
            buildSummary.setAttribute("class", summary.getClass().getName());
            buildSummary.setAttribute("time", Long.toString(summary.getTime()));
        }
        this.reporter.print(root);
        return true;
    }
}

