/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.RuntimeIOException;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.MavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenEventHandler<E>
implements MavenEventHandler<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final MavenEventReporter reporter;
    private static final Pattern ANSI_PATTERN = Pattern.compile("\\x1b\\[[0-9;]*m");

    protected AbstractMavenEventHandler(MavenEventReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public boolean handle(Object event) {
        Type type = this.getSupportedType();
        Class clazz = (Class)type;
        if (clazz.isAssignableFrom(event.getClass())) {
            return this._handle(event);
        }
        return false;
    }

    private Type getSupportedType() {
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected abstract boolean _handle(E var1);

    public String toString() {
        return this.getClass().getName() + "[type=" + this.getSupportedType() + "]";
    }

    public Xpp3Dom newElement(String name, String value) {
        Xpp3Dom element = new Xpp3Dom(name);
        element.setValue(value);
        return element;
    }

    public Xpp3Dom newElement(@NonNull String name, @Nullable MavenProject project) {
        Build build;
        Xpp3Dom projectElt = new Xpp3Dom(name);
        if (project == null) {
            return projectElt;
        }
        projectElt.setAttribute("name", project.getName());
        projectElt.setAttribute("groupId", project.getGroupId());
        projectElt.setAttribute("artifactId", project.getArtifactId());
        projectElt.setAttribute("version", project.getVersion());
        projectElt.setAttribute("packaging", project.getPackaging());
        if (project.getBasedir() != null) {
            try {
                projectElt.setAttribute("baseDir", project.getBasedir().getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        if (project.getFile() != null) {
            String absolutePath;
            File projectFile = project.getFile();
            try {
                absolutePath = projectFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            if (!absolutePath.endsWith(File.separator + "pom.xml") && !absolutePath.endsWith(File.separator + ".flattened-pom.xml")) {
                if (absolutePath.endsWith(File.separator + "dependency-reduced-pom.xml")) {
                    absolutePath = absolutePath.replace(File.separator + "dependency-reduced-pom.xml", File.separator + "pom.xml");
                } else if (absolutePath.endsWith(File.separator + ".git-versioned-pom.xml")) {
                    absolutePath = absolutePath.replace(File.separator + ".git-versioned-pom.xml", File.separator + "pom.xml");
                } else {
                    String flattenedPomFilename = this.getMavenFlattenPluginFlattenedPomFilename(project);
                    if (flattenedPomFilename == null) {
                        this.logger.warn("[jenkins-event-spy] Unexpected Maven project file name '" + projectFile.getName() + "', problems may occur");
                    } else if (absolutePath.endsWith(File.separator + flattenedPomFilename)) {
                        absolutePath = absolutePath.replace(File.separator + flattenedPomFilename, File.separator + "pom.xml");
                    } else {
                        this.logger.warn("[jenkins-event-spy] Unexpected Maven project file name '" + projectFile.getName() + "', problems may occur");
                    }
                }
            }
            projectElt.setAttribute("file", absolutePath);
        }
        if ((build = project.getBuild()) != null) {
            Xpp3Dom buildElt = new Xpp3Dom("build");
            projectElt.addChild(buildElt);
            if (build.getOutputDirectory() != null) {
                buildElt.setAttribute("directory", build.getDirectory());
            }
            if (build.getSourceDirectory() != null) {
                buildElt.setAttribute("sourceDirectory", build.getSourceDirectory());
            }
        }
        return projectElt;
    }

    @Nullable
    protected String getMavenFlattenPluginFlattenedPomFilename(@NonNull MavenProject project) {
        for (Plugin buildPlugin : project.getBuildPlugins()) {
            Xpp3Dom configuration;
            Xpp3Dom flattenedPomFilename;
            if (!"org.codehaus.mojo:flatten-maven-plugin".equals(buildPlugin.getKey())) continue;
            String mavenConfigurationElement = "flattenedPomFilename";
            for (PluginExecution execution : buildPlugin.getExecutions()) {
                Xpp3Dom configuration2;
                Xpp3Dom flattenedPomFilename2;
                if (!execution.getGoals().contains("flatten") || !(execution.getConfiguration() instanceof Xpp3Dom) || (flattenedPomFilename2 = (configuration2 = (Xpp3Dom)execution.getConfiguration()).getChild(mavenConfigurationElement)) == null) continue;
                return flattenedPomFilename2.getValue();
            }
            if (!(buildPlugin.getConfiguration() instanceof Xpp3Dom) || (flattenedPomFilename = (configuration = (Xpp3Dom)buildPlugin.getConfiguration()).getChild(mavenConfigurationElement)) == null) continue;
            return flattenedPomFilename.getValue();
        }
        return null;
    }

    private static String removeAnsiColor(String input) {
        if (input != null) {
            input = ANSI_PATTERN.matcher(input).replaceAll("");
        }
        return input;
    }

    public Xpp3Dom newElement(@NonNull String name, @Nullable Throwable t) {
        Xpp3Dom rootElt = new Xpp3Dom(name);
        if (t == null) {
            return rootElt;
        }
        rootElt.setAttribute("class", t.getClass().getName());
        Xpp3Dom messageElt = new Xpp3Dom("message");
        rootElt.addChild(messageElt);
        messageElt.setValue(AbstractMavenEventHandler.removeAnsiColor(t.getMessage()));
        Xpp3Dom stackTraceElt = new Xpp3Dom("stackTrace");
        rootElt.addChild(stackTraceElt);
        StringWriter stackTrace = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)stackTrace, true));
        stackTraceElt.setValue(AbstractMavenEventHandler.removeAnsiColor(stackTrace.toString()));
        return rootElt;
    }

    public Xpp3Dom newElement(@NonNull String name, @Nullable File file) {
        Xpp3Dom element = new Xpp3Dom(name);
        try {
            element.setValue(file == null ? null : file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return element;
    }

    public Xpp3Dom newElement(@NonNull String name, @Nullable Artifact artifact) {
        Xpp3Dom element = new Xpp3Dom(name);
        if (artifact == null) {
            return element;
        }
        element.setAttribute("groupId", artifact.getGroupId());
        element.setAttribute("artifactId", artifact.getArtifactId());
        element.setAttribute("baseVersion", artifact.getBaseVersion());
        element.setAttribute("version", artifact.getVersion());
        element.setAttribute("snapshot", String.valueOf(artifact.isSnapshot()));
        if (artifact.getClassifier() != null) {
            element.setAttribute("classifier", artifact.getClassifier());
        }
        element.setAttribute("type", artifact.getType());
        element.setAttribute("id", artifact.getId());
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        String extension = artifactHandler == null ? artifact.getType() : artifactHandler.getExtension();
        element.setAttribute("extension", extension);
        return element;
    }
}

