/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.db.migration.h2;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;

public class MigrationStep10
implements MigrationStep {
    private static final Logger LOGGER = Logger.getLogger(MigrationStep10.class.getName());

    @Override
    public void execute(@NonNull Connection cnn, @NonNull MigrationStep.JenkinsDetails jenkinsDetails) throws SQLException {
        int count = 0;
        LOGGER.info("Upgrade table JENKINS_JOB...");
        try (PreparedStatement stmt = cnn.prepareStatement("SELECT * from JENKINS_JOB ORDER BY FULL_NAME");
             ResultSet rst = stmt.executeQuery();){
            while (rst.next()) {
                long jobPrimaryKey;
                Integer lastBuildNumber;
                if (++count < 100 && count % 10 == 0 || count < 500 && count % 20 == 0 || count % 50 == 0) {
                    LOGGER.log(Level.INFO, "#" + count + " - " + rst.getString("FULL_NAME") + "...");
                }
                if ((lastBuildNumber = this.findLastBuildNumber(cnn, jobPrimaryKey = rst.getLong("ID"))) == null) continue;
                this.updateJenkinsJobRecord(cnn, jobPrimaryKey, lastBuildNumber);
            }
        }
        LOGGER.info("Successfully upgraded table JENKINS_JOB, " + count + " records upgraded");
    }

    protected void updateJenkinsJobRecord(@NonNull Connection cnn, long jenkinsJobPrimaryKey, int lastBuildNumber) throws SQLException {
        try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where ID = ?");){
            stmt.setInt(1, lastBuildNumber);
            stmt.setInt(2, lastBuildNumber);
            stmt.setLong(3, jenkinsJobPrimaryKey);
            stmt.execute();
        }
    }

    @Nullable
    protected Integer findLastBuildNumber(@NonNull Connection cnn, long jobPrimaryKey) throws SQLException {
        try (PreparedStatement stmt2 = cnn.prepareStatement("SELECT * FROM JENKINS_BUILD WHERE JOB_ID = ? ORDER BY JENKINS_BUILD.NUMBER DESC LIMIT 1");){
            Integer n;
            block16: {
                ResultSet rst2;
                block14: {
                    Integer n2;
                    block15: {
                        stmt2.setLong(1, jobPrimaryKey);
                        rst2 = stmt2.executeQuery();
                        try {
                            if (!rst2.next()) break block14;
                            n2 = rst2.getInt("JENKINS_BUILD.NUMBER");
                            if (rst2 == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rst2 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rst2.close();
                    }
                    return n2;
                }
                n = null;
                if (rst2 == null) break block16;
                rst2.close();
            }
            return n;
        }
    }
}

