// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.support.steps.input;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code proceed}: {@code Proceed}.
     * 
     * @return
     *     {@code Proceed}
     */
    public static String proceed() {
        return holder.format("proceed");
    }

    /**
     * Key {@code proceed}: {@code Proceed}.
     * 
     * @return
     *     {@code Proceed}
     */
    public static Localizable _proceed() {
        return new Localizable(holder, "proceed");
    }

    /**
     * Key {@code abort}: {@code Abort}.
     * 
     * @return
     *     {@code Abort}
     */
    public static String abort() {
        return holder.format("abort");
    }

    /**
     * Key {@code abort}: {@code Abort}.
     * 
     * @return
     *     {@code Abort}
     */
    public static Localizable _abort() {
        return new Localizable(holder, "abort");
    }

    /**
     * Key {@code rejected}: {@code Rejected}.
     * 
     * @return
     *     {@code Rejected}
     */
    public static String rejected() {
        return holder.format("rejected");
    }

    /**
     * Key {@code rejected}: {@code Rejected}.
     * 
     * @return
     *     {@code Rejected}
     */
    public static Localizable _rejected() {
        return new Localizable(holder, "rejected");
    }

    /**
     * Key {@code pipeline_need_input}: {@code Pipeline has paused and needs
     * your input before proceeding}.
     * 
     * @return
     *     {@code Pipeline has paused and needs your input before proceeding}
     */
    public static String pipeline_need_input() {
        return holder.format("pipeline_need_input");
    }

    /**
     * Key {@code pipeline_need_input}: {@code Pipeline has paused and needs
     * your input before proceeding}.
     * 
     * @return
     *     {@code Pipeline has paused and needs your input before proceeding}
     */
    public static Localizable _pipeline_need_input() {
        return new Localizable(holder, "pipeline_need_input");
    }

    /**
     * Key {@code paused_for_input}: {@code Paused for Input}.
     * 
     * @return
     *     {@code Paused for Input}
     */
    public static String paused_for_input() {
        return holder.format("paused_for_input");
    }

    /**
     * Key {@code paused_for_input}: {@code Paused for Input}.
     * 
     * @return
     *     {@code Paused for Input}
     */
    public static Localizable _paused_for_input() {
        return new Localizable(holder, "paused_for_input");
    }

    /**
     * Key {@code wait_for_interactive_input}: {@code Wait for interactive
     * input}.
     * 
     * @return
     *     {@code Wait for interactive input}
     */
    public static String wait_for_interactive_input() {
        return holder.format("wait_for_interactive_input");
    }

    /**
     * Key {@code wait_for_interactive_input}: {@code Wait for interactive
     * input}.
     * 
     * @return
     *     {@code Wait for interactive input}
     */
    public static Localizable _wait_for_interactive_input() {
        return new Localizable(holder, "wait_for_interactive_input");
    }

    /**
     * Key {@code rejected_by}: {@code Rejected by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Rejected by {0}}
     */
    public static String rejected_by(Object arg0) {
        return holder.format("rejected_by", arg0);
    }

    /**
     * Key {@code rejected_by}: {@code Rejected by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Rejected by {0}}
     */
    public static Localizable _rejected_by(Object arg0) {
        return new Localizable(holder, "rejected_by", arg0);
    }

    /**
     * Key {@code input_submitted}: {@code Input Submitted}.
     * 
     * @return
     *     {@code Input Submitted}
     */
    public static String input_submitted() {
        return holder.format("input_submitted");
    }

    /**
     * Key {@code input_submitted}: {@code Input Submitted}.
     * 
     * @return
     *     {@code Input Submitted}
     */
    public static Localizable _input_submitted() {
        return new Localizable(holder, "input_submitted");
    }

}
