// CHECKSTYLE:OFF

package hudson.plugins.performance;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildAction.DisplayName}: {@code Performance Report}.
     * 
     * @return
     *     {@code Performance Report}
     */
    public static String BuildAction_DisplayName() {
        return holder.format("BuildAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.DisplayName}: {@code Performance Report}.
     * 
     * @return
     *     {@code Performance Report}
     */
    public static Localizable _BuildAction_DisplayName() {
        return new Localizable(holder, "BuildAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.TotalTrafficKB}: {@code total kb}.
     * 
     * @return
     *     {@code total kb}
     */
    public static String ProjectAction_TotalTrafficKB() {
        return holder.format("ProjectAction.TotalTrafficKB");
    }

    /**
     * Key {@code ProjectAction.TotalTrafficKB}: {@code total kb}.
     * 
     * @return
     *     {@code total kb}
     */
    public static Localizable _ProjectAction_TotalTrafficKB() {
        return new Localizable(holder, "ProjectAction.TotalTrafficKB");
    }

    /**
     * Key {@code Publisher.DisplayName}: {@code Publish Performance test
     * result report}.
     * 
     * @return
     *     {@code Publish Performance test result report}
     */
    public static String Publisher_DisplayName() {
        return holder.format("Publisher.DisplayName");
    }

    /**
     * Key {@code Publisher.DisplayName}: {@code Publish Performance test
     * result report}.
     * 
     * @return
     *     {@code Publish Performance test result report}
     */
    public static Localizable _Publisher_DisplayName() {
        return new Localizable(holder, "Publisher.DisplayName");
    }

    /**
     * Key {@code TrendReportDetail_ResponseTimePercentiles}: {@code Response
     * Time Percentiles}.
     * 
     * @return
     *     {@code Response Time Percentiles}
     */
    public static String TrendReportDetail_ResponseTimePercentiles() {
        return holder.format("TrendReportDetail_ResponseTimePercentiles");
    }

    /**
     * Key {@code TrendReportDetail_ResponseTimePercentiles}: {@code Response
     * Time Percentiles}.
     * 
     * @return
     *     {@code Response Time Percentiles}
     */
    public static Localizable _TrendReportDetail_ResponseTimePercentiles() {
        return new Localizable(holder, "TrendReportDetail_ResponseTimePercentiles");
    }

    /**
     * Key {@code PerformanceTest.Name}: {@code Run Performance Test}.
     * 
     * @return
     *     {@code Run Performance Test}
     */
    public static String PerformanceTest_Name() {
        return holder.format("PerformanceTest.Name");
    }

    /**
     * Key {@code PerformanceTest.Name}: {@code Run Performance Test}.
     * 
     * @return
     *     {@code Run Performance Test}
     */
    public static Localizable _PerformanceTest_Name() {
        return new Localizable(holder, "PerformanceTest.Name");
    }

    /**
     * Key {@code GraphConfigurationDetail.DisplayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static String GraphConfigurationDetail_DisplayName() {
        return holder.format("GraphConfigurationDetail.DisplayName");
    }

    /**
     * Key {@code GraphConfigurationDetail.DisplayName}: {@code Configure}.
     * 
     * @return
     *     {@code Configure}
     */
    public static Localizable _GraphConfigurationDetail_DisplayName() {
        return new Localizable(holder, "GraphConfigurationDetail.DisplayName");
    }

    /**
     * Key {@code TrendReportDetail.Percent}: {@code Percent}.
     * 
     * @return
     *     {@code Percent}
     */
    public static String TrendReportDetail_Percent() {
        return holder.format("TrendReportDetail.Percent");
    }

    /**
     * Key {@code TrendReportDetail.Percent}: {@code Percent}.
     * 
     * @return
     *     {@code Percent}
     */
    public static Localizable _TrendReportDetail_Percent() {
        return new Localizable(holder, "TrendReportDetail.Percent");
    }

    /**
     * Key {@code ProjectAction.Average}: {@code average}.
     * 
     * @return
     *     {@code average}
     */
    public static String ProjectAction_Average() {
        return holder.format("ProjectAction.Average");
    }

    /**
     * Key {@code ProjectAction.Average}: {@code average}.
     * 
     * @return
     *     {@code average}
     */
    public static Localizable _ProjectAction_Average() {
        return new Localizable(holder, "ProjectAction.Average");
    }

    /**
     * Key {@code TestSuiteReportDetail.DisplayName}: {@code Test Suite
     * report}.
     * 
     * @return
     *     {@code Test Suite report}
     */
    public static String TestSuiteReportDetail_DisplayName() {
        return holder.format("TestSuiteReportDetail.DisplayName");
    }

    /**
     * Key {@code TestSuiteReportDetail.DisplayName}: {@code Test Suite
     * report}.
     * 
     * @return
     *     {@code Test Suite report}
     */
    public static Localizable _TestSuiteReportDetail_DisplayName() {
        return new Localizable(holder, "TestSuiteReportDetail.DisplayName");
    }

    /**
     * Key {@code ProjectAction.PercentageOfFailedTests}: {@code Percentage
     * of failed tests}.
     * 
     * @return
     *     {@code Percentage of failed tests}
     */
    public static String ProjectAction_PercentageOfFailedTests() {
        return holder.format("ProjectAction.PercentageOfFailedTests");
    }

    /**
     * Key {@code ProjectAction.PercentageOfFailedTests}: {@code Percentage
     * of failed tests}.
     * 
     * @return
     *     {@code Percentage of failed tests}
     */
    public static Localizable _ProjectAction_PercentageOfFailedTests() {
        return new Localizable(holder, "ProjectAction.PercentageOfFailedTests");
    }

    /**
     * Key {@code CsvParser.validation.patternEmpty}: {@code Pattern is
     * required}.
     * 
     * @return
     *     {@code Pattern is required}
     */
    public static String CsvParser_validation_patternEmpty() {
        return holder.format("CsvParser.validation.patternEmpty");
    }

    /**
     * Key {@code CsvParser.validation.patternEmpty}: {@code Pattern is
     * required}.
     * 
     * @return
     *     {@code Pattern is required}
     */
    public static Localizable _CsvParser_validation_patternEmpty() {
        return new Localizable(holder, "CsvParser.validation.patternEmpty");
    }

    /**
     * Key {@code TrendReportDetail.DisplayName}: {@code Trend report}.
     * 
     * @return
     *     {@code Trend report}
     */
    public static String TrendReportDetail_DisplayName() {
        return holder.format("TrendReportDetail.DisplayName");
    }

    /**
     * Key {@code TrendReportDetail.DisplayName}: {@code Trend report}.
     * 
     * @return
     *     {@code Trend report}
     */
    public static Localizable _TrendReportDetail_DisplayName() {
        return new Localizable(holder, "TrendReportDetail.DisplayName");
    }

    /**
     * Key {@code CsvParser.validation.MissingFields}: {@code Missing
     * required fields}.
     * 
     * @return
     *     {@code Missing required fields}
     */
    public static String CsvParser_validation_MissingFields() {
        return holder.format("CsvParser.validation.MissingFields");
    }

    /**
     * Key {@code CsvParser.validation.MissingFields}: {@code Missing
     * required fields}.
     * 
     * @return
     *     {@code Missing required fields}
     */
    public static Localizable _CsvParser_validation_MissingFields() {
        return new Localizable(holder, "CsvParser.validation.MissingFields");
    }

    /**
     * Key {@code PerformanceTest.Config}: {@code Performance Test}.
     * 
     * @return
     *     {@code Performance Test}
     */
    public static String PerformanceTest_Config() {
        return holder.format("PerformanceTest.Config");
    }

    /**
     * Key {@code PerformanceTest.Config}: {@code Performance Test}.
     * 
     * @return
     *     {@code Performance Test}
     */
    public static Localizable _PerformanceTest_Config() {
        return new Localizable(holder, "PerformanceTest.Config");
    }

    /**
     * Key {@code ProjectAction.AverageKB}: {@code average kb}.
     * 
     * @return
     *     {@code average kb}
     */
    public static String ProjectAction_AverageKB() {
        return holder.format("ProjectAction.AverageKB");
    }

    /**
     * Key {@code ProjectAction.AverageKB}: {@code average kb}.
     * 
     * @return
     *     {@code average kb}
     */
    public static Localizable _ProjectAction_AverageKB() {
        return new Localizable(holder, "ProjectAction.AverageKB");
    }

    /**
     * Key {@code TrendReportDetail.ResponseTime}: {@code Response Time
     * (ms)}.
     * 
     * @return
     *     {@code Response Time (ms)}
     */
    public static String TrendReportDetail_ResponseTime() {
        return holder.format("TrendReportDetail.ResponseTime");
    }

    /**
     * Key {@code TrendReportDetail.ResponseTime}: {@code Response Time
     * (ms)}.
     * 
     * @return
     *     {@code Response Time (ms)}
     */
    public static Localizable _TrendReportDetail_ResponseTime() {
        return new Localizable(holder, "TrendReportDetail.ResponseTime");
    }

    /**
     * Key {@code ProjectAction.Throughput}: {@code Throughput}.
     * 
     * @return
     *     {@code Throughput}
     */
    public static String ProjectAction_Throughput() {
        return holder.format("ProjectAction.Throughput");
    }

    /**
     * Key {@code ProjectAction.Throughput}: {@code Throughput}.
     * 
     * @return
     *     {@code Throughput}
     */
    public static Localizable _ProjectAction_Throughput() {
        return new Localizable(holder, "ProjectAction.Throughput");
    }

    /**
     * Key {@code ProjectAction.RequestsPerSeconds}: {@code Requests Per
     * Second}.
     * 
     * @return
     *     {@code Requests Per Second}
     */
    public static String ProjectAction_RequestsPerSeconds() {
        return holder.format("ProjectAction.RequestsPerSeconds");
    }

    /**
     * Key {@code ProjectAction.RequestsPerSeconds}: {@code Requests Per
     * Second}.
     * 
     * @return
     *     {@code Requests Per Second}
     */
    public static Localizable _ProjectAction_RequestsPerSeconds() {
        return new Localizable(holder, "ProjectAction.RequestsPerSeconds");
    }

    /**
     * Key {@code Report.DisplayName}: {@code Performance}.
     * 
     * @return
     *     {@code Performance}
     */
    public static String Report_DisplayName() {
        return holder.format("Report.DisplayName");
    }

    /**
     * Key {@code Report.DisplayName}: {@code Performance}.
     * 
     * @return
     *     {@code Performance}
     */
    public static Localizable _Report_DisplayName() {
        return new Localizable(holder, "Report.DisplayName");
    }

    /**
     * Key {@code ProjectAction.Minimum}: {@code min}.
     * 
     * @return
     *     {@code min}
     */
    public static String ProjectAction_Minimum() {
        return holder.format("ProjectAction.Minimum");
    }

    /**
     * Key {@code ProjectAction.Minimum}: {@code min}.
     * 
     * @return
     *     {@code min}
     */
    public static Localizable _ProjectAction_Minimum() {
        return new Localizable(holder, "ProjectAction.Minimum");
    }

    /**
     * Key {@code ProjectAction.Errors}: {@code errors}.
     * 
     * @return
     *     {@code errors}
     */
    public static String ProjectAction_Errors() {
        return holder.format("ProjectAction.Errors");
    }

    /**
     * Key {@code ProjectAction.Errors}: {@code errors}.
     * 
     * @return
     *     {@code errors}
     */
    public static Localizable _ProjectAction_Errors() {
        return new Localizable(holder, "ProjectAction.Errors");
    }

    /**
     * Key {@code ProjectAction.Maximum}: {@code max}.
     * 
     * @return
     *     {@code max}
     */
    public static String ProjectAction_Maximum() {
        return holder.format("ProjectAction.Maximum");
    }

    /**
     * Key {@code ProjectAction.Maximum}: {@code max}.
     * 
     * @return
     *     {@code max}
     */
    public static Localizable _ProjectAction_Maximum() {
        return new Localizable(holder, "ProjectAction.Maximum");
    }

    /**
     * Key {@code TrendReportDetail.Time}: {@code Time}.
     * 
     * @return
     *     {@code Time}
     */
    public static String TrendReportDetail_Time() {
        return holder.format("TrendReportDetail.Time");
    }

    /**
     * Key {@code TrendReportDetail.Time}: {@code Time}.
     * 
     * @return
     *     {@code Time}
     */
    public static Localizable _TrendReportDetail_Time() {
        return new Localizable(holder, "TrendReportDetail.Time");
    }

    /**
     * Key {@code TrendReportDetail.RequestsPerMinute}: {@code Requests Per
     * Minute}.
     * 
     * @return
     *     {@code Requests Per Minute}
     */
    public static String TrendReportDetail_RequestsPerMinute() {
        return holder.format("TrendReportDetail.RequestsPerMinute");
    }

    /**
     * Key {@code TrendReportDetail.RequestsPerMinute}: {@code Requests Per
     * Minute}.
     * 
     * @return
     *     {@code Requests Per Minute}
     */
    public static Localizable _TrendReportDetail_RequestsPerMinute() {
        return new Localizable(holder, "TrendReportDetail.RequestsPerMinute");
    }

    /**
     * Key {@code ProjectAction.Line95}: {@code 95% line}.
     * 
     * @return
     *     {@code 95% line}
     */
    public static String ProjectAction_Line95() {
        return holder.format("ProjectAction.Line95");
    }

    /**
     * Key {@code ProjectAction.Line95}: {@code 95% line}.
     * 
     * @return
     *     {@code 95% line}
     */
    public static Localizable _ProjectAction_Line95() {
        return new Localizable(holder, "ProjectAction.Line95");
    }

    /**
     * Key {@code ProjectAction.Line90}: {@code 90% line}.
     * 
     * @return
     *     {@code 90% line}
     */
    public static String ProjectAction_Line90() {
        return holder.format("ProjectAction.Line90");
    }

    /**
     * Key {@code ProjectAction.Line90}: {@code 90% line}.
     * 
     * @return
     *     {@code 90% line}
     */
    public static Localizable _ProjectAction_Line90() {
        return new Localizable(holder, "ProjectAction.Line90");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Performance Trend}.
     * 
     * @return
     *     {@code Performance Trend}
     */
    public static String ProjectAction_DisplayName() {
        return holder.format("ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Performance Trend}.
     * 
     * @return
     *     {@code Performance Trend}
     */
    public static Localizable _ProjectAction_DisplayName() {
        return new Localizable(holder, "ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.PercentageOfErrors}: {@code Percentage of
     * errors}.
     * 
     * @return
     *     {@code Percentage of errors}
     */
    public static String ProjectAction_PercentageOfErrors() {
        return holder.format("ProjectAction.PercentageOfErrors");
    }

    /**
     * Key {@code ProjectAction.PercentageOfErrors}: {@code Percentage of
     * errors}.
     * 
     * @return
     *     {@code Percentage of errors}
     */
    public static Localizable _ProjectAction_PercentageOfErrors() {
        return new Localizable(holder, "ProjectAction.PercentageOfErrors");
    }

    /**
     * Key {@code TrendReportDetail.RequestThroughput}: {@code Request
     * Throughput}.
     * 
     * @return
     *     {@code Request Throughput}
     */
    public static String TrendReportDetail_RequestThroughput() {
        return holder.format("TrendReportDetail.RequestThroughput");
    }

    /**
     * Key {@code TrendReportDetail.RequestThroughput}: {@code Request
     * Throughput}.
     * 
     * @return
     *     {@code Request Throughput}
     */
    public static Localizable _TrendReportDetail_RequestThroughput() {
        return new Localizable(holder, "TrendReportDetail.RequestThroughput");
    }

    /**
     * Key {@code ProjectAction.Median}: {@code median}.
     * 
     * @return
     *     {@code median}
     */
    public static String ProjectAction_Median() {
        return holder.format("ProjectAction.Median");
    }

    /**
     * Key {@code ProjectAction.Median}: {@code median}.
     * 
     * @return
     *     {@code median}
     */
    public static Localizable _ProjectAction_Median() {
        return new Localizable(holder, "ProjectAction.Median");
    }

    /**
     * Key {@code CsvParser.validation.delimiterEmpty}: {@code Delimiter
     * can't be empty}.
     * 
     * @return
     *     {@code Delimiter can't be empty}
     */
    public static String CsvParser_validation_delimiterEmpty() {
        return holder.format("CsvParser.validation.delimiterEmpty");
    }

    /**
     * Key {@code CsvParser.validation.delimiterEmpty}: {@code Delimiter
     * can't be empty}.
     * 
     * @return
     *     {@code Delimiter can't be empty}
     */
    public static Localizable _CsvParser_validation_delimiterEmpty() {
        return new Localizable(holder, "CsvParser.validation.delimiterEmpty");
    }

    /**
     * Key {@code ProjectAction.RespondingTime}: {@code Response time}.
     * 
     * @return
     *     {@code Response time}
     */
    public static String ProjectAction_RespondingTime() {
        return holder.format("ProjectAction.RespondingTime");
    }

    /**
     * Key {@code ProjectAction.RespondingTime}: {@code Response time}.
     * 
     * @return
     *     {@code Response time}
     */
    public static Localizable _ProjectAction_RespondingTime() {
        return new Localizable(holder, "ProjectAction.RespondingTime");
    }

}
