/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.scheduler.Hash;
import hudson.triggers.Trigger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTabList;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedStaplerRequest;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTriggerCause;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class ParameterizedTimerTrigger
extends Trigger<Job> {
    private static final Logger LOGGER = Logger.getLogger(ParameterizedTimerTrigger.class.getName());
    private transient ParameterizedCronTabList cronTabList;
    private final String parameterizedSpecification;

    @DataBoundConstructor
    public ParameterizedTimerTrigger(String parameterizedSpecification) {
        this.parameterizedSpecification = parameterizedSpecification;
        this.cronTabList = ParameterizedCronTabList.create(parameterizedSpecification);
    }

    public ParameterizedCronTabList getCronTabList() {
        return this.cronTabList;
    }

    public void run() {
        LOGGER.fine("tried to run from base Trigger, nothing will happen");
    }

    private List<ParameterValue> configurePropertyValues(Map<String, String> parameterValues) {
        assert (this.job != null) : "job must not be null if this was 'started'";
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)((Job)this.job).getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (parameterValues.containsKey(paramDefinition.getName())) {
                ParameterizedStaplerRequest request = new ParameterizedStaplerRequest(parameterValues.get(paramDefinition.getName()));
                ParameterValue value = paramDefinition.createValue((StaplerRequest2)request);
                if (value != null) {
                    defValues.add(value);
                    continue;
                }
                LOGGER.warning("Cannot create value for " + paramDefinition.getName());
                continue;
            }
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public void checkCronTabsAndRun(Calendar calendar) {
        LOGGER.fine("checking and maybe running at " + String.valueOf(calendar));
        List<ParameterizedCronTab> cronTabs = this.cronTabList.check(calendar);
        cronTabs.forEach(cronTab -> {
            Map<String, String> parameterValues = cronTab.getParameterValues();
            ParametersAction parametersAction = new ParametersAction(this.configurePropertyValues(parameterValues));
            assert (this.job != null) : "job must not be null, if this was 'started'";
            if (this.job instanceof AbstractProject) {
                ((AbstractProject)this.job).scheduleBuild2(0, (Cause)null, new Action[]{this.causeAction(parameterValues), parametersAction});
            } else if (this.job instanceof WorkflowJob) {
                ((WorkflowJob)this.job).scheduleBuild2(0, new Action[]{this.causeAction(parameterValues), parametersAction});
            }
        });
    }

    private CauseAction causeAction(Map<String, String> parameterValues) {
        return new CauseAction((Cause)new ParameterizedTimerTriggerCause(parameterValues));
    }

    public void start(Job project, boolean newInstance) {
        this.job = project;
        try {
            this.cronTabList = ParameterizedCronTabList.create(this.parameterizedSpecification, Hash.from((String)project.getFullName()));
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, "Failed to parse crontab spec: " + this.spec, e);
        }
    }

    public String getParameterizedSpecification() {
        return this.parameterizedSpecification;
    }
}

