/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersDefinitionProperty;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parameterizedscheduler.Messages;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterParser;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTabList;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"parameterizedCron"})
public class DescriptorImpl
extends TriggerDescriptor {
    public DescriptorImpl() {
        super(ParameterizedTimerTrigger.class);
    }

    public boolean isApplicable(Item item) {
        boolean result = false;
        if (item instanceof AbstractProject) {
            result = ((AbstractProject)item).isParameterized();
        } else if (item instanceof WorkflowJob) {
            result = ((WorkflowJob)item).isParameterized();
        }
        return result;
    }

    @NonNull
    public String getDisplayName() {
        return Messages.ParameterizedTimerTrigger_DisplayName();
    }

    @POST
    public FormValidation doCheckParameterizedSpecification(@QueryParameter String value, @AncestorInPath Job<?, ?> job) {
        job.checkPermission(Item.CONFIGURE);
        try {
            String msg = ParameterizedCronTabList.create(Util.fixNull((String)value)).checkSanity();
            if (msg != null) {
                return FormValidation.warning((String)msg);
            }
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            msg = new ParameterParser().checkSanity(value, paramDefProp);
            if (msg != null) {
                return FormValidation.warning((String)msg);
            }
            return FormValidation.ok();
        }
        catch (IllegalArgumentException e) {
            if (value.trim().indexOf(10) == -1 && value.contains("**")) {
                return FormValidation.error((String)Messages.ParameterizedTimerTrigger_MissingWhitespace());
            }
            return FormValidation.error((String)e.getMessage());
        }
    }
}

