/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;

public class ParameterizedCronTabList {
    private final List<ParameterizedCronTab> cronTabs;

    public ParameterizedCronTabList(List<ParameterizedCronTab> cronTabs) {
        this.cronTabs = cronTabs;
    }

    public static ParameterizedCronTabList create(String cronTabSpecification) {
        return ParameterizedCronTabList.create(cronTabSpecification, null);
    }

    public static ParameterizedCronTabList create(String cronTabSpecification, Hash hash) {
        ArrayList<ParameterizedCronTab> result = new ArrayList<ParameterizedCronTab>();
        int lineNumber = 0;
        String timezone = null;
        for (String line : cronTabSpecification.split("\\r?\\n")) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            if (++lineNumber == 1 && line.startsWith("TZ=")) {
                timezone = CronTabList.getValidTimezone((String)line.replace("TZ=", ""));
                if (timezone != null) continue;
                throw new IllegalArgumentException("Invalid or unsupported timezone '" + line + "'");
            }
            try {
                result.add(ParameterizedCronTab.create(line, lineNumber, hash, timezone));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid input: \"%s\": %s", line, e), e);
            }
        }
        return new ParameterizedCronTabList(result);
    }

    public List<ParameterizedCronTab> check(Calendar calendar) {
        return this.cronTabs.stream().filter(tab -> tab.check(calendar)).collect(Collectors.toList());
    }

    public String checkSanity() {
        for (ParameterizedCronTab tab : this.cronTabs) {
            String s = tab.checkSanity();
            if (s == null) continue;
            return s;
        }
        return null;
    }
}

