/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.parameter_separator;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ParameterValue;
import jenkins.plugins.parameter_separator.Utils;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ParameterSeparatorValue
extends ParameterValue {
    @Nullable
    private final String separatorStyle;
    @Nullable
    private final String sectionHeader;
    @Nullable
    private final String sectionHeaderStyle;

    @DataBoundConstructor
    public ParameterSeparatorValue(String name, String separatorStyle, String sectionHeader, String sectionHeaderStyle) {
        super(name);
        this.separatorStyle = Strings.emptyToNull((String)separatorStyle);
        this.sectionHeader = Strings.emptyToNull((String)sectionHeader);
        this.sectionHeaderStyle = Strings.emptyToNull((String)sectionHeaderStyle);
    }

    public String getEffectiveSeparatorStyle() {
        return Utils.getEffectiveSeparatorStyle(this.separatorStyle);
    }

    public boolean needsSectionHeader() {
        return this.sectionHeader != null;
    }

    public String getFormattedSectionHeader() {
        return Utils.getFormattedSectionHeader(this.sectionHeader);
    }

    public String getEffectiveSectionHeaderStyle() {
        return Utils.getEffectiveSectionHeaderStyle(this.sectionHeaderStyle);
    }

    public String toString() {
        return "(ParameterSeparatorValue) " + this.getName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    public String getValue() {
        return "";
    }
}

