/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.credentials;

import com.oracle.cloud.baremetal.jenkins.credentials.BaremetalCloudCredentials;
import com.oracle.cloud.baremetal.jenkins.credentials.OciConfigWriter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BaremetalCloudCredentialsBinding
extends MultiBinding<BaremetalCloudCredentials> {
    public static final String ENV_PASSPHRASE = "OCI_PASSPHRASE";
    public static final String ENV_USER_ID = "OCI_USER_ID";
    public static final String ENV_FINGERPRINT = "OCI_FINGERPRINT";
    public static final String ENV_TENANT_ID = "OCI_TENANT_ID";
    public static final String ENV_REGION_ID = "OCI_REGION_ID";
    public static final String ENV_API_KEY = "OCI_API_KEY";
    public static final String ENV_CONFIG_FILE = "OCI_CONFIG_FILE";

    @DataBoundConstructor
    public BaremetalCloudCredentialsBinding(String credentialsId) {
        super(credentialsId);
    }

    protected Class<BaremetalCloudCredentials> type() {
        return BaremetalCloudCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        BaremetalCloudCredentials credentials = (BaremetalCloudCredentials)this.getCredentials(build);
        OciConfigWriter writer = new OciConfigWriter(credentials.getUserId(), credentials.getFingerprint(), credentials.getTenantId(), credentials.getRegionId(), credentials.getApikey());
        HashMap<String, String> secretValues = new HashMap<String, String>();
        secretValues.put(ENV_PASSPHRASE, credentials.getPassphrase());
        return new MultiBinding.MultiEnvironment(secretValues, (Map)workspace.act((FilePath.FileCallable)writer.asCallable()));
    }

    @Symbol(value={"ociCredentials"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<BaremetalCloudCredentials> {
        protected Class<BaremetalCloudCredentials> type() {
            return BaremetalCloudCredentials.class;
        }

        public String getDisplayName() {
            return "OCI Credentials";
        }

        public boolean requiresWorkspace() {
            return true;
        }
    }
}

