/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.client;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.core.ComputeAsyncClient;
import com.oracle.bmc.core.ComputeClient;
import com.oracle.bmc.core.ComputeWaiters;
import com.oracle.bmc.core.VirtualNetworkAsyncClient;
import com.oracle.bmc.core.VirtualNetworkClient;
import com.oracle.bmc.core.model.CreateVnicDetails;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceOptions;
import com.oracle.bmc.core.model.InstanceSourceDetails;
import com.oracle.bmc.core.model.InstanceSourceViaImageDetails;
import com.oracle.bmc.core.model.LaunchInstanceDetails;
import com.oracle.bmc.core.model.LaunchInstanceShapeConfigDetails;
import com.oracle.bmc.core.model.NetworkSecurityGroup;
import com.oracle.bmc.core.model.Shape;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.InstanceActionRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListNetworkSecurityGroupsRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListSubnetsRequest;
import com.oracle.bmc.core.requests.ListVcnsRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.InstanceActionResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListNetworkSecurityGroupsResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListSubnetsResponse;
import com.oracle.bmc.core.responses.ListVcnsResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.TerminateInstanceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.identity.IdentityAsyncClient;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.AvailabilityDomain;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.TagNamespaceSummary;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.requests.GetUserRequest;
import com.oracle.bmc.identity.requests.ListAvailabilityDomainsRequest;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListTagNamespacesRequest;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.identity.responses.ListAvailabilityDomainsResponse;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListTagNamespacesResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgentTemplate;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudNsgTemplate;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudTagsTemplate;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.client.HTTPProxyConfigurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;

public class SDKBaremetalCloudClient
implements BaremetalCloudClient {
    private static final Logger LOGGER = Logger.getLogger(SDKBaremetalCloudClient.class.getName());
    private BasicAuthenticationDetailsProvider provider;
    private String regionId;
    private ClientConfiguration clientConfig;
    private boolean instancePrincipals;
    private String tenantId;
    private String userId;

    public SDKBaremetalCloudClient(BasicAuthenticationDetailsProvider provider, String regionId, int maxAsyncThreads, String tenantId, String userId) {
        this.provider = provider;
        this.regionId = regionId;
        this.tenantId = tenantId;
        this.userId = userId;
        this.clientConfig = ClientConfiguration.builder().retryConfiguration(RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION).maxAsyncThreads(Integer.valueOf(maxAsyncThreads)).build();
        ClientRuntime.setClientUserAgent((String)("Oracle-Jenkins/" + Jenkins.VERSION));
    }

    public SDKBaremetalCloudClient(BasicAuthenticationDetailsProvider provider, String regionId, int maxAsyncThreads, String tenantId) {
        this(provider, regionId, maxAsyncThreads, tenantId, null);
    }

    public SDKBaremetalCloudClient(SimpleAuthenticationDetailsProvider provider, String regionId, int maxAsyncThreads) {
        this((BasicAuthenticationDetailsProvider)provider, regionId, maxAsyncThreads, provider.getTenantId(), provider.getUserId());
    }

    protected IdentityClient getIdentityClient() {
        IdentityClient identityClient = new IdentityClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        identityClient.setRegion(this.regionId);
        return identityClient;
    }

    private IdentityAsyncClient getIdentityAsyncClient() {
        IdentityAsyncClient identityClient = new IdentityAsyncClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        identityClient.setRegion(this.regionId);
        return identityClient;
    }

    private ComputeClient getComputeClient() {
        ComputeClient computeClient = new ComputeClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        computeClient.setRegion(this.regionId);
        return computeClient;
    }

    private ComputeAsyncClient getComputeAsyncClient() {
        ComputeAsyncClient computeClient = new ComputeAsyncClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        computeClient.setRegion(this.regionId);
        return computeClient;
    }

    private VirtualNetworkClient getVirtualNetworkClient() {
        VirtualNetworkClient networkClient = new VirtualNetworkClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        networkClient.setRegion(this.regionId);
        return networkClient;
    }

    private VirtualNetworkAsyncClient getVirtualNetworkAsyncClient() {
        VirtualNetworkAsyncClient networkClient = new VirtualNetworkAsyncClient(this.provider, this.clientConfig, (ClientConfigurator)new HTTPProxyConfigurator());
        networkClient.setRegion(this.regionId);
        return networkClient;
    }

    @Override
    public void authenticate() throws BmcException {
        IdentityClient identityClient = this.getIdentityClient();
        try {
            if (this.userId != null) {
                identityClient.getUser(GetUserRequest.builder().userId(this.userId).build());
            } else {
                identityClient.getTenancy(GetTenancyRequest.builder().tenancyId(this.tenantId).build());
            }
        }
        catch (BmcException e) {
            LOGGER.log(Level.FINE, "Failed to connect to Oracle Cloud Infrastructure. Please verify all credential information.", e);
            throw e;
        }
        finally {
            try {
                identityClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Instance createInstance(String name, BaremetalCloudAgentTemplate template) throws Exception {
        Instance instance;
        block21: {
            Instance instance2 = null;
            ComputeClient computeClient = this.getComputeClient();
            try {
                String ad = template.getAvailableDomain();
                String compartmentIdStr = template.getCompartmentId();
                String subnetIdStr = template.getSubnet();
                String imageIdStr = template.getImageId();
                String shape = template.getShape();
                String sshPublicKey = template.getPublicKey();
                boolean assignPublicIP = true;
                if (template.getAssignPublicIP() != null) {
                    assignPublicIP = template.getAssignPublicIP();
                }
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("ssh_authorized_keys", sshPublicKey);
                GetSubnetResponse subnetResponse = this.getSubNet(subnetIdStr);
                if (subnetResponse.getSubnet().getProhibitPublicIpOnVnic().booleanValue()) {
                    assignPublicIP = false;
                }
                LaunchInstanceShapeConfigDetails shapeConfig = null;
                if (!template.getNumberOfOcpus().isEmpty() && !template.getMemoryInGBs().isEmpty()) {
                    shapeConfig = LaunchInstanceShapeConfigDetails.builder().ocpus(Float.valueOf(Float.parseFloat(template.getNumberOfOcpus()))).memoryInGBs(Float.valueOf(Float.parseFloat(template.getMemoryInGBs()))).build();
                }
                List<Object> nsgIds = new ArrayList();
                if (template.getNsgIds() != null && !template.getNsgIds().isEmpty()) {
                    nsgIds = template.getNsgIds().stream().map(BaremetalCloudNsgTemplate::getNsgId).collect(Collectors.toList());
                }
                InstanceOptions launchoptions = InstanceOptions.builder().areLegacyImdsEndpointsDisabled(template.getDisableLegacyImdsEndpoint()).build();
                LaunchInstanceDetails.Builder instanceDetailsBuilder = LaunchInstanceDetails.builder().availabilityDomain(ad).compartmentId(compartmentIdStr).createVnicDetails(CreateVnicDetails.builder().assignPublicIp(Boolean.valueOf(assignPublicIP)).subnetId(subnetIdStr).nsgIds(nsgIds).build()).displayName(name).sourceDetails((InstanceSourceDetails)InstanceSourceViaImageDetails.builder().bootVolumeVpusPerGB(Long.valueOf(template.getBootVolumeVPUs())).imageId(imageIdStr).build()).metadata(metadata).shape(shape).shapeConfig(shapeConfig).subnetId(subnetIdStr).instanceOptions(launchoptions);
                if (template.getTags() != null) {
                    HashMap<String, String> freeFormTags = new HashMap<String, String>();
                    HashMap definedTags = new HashMap();
                    for (BaremetalCloudTagsTemplate tag : template.getTags()) {
                        if (tag.getNamespace().equals("None")) {
                            freeFormTags.put(tag.getKey(), tag.getValue());
                            continue;
                        }
                        Map<String, String> definedTag = new HashMap<String, String>();
                        if (definedTags.containsKey(tag.getNamespace())) {
                            definedTag = (Map)definedTags.get(tag.getNamespace());
                        }
                        definedTag.put(tag.getKey(), tag.getValue());
                        definedTags.put(tag.getNamespace(), definedTag);
                    }
                    if (!freeFormTags.isEmpty()) {
                        instanceDetailsBuilder.freeformTags(freeFormTags);
                    }
                    if (!definedTags.isEmpty()) {
                        instanceDetailsBuilder.definedTags(definedTags);
                    }
                }
                LaunchInstanceResponse response = computeClient.launchInstance(LaunchInstanceRequest.builder().launchInstanceDetails(instanceDetailsBuilder.build()).build());
                instance = instance2 = response.getInstance();
                if (computeClient == null) break block21;
            }
            catch (Throwable ad) {
                try {
                    if (computeClient != null) {
                        try {
                            computeClient.close();
                        }
                        catch (Throwable throwable) {
                            ad.addSuppressed(throwable);
                        }
                    }
                    throw ad;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to launch instance " + name + " based on template " + template.getTemplateId() + " (" + template.getDisplayName() + ")", ex);
                    if (instance2 != null && instance2.getId() != null) {
                        try {
                            this.terminateInstance(instance2.getId());
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Failed to terminate unlaunchable instance" + name, e);
                        }
                    }
                    throw ex;
                }
            }
            computeClient.close();
        }
        return instance;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Instance waitForInstanceProvisioningToComplete(String instanceId) throws Exception {
        try (ComputeClient computeClient = this.getComputeClient();){
            ComputeWaiters waiter = computeClient.getWaiters();
            GetInstanceResponse response = (GetInstanceResponse)waiter.forInstance(GetInstanceRequest.builder().instanceId(instanceId).build(), new Instance.LifecycleState[]{Instance.LifecycleState.Running}).execute();
            Instance instance = response.getInstance();
            return instance;
        }
    }

    @Override
    public String getInstanceIp(BaremetalCloudAgentTemplate template, String instanceId) throws Exception {
        String Ip = "";
        try (ComputeClient computeClient = this.getComputeClient();
             VirtualNetworkClient vcnClient = this.getVirtualNetworkClient();){
            String compartmentId = template.getCompartmentId();
            ListVnicAttachmentsResponse listVnicResponse = computeClient.listVnicAttachments(ListVnicAttachmentsRequest.builder().compartmentId(compartmentId).instanceId(instanceId).build());
            List vnics = listVnicResponse.getItems();
            for (VnicAttachment vnic : vnics) {
                String vnicId = vnic.getVnicId();
                GetVnicResponse getVnicResponse = vcnClient.getVnic(GetVnicRequest.builder().vnicId(vnicId).build());
                String publicIpLocal = getVnicResponse.getVnic().getPublicIp();
                boolean usePublicIP = true;
                if (template.getUsePublicIP() != null) {
                    usePublicIP = template.getUsePublicIP();
                }
                if (usePublicIP && publicIpLocal != null) {
                    LOGGER.info("Get public ip for instance " + instanceId + ": " + publicIpLocal);
                    Ip = publicIpLocal;
                    continue;
                }
                String privateIpLocal = getVnicResponse.getVnic().getPrivateIp();
                if (privateIpLocal == null) continue;
                LOGGER.info("Get private ip for instance " + instanceId + ": " + privateIpLocal);
                Ip = privateIpLocal;
            }
        }
        return Ip;
    }

    @Override
    public Tenancy getTenant() throws Exception {
        Tenancy tenancy;
        block8: {
            IdentityClient identityClient = this.getIdentityClient();
            try {
                GetTenancyResponse response = identityClient.getTenancy(GetTenancyRequest.builder().tenancyId(this.tenantId).build());
                tenancy = response.getTenancy();
                if (identityClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (identityClient != null) {
                        try {
                            identityClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to get root compartment", e);
                    throw e;
                }
            }
            identityClient.close();
        }
        return tenancy;
    }

    @Override
    public List<Compartment> getCompartmentsList() throws Exception {
        ArrayList<Compartment> compartmentIds = new ArrayList<Compartment>();
        try (IdentityAsyncClient identityAsyncClient = this.getIdentityAsyncClient();){
            Future listResponse;
            ListCompartmentsRequest.Builder builder = ListCompartmentsRequest.builder().compartmentId(this.tenantId).compartmentIdInSubtree(Boolean.TRUE);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                listResponse = identityAsyncClient.listCompartments(builder.build(), null);
                List activeCompartments = ((ListCompartmentsResponse)listResponse.get()).getItems().stream().filter(c -> c.getLifecycleState() == Compartment.LifecycleState.Active).collect(Collectors.toList());
                compartmentIds.addAll(activeCompartments);
            } while ((nextPageToken = ((ListCompartmentsResponse)listResponse.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get compartment list", e);
            throw e;
        }
        return compartmentIds;
    }

    @Override
    public List<AvailabilityDomain> getAvailabilityDomainsList(String compartmentId) throws Exception {
        ArrayList<AvailabilityDomain> availabilityDomainsList = new ArrayList<AvailabilityDomain>();
        try (IdentityAsyncClient identityAsyncClient = this.getIdentityAsyncClient();){
            ListAvailabilityDomainsRequest request = ListAvailabilityDomainsRequest.builder().compartmentId(compartmentId).build();
            availabilityDomainsList.addAll(((ListAvailabilityDomainsResponse)identityAsyncClient.listAvailabilityDomains(request, null).get()).getItems());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Availability Domain list", e);
            throw e;
        }
        return availabilityDomainsList;
    }

    @Override
    public List<Image> getImagesList(String compartmentId) throws Exception {
        ArrayList<Image> imageList = new ArrayList<Image>();
        try (ComputeAsyncClient computeAsyncClient = this.getComputeAsyncClient();){
            Future response;
            ListImagesRequest.Builder builder = ListImagesRequest.builder().compartmentId(compartmentId);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                response = computeAsyncClient.listImages(builder.build(), null);
                imageList.addAll(((ListImagesResponse)response.get()).getItems());
            } while ((nextPageToken = ((ListImagesResponse)response.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Image list", e);
            throw e;
        }
        return imageList;
    }

    @Override
    public List<Shape> getShapesList(String compartmentId, String availableDomain, String imageId) throws Exception {
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        try (ComputeAsyncClient computeAsyncClient = this.getComputeAsyncClient();){
            Future response;
            ListShapesRequest.Builder builder = ListShapesRequest.builder().compartmentId(compartmentId).availabilityDomain(availableDomain).imageId(imageId);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                response = computeAsyncClient.listShapes(builder.build(), null);
                shapeList.addAll(((ListShapesResponse)response.get()).getItems());
            } while ((nextPageToken = ((ListShapesResponse)response.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Shape list", e);
            throw e;
        }
        return shapeList;
    }

    @Override
    public Integer[] getMinMaxOcpus(String compartmentId, String availableDomain, String imageId, String shape) throws Exception {
        Integer[] ocpuOptions = new Integer[2];
        ((Stream)this.getShapesList(compartmentId, availableDomain, imageId).stream().parallel()).filter(n -> n.getShape().equals(shape)).forEach(n -> {
            ocpuOptions[0] = n.getOcpuOptions().getMin().intValue();
            ocpuOptions[1] = n.getOcpuOptions().getMax().intValue();
        });
        return ocpuOptions;
    }

    @Override
    public Integer[] getMinMaxMemory(String compartmentId, String availableDomain, String imageId, String shape) throws Exception {
        Integer[] memoryOptions = new Integer[2];
        ((Stream)this.getShapesList(compartmentId, availableDomain, imageId).stream().parallel()).filter(n -> n.getShape().equals(shape)).forEach(n -> {
            memoryOptions[0] = n.getMemoryOptions().getMinInGBs().intValue();
            memoryOptions[1] = n.getMemoryOptions().getMaxInGBs().intValue();
        });
        return memoryOptions;
    }

    @Override
    public List<Vcn> getVcnList(String compartmentId) throws Exception {
        ArrayList<Vcn> vcnList = new ArrayList<Vcn>();
        try (VirtualNetworkAsyncClient vnc = this.getVirtualNetworkAsyncClient();){
            Future response;
            ListVcnsRequest.Builder builder = ListVcnsRequest.builder().compartmentId(compartmentId);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                response = vnc.listVcns(builder.build(), null);
                vcnList.addAll(((ListVcnsResponse)response.get()).getItems());
            } while ((nextPageToken = ((ListVcnsResponse)response.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get VCN list", e);
            throw e;
        }
        return vcnList;
    }

    @Override
    public List<Subnet> getSubNetList(String compartmentId, String vcnId) throws Exception {
        ArrayList<Subnet> subnetList = new ArrayList<Subnet>();
        try (VirtualNetworkAsyncClient vnc = this.getVirtualNetworkAsyncClient();){
            Future response;
            ListSubnetsRequest.Builder builder = ListSubnetsRequest.builder().compartmentId(compartmentId).vcnId(vcnId);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                response = vnc.listSubnets(builder.build(), null);
                subnetList.addAll(((ListSubnetsResponse)response.get()).getItems());
            } while ((nextPageToken = ((ListSubnetsResponse)response.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Subnet list", e);
            throw e;
        }
        return subnetList;
    }

    @Override
    public List<NetworkSecurityGroup> getNsgIdsList(String compartmentId) throws Exception {
        ArrayList<NetworkSecurityGroup> nsgList = new ArrayList<NetworkSecurityGroup>();
        try (VirtualNetworkAsyncClient vnc = this.getVirtualNetworkAsyncClient();){
            ListNetworkSecurityGroupsRequest request = ListNetworkSecurityGroupsRequest.builder().compartmentId(compartmentId).build();
            nsgList.addAll(((ListNetworkSecurityGroupsResponse)vnc.listNetworkSecurityGroups(request, null).get()).getItems());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Network Security Group list", e);
            throw e;
        }
        return nsgList;
    }

    @Override
    public GetSubnetResponse getSubNet(String subnetId) throws Exception {
        GetSubnetResponse subnetResponse;
        try (VirtualNetworkClient vnc = this.getVirtualNetworkClient();){
            subnetResponse = vnc.getSubnet(GetSubnetRequest.builder().subnetId(subnetId).build());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get subnet list", e);
            throw e;
        }
        return subnetResponse;
    }

    @Override
    public String terminateInstance(String instanceId) throws Exception {
        try (ComputeClient computeClient = this.getComputeClient();){
            TerminateInstanceResponse response = computeClient.terminateInstance(TerminateInstanceRequest.builder().instanceId(instanceId).build());
            String string = response.getOpcRequestId();
            return string;
        }
    }

    @Override
    public Instance waitForInstanceTerminationToComplete(String instanceId) throws Exception {
        try (ComputeClient computeClient = this.getComputeClient();){
            ComputeWaiters waiter = computeClient.getWaiters();
            GetInstanceResponse response = (GetInstanceResponse)waiter.forInstance(GetInstanceRequest.builder().instanceId(instanceId).build(), new Instance.LifecycleState[]{Instance.LifecycleState.Stopping, Instance.LifecycleState.Stopped, Instance.LifecycleState.Terminating, Instance.LifecycleState.Terminated}).execute();
            Instance instance = response.getInstance();
            return instance;
        }
    }

    @Override
    public Instance.LifecycleState getInstanceState(String instanceId) throws Exception {
        try (ComputeClient computeClient = this.getComputeClient();){
            GetInstanceResponse response = computeClient.getInstance(GetInstanceRequest.builder().instanceId(instanceId).build());
            Instance.LifecycleState lifecycleState = response.getInstance().getLifecycleState();
            return lifecycleState;
        }
    }

    @Override
    public List<Instance> getStoppedInstances(String compartmentId, String availableDomain) throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        try (ComputeClient computeClient = this.getComputeClient();){
            ListInstancesResponse response = computeClient.listInstances(ListInstancesRequest.builder().compartmentId(compartmentId).availabilityDomain(availableDomain).lifecycleState(Instance.LifecycleState.Stopped).build());
            instances.addAll(response.getItems());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Stopped list", e);
            throw e;
        }
        return instances;
    }

    @Override
    public String stopInstance(String instanceId) throws Exception {
        String string;
        block8: {
            ComputeClient computeClient = this.getComputeClient();
            try {
                InstanceActionRequest.Builder builder = InstanceActionRequest.builder().action("STOP").instanceId(instanceId);
                InstanceActionResponse response = computeClient.instanceAction(builder.build());
                string = response.getOpcRequestId();
                if (computeClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (computeClient != null) {
                        try {
                            computeClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new Exception("Failed to stop an instance: " + ex.getMessage());
                }
            }
            computeClient.close();
        }
        return string;
    }

    @Override
    public Instance startInstance(String instanceId) throws Exception {
        Instance instance;
        block8: {
            ComputeClient computeClient = this.getComputeClient();
            try {
                InstanceActionRequest.Builder builder = InstanceActionRequest.builder().action("START").instanceId(instanceId);
                InstanceActionResponse response = computeClient.instanceAction(builder.build());
                instance = response.getInstance();
                if (computeClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (computeClient != null) {
                        try {
                            computeClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new Exception("Failed to start an instance: " + ex.getMessage());
                }
            }
            computeClient.close();
        }
        return instance;
    }

    @Override
    public List<TagNamespaceSummary> getTagNamespaces(String compartmentId) throws Exception {
        ArrayList<TagNamespaceSummary> tagNamespaces = new ArrayList<TagNamespaceSummary>();
        try (IdentityAsyncClient identityAsyncClient = this.getIdentityAsyncClient();){
            Future response;
            ListTagNamespacesRequest.Builder builder = ListTagNamespacesRequest.builder().compartmentId(compartmentId).includeSubcompartments(Boolean.TRUE);
            String nextPageToken = null;
            do {
                builder.page(nextPageToken);
                response = identityAsyncClient.listTagNamespaces(builder.build(), null);
                tagNamespaces.addAll(((ListTagNamespacesResponse)response.get()).getItems());
            } while ((nextPageToken = ((ListTagNamespacesResponse)response.get()).getOpcNextPage()) != null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get tag namespaces list", e);
            throw e;
        }
        return tagNamespaces;
    }
}

