/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.Shape;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.identity.model.AvailabilityDomain;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudAgent;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudNsgTemplate;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloudTagsTemplate;
import com.oracle.cloud.baremetal.jenkins.FormValidationValue;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.Messages;
import com.oracle.cloud.baremetal.jenkins.SshKeyUtil;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClient;
import com.oracle.cloud.baremetal.jenkins.client.BaremetalCloudClientFactory;
import com.oracle.cloud.baremetal.jenkins.client.SDKBaremetalCloudClientFactory;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BaremetalCloudAgentTemplate
implements Describable<BaremetalCloudAgentTemplate> {
    private static final Logger LOGGER = Logger.getLogger(BaremetalCloud.class.getName());
    static final int DEFAULT_VPUS = 10;
    static final int FAILURE_COUNT_LIMIT = 3;
    static final int DISABLE_FAILURE_COUNT_LIMIT = 20;
    private transient boolean templateSleep = false;
    public final String compartmentId;
    public final String availableDomain;
    public final String vcnCompartmentId;
    public final String vcnId;
    public final String subnetCompartmentId;
    public final String subnetId;
    public final List<BaremetalCloudNsgTemplate> nsgIds;
    public final String imageCompartmentId;
    private String imageId;
    public final String shape;
    public final String sshCredentialsId;
    public final String description;
    public final String labelString;
    private transient Collection<LabelAtom> labelAtoms;
    public final Node.Mode mode;
    public final String jenkinsAgentUser;
    public final String customJavaPath;
    public final String customJVMOpts;
    public final String initScript;
    public final Boolean exportJenkinsEnvVars;
    public final String numExecutors;
    public final String idleTerminationMinutes;
    public final int templateId;
    public final String remoteFS;
    public final Boolean assignPublicIP;
    public final Boolean usePublicIP;
    public final String startTimeoutSeconds;
    public boolean verificationStrategy = false;
    public final String sshConnectTimeoutSeconds;
    public final String initScriptTimeoutSeconds;
    public final String instanceCap;
    public final String numberOfOcpus;
    public final Boolean autoImageUpdate;
    public final Boolean stopOnIdle;
    public final List<BaremetalCloudTagsTemplate> tags;
    public final String instanceNamePrefix;
    public final String memoryInGBs;
    public final Boolean doNotDisable;
    public final String retryTimeoutMins;
    private long bootVolumeVPUs;
    public final Boolean disableLegacyImdsEndpoint;
    private transient int failureCount = 0;
    private transient String disableCause;
    private transient long sleepStartTime = 0L;

    @DataBoundConstructor
    public BaremetalCloudAgentTemplate(String compartmentId, String availableDomain, String vcnCompartmentId, String vcnId, String subnetCompartmentId, String subnetId, List<BaremetalCloudNsgTemplate> nsgIds, String imageCompartmentId, String imageId, String shape, String sshCredentialsId, String description, String remoteFS, Boolean assignPublicIP, Boolean usePublicIP, String numExecutors, Node.Mode mode, String labelString, String idleTerminationMinutes, int templateId, String jenkinsAgentUser, String customJavaPath, String customJVMOpts, String initScript, Boolean exportJenkinsEnvVars, String sshConnectTimeoutSeconds, Boolean verificationStrategy, String startTimeoutSeconds, String initScriptTimeoutSeconds, String instanceCap, String numberOfOcpus, Boolean autoImageUpdate, Boolean stopOnIdle, List<BaremetalCloudTagsTemplate> tags, String instanceNamePrefix, String memoryInGBs, Boolean doNotDisable, String retryTimeoutMins, Boolean disableLegacyImdsEndpoint) {
        this.compartmentId = compartmentId;
        this.availableDomain = availableDomain;
        this.vcnCompartmentId = vcnCompartmentId;
        this.vcnId = vcnId;
        this.subnetCompartmentId = subnetCompartmentId;
        this.subnetId = subnetId;
        this.nsgIds = nsgIds;
        this.imageCompartmentId = imageCompartmentId;
        this.imageId = imageId;
        this.shape = shape;
        this.sshCredentialsId = sshCredentialsId;
        this.description = description;
        this.remoteFS = remoteFS;
        this.assignPublicIP = assignPublicIP;
        this.usePublicIP = usePublicIP;
        this.numExecutors = numExecutors;
        this.mode = mode;
        this.labelString = labelString;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.templateId = templateId;
        this.jenkinsAgentUser = jenkinsAgentUser;
        this.customJavaPath = customJavaPath;
        this.customJVMOpts = customJVMOpts;
        this.initScript = initScript;
        this.exportJenkinsEnvVars = exportJenkinsEnvVars;
        this.sshConnectTimeoutSeconds = sshConnectTimeoutSeconds;
        this.startTimeoutSeconds = startTimeoutSeconds;
        this.initScriptTimeoutSeconds = initScriptTimeoutSeconds;
        this.instanceCap = instanceCap;
        this.numberOfOcpus = numberOfOcpus;
        this.autoImageUpdate = autoImageUpdate;
        this.stopOnIdle = stopOnIdle;
        this.tags = tags;
        this.instanceNamePrefix = instanceNamePrefix;
        this.memoryInGBs = memoryInGBs;
        this.doNotDisable = doNotDisable;
        this.retryTimeoutMins = retryTimeoutMins;
        this.verificationStrategy = verificationStrategy;
        this.disableLegacyImdsEndpoint = disableLegacyImdsEndpoint;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailableDomain() {
        return this.availableDomain;
    }

    public String getVcnCompartmentId() {
        return this.vcnCompartmentId;
    }

    public String getVcn() {
        return this.vcnId;
    }

    public String getSubnetCompartmentId() {
        return this.subnetCompartmentId;
    }

    public String getSubnet() {
        return this.subnetId;
    }

    public List<BaremetalCloudNsgTemplate> getNsgIds() {
        return this.nsgIds;
    }

    public String getImageCompartmentId() {
        return this.imageCompartmentId;
    }

    public String getImage() {
        return this.imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    @DataBoundSetter
    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Boolean getAutoImageUpdate() {
        return this.autoImageUpdate == null ? Boolean.FALSE : this.autoImageUpdate;
    }

    public String getShape() {
        return this.shape;
    }

    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    public String getDisplayName() {
        return String.valueOf(this.getDescription());
    }

    public String getDescription() {
        return this.description;
    }

    public String getJenkinsAgentUser() {
        return this.jenkinsAgentUser;
    }

    public String getCustomJavaPath() {
        return this.customJavaPath;
    }

    public String getCustomJVMOpts() {
        return this.customJVMOpts;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    public Boolean getAssignPublicIP() {
        return this.assignPublicIP;
    }

    public Boolean getUsePublicIP() {
        return this.usePublicIP;
    }

    public int getNumExecutors() {
        try {
            return Math.max(Integer.parseInt(this.numExecutors), 1);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static FormValidationValue<Integer> checkNumExecutors(String value) {
        return FormValidationValue.validatePositiveInteger(value, 1);
    }

    public int getNumExecutorsValue() {
        return BaremetalCloudAgentTemplate.checkNumExecutors(this.numExecutors).getValue();
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getLabelString() {
        return this.labelString;
    }

    Collection<LabelAtom> parseLabels(String labels) {
        return Label.parse((String)labels);
    }

    public synchronized Collection<LabelAtom> getLabelAtoms() {
        Collection<LabelAtom> labelAtoms = this.labelAtoms;
        if (labelAtoms == null) {
            this.labelAtoms = labelAtoms = this.parseLabels(this.labelString);
        }
        return labelAtoms;
    }

    public String getIdleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public Boolean getVerificationStrategy() {
        return this.verificationStrategy;
    }

    public String getInitScriptEnvVarsVersion() {
        return this.getExportJenkinsEnvVars() == false ? this.initScript : this.addJenkinsEnvVarsToInitScript(this.initScript);
    }

    public Boolean getExportJenkinsEnvVars() {
        return this.exportJenkinsEnvVars == null ? Boolean.FALSE : this.exportJenkinsEnvVars;
    }

    public String getStartTimeoutSeconds() {
        return this.startTimeoutSeconds;
    }

    public String getSshConnectTimeoutSeconds() {
        return this.sshConnectTimeoutSeconds;
    }

    private static FormValidationValue<Integer> checkStartTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, (int)TimeUnit.MINUTES.toSeconds(15L));
    }

    public long getStartTimeoutNanos() {
        return TimeUnit.SECONDS.toNanos(BaremetalCloudAgentTemplate.checkStartTimeoutSeconds(this.startTimeoutSeconds).getValue().intValue());
    }

    private static FormValidationValue<Integer> checkSshConnectTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, 30);
    }

    public int getSshConnectTimeoutMillis() {
        return (int)TimeUnit.SECONDS.toMillis(BaremetalCloudAgentTemplate.checkSshConnectTimeoutSeconds(this.sshConnectTimeoutSeconds).getValue().intValue());
    }

    public int getInitScriptTimeoutSeconds() {
        return (int)TimeUnit.SECONDS.toSeconds(BaremetalCloudAgentTemplate.checkInitScriptTimeoutSeconds(this.initScriptTimeoutSeconds).getValue().intValue());
    }

    public String getInstanceCap() {
        return this.instanceCap;
    }

    public String getNumberOfOcpus() {
        return this.numberOfOcpus;
    }

    public String getMemoryInGBs() {
        return this.memoryInGBs == null && !this.numberOfOcpus.isEmpty() ? Integer.toString(Integer.parseInt(this.numberOfOcpus) * 16) : this.memoryInGBs;
    }

    public long getBootVolumeVPUs() {
        return this.bootVolumeVPUs == 0L ? 10L : this.bootVolumeVPUs;
    }

    @DataBoundSetter
    public void setBootVolumeVPUs(long bootVolumeVPUs) {
        this.bootVolumeVPUs = bootVolumeVPUs;
    }

    public String getPublicKey() throws IOException {
        SSHUserPrivateKey sshCredentials = (SSHUserPrivateKey)BaremetalCloud.matchCredentials(SSHUserPrivateKey.class, this.sshCredentialsId);
        if (sshCredentials != null) {
            return SshKeyUtil.getPublicKey(sshCredentials.getPrivateKey(), Secret.toString((Secret)sshCredentials.getPassphrase()));
        }
        return null;
    }

    public Boolean getStopOnIdle() {
        return this.stopOnIdle == null ? Boolean.FALSE : this.stopOnIdle;
    }

    public List<BaremetalCloudTagsTemplate> getTags() {
        return this.tags;
    }

    public String getInstanceNamePrefix() {
        return this.instanceNamePrefix;
    }

    private static FormValidationValue<Integer> checkInitScriptTimeoutSeconds(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, 120);
    }

    public Boolean getDisableLegacyImdsEndpoint() {
        return this.disableLegacyImdsEndpoint;
    }

    public Descriptor<BaremetalCloudAgentTemplate> getDescriptor() {
        return JenkinsUtil.getDescriptorOrDie(this.getClass());
    }

    public synchronized void increaseFailureCount(String cause) {
        ++this.failureCount;
        if (this.doNotDisable == null) {
            if (this.failureCount >= 3) {
                LOGGER.warning("Agent template " + this.getDisplayName() + " disabled due to error: " + cause);
                this.disableCause = cause;
            }
        } else if (this.failureCount >= 3 && !this.doNotDisable.booleanValue()) {
            LOGGER.warning("Agent template " + this.getDisplayName() + " disabled due to error: " + cause);
            this.disableCause = cause;
        } else if (this.failureCount >= 20 && this.doNotDisable.booleanValue()) {
            LOGGER.info("Agent template " + this.getDisplayName() + " encountered " + this.failureCount + " failures till now. It is disabled due to error: " + cause);
            this.disableCause = cause;
        } else {
            LOGGER.info("Agent template " + this.getDisplayName() + " encountered " + this.failureCount + " failures till now.");
        }
    }

    public synchronized void resetFailureCount() {
        if (this.failureCount > 0) {
            this.failureCount = 0;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Agent template " + this.getDisplayName() + " is reset");
            }
        }
        if (this.disableCause != null) {
            this.disableCause = null;
            LOGGER.info("Agent template " + this.getDisplayName() + " is re-enabled");
        }
    }

    public synchronized String getDisableCause() {
        return this.disableCause;
    }

    private String addJenkinsEnvVarsToInitScript(String initScript) {
        EnvVars vars = JenkinsUtil.getJenkinsEnvVars();
        if (vars != null) {
            StringBuilder newInitScript = new StringBuilder();
            for (Map.Entry entry : vars.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                newInitScript.append("export ").append(key).append("=").append(value).append("\n");
            }
            return newInitScript.append(initScript).toString();
        }
        return initScript;
    }

    public Boolean getDoNotDisable() {
        return this.doNotDisable;
    }

    @DataBoundSetter
    public synchronized void setTemplateSleep(Boolean sleepvar) {
        this.templateSleep = sleepvar;
    }

    public synchronized boolean isTemplateSleep() {
        return this.templateSleep;
    }

    private static FormValidationValue<Integer> checkRetryTimeoutMins(String value) {
        return FormValidationValue.validateNonNegativeInteger(value, 10);
    }

    public int getRetryTimeoutMins() {
        return (int)TimeUnit.MINUTES.toMinutes(BaremetalCloudAgentTemplate.checkRetryTimeoutMins(this.retryTimeoutMins).getValue().intValue());
    }

    public synchronized void setSleepStartTime(long sleepStartTime) {
        LOGGER.log(Level.FINE, "Setting the current time for sleep " + sleepStartTime);
        this.sleepStartTime = sleepStartTime;
    }

    public synchronized long getSleepStartTime() {
        LOGGER.log(Level.FINE, "Getting the set time for sleep " + this.sleepStartTime);
        return this.sleepStartTime;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BaremetalCloudAgentTemplate> {
        private transient Map<String, Tenancy> tenantCache = new HashMap<String, Tenancy>();
        private transient Map<String, List<Compartment>> compartmentsCache = new HashMap<String, List<Compartment>>();
        private transient Map<String, Long> tenantTimestamp = new HashMap<String, Long>();
        private transient Map<String, Long> compartmentsTimestamp = new HashMap<String, Long>();
        private static final long CACHE_TTL_MS = 30000L;

        public String getHelpFile(String fieldName) {
            Descriptor descriptor;
            Jenkins jenkins;
            String p = super.getHelpFile(fieldName);
            if (p == null && (jenkins = Jenkins.getInstanceOrNull()) != null && (descriptor = jenkins.getDescriptor(BaremetalCloudAgent.class)) != null) {
                p = descriptor.getHelpFile(fieldName);
            }
            return p;
        }

        public static int getDefaultNumExecutors() {
            return BaremetalCloudAgentTemplate.checkNumExecutors(null).getValue();
        }

        public FormValidation doCheckNumExecutors(@QueryParameter String value) {
            return BaremetalCloudAgentTemplate.checkNumExecutors(value).getFormValidation();
        }

        public FormValidation doCheckSshConnectTimeoutSeconds(@QueryParameter String value) {
            return BaremetalCloudAgentTemplate.checkSshConnectTimeoutSeconds(value).getFormValidation();
        }

        public FormValidation doCheckAssignPublicIP(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String subnetId, @QueryParameter Boolean assignPublicIP) {
            if (subnetId != null && !subnetId.equals("") && (assignPublicIP == null || assignPublicIP.booleanValue())) {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                try {
                    GetSubnetResponse subnetResponse = client.getSubNet(subnetId);
                    if (subnetResponse.getSubnet().getProhibitPublicIpOnVnic().booleanValue()) {
                        return FormValidation.error((String)Messages.BaremetalCloudAgentTemplate_assignPublicIP_unable());
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to get subnet: " + subnetId, e);
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDoNotDisable(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter Boolean doNotDisable) {
            if (doNotDisable == null || doNotDisable.booleanValue()) {
                return FormValidation.warning((String)Messages.BaremetalCloudAgentTemplate_doNotDisable_warningmsg());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsePublicIP(@QueryParameter Boolean assignPublicIP, @QueryParameter Boolean usePublicIP) {
            if (usePublicIP != null && assignPublicIP != null && usePublicIP.booleanValue() && !assignPublicIP.booleanValue()) {
                return FormValidation.error((String)Messages.BaremetalCloudAgentTemplate_usePublicIP_unable());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstanceNamePrefix(@QueryParameter String instanceNamePrefix) {
            if (instanceNamePrefix.contains(" ")) {
                return FormValidation.error((String)Messages.BaremetalCloudAgentTemplate_prefix_contains_spaces());
            }
            return FormValidation.ok();
        }

        private static boolean anyRequiredFieldEmpty(String ... fields) {
            for (String field : fields) {
                if (field != null && !field.isEmpty()) continue;
                return true;
            }
            return false;
        }

        BaremetalCloud.DescriptorImpl getBaremetalCloudDescriptor() {
            return JenkinsUtil.getDescriptorOrDie(BaremetalCloud.class, BaremetalCloud.DescriptorImpl.class);
        }

        private static BaremetalCloudClient getClient(String credentialsId, String maxAsyncThreads) {
            BaremetalCloudClientFactory factory = SDKBaremetalCloudClientFactory.INSTANCE;
            return factory.createClient(credentialsId, Integer.parseInt(maxAsyncThreads));
        }

        public ListBoxModel doFillBootVolumeVPUsItems() throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("10 (Balanced)", "10");
            model.add("20 (Higher Performance)", "20");
            model.add("30 (Ultra High Performance)", "30");
            for (int i = 40; i <= 120; i += 10) {
                model.add(Integer.toString(i), Integer.toString(i));
            }
            return model;
        }

        public ListBoxModel doFillCompartmentIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a compartmentId>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId)) {
                return model;
            }
            try {
                Tenancy tenant = this.getTenantCached(credentialsId, maxAsyncThreads);
                model.add(tenant.getName(), tenant.getId());
                for (Compartment compartment : this.getCompartmentsCached(credentialsId, maxAsyncThreads)) {
                    model.add(compartment.getName(), compartment.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get compartment list", e);
            }
            return model;
        }

        public ListBoxModel doFillAvailableDomainItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId) {
            ListBoxModel model = new ListBoxModel();
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                model.add("<First select 'Compartment'>", "");
                return model;
            }
            try {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                ArrayList<String> lstDomain = new ArrayList<String>();
                for (AvailabilityDomain domain : client.getAvailabilityDomainsList(compartmentId)) {
                    if (lstDomain.contains(domain.getName())) continue;
                    model.add(domain.getName(), domain.getName());
                    lstDomain.add(domain.getName());
                }
                return model;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get AvailableDomain list", e);
                return model;
            }
        }

        public ListBoxModel doFillImageCompartmentIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a compartmentId>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                model.add("<First select 'Compartment'>", "");
                return model;
            }
            try {
                Tenancy tenant = this.getTenantCached(credentialsId, maxAsyncThreads);
                model.add(tenant.getName(), tenant.getId());
                for (Compartment compartment : this.getCompartmentsCached(credentialsId, maxAsyncThreads)) {
                    model.add(compartment.getName(), compartment.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get compartment list", e);
            }
            return model;
        }

        public ListBoxModel doFillImageIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId, @QueryParameter String imageCompartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select an Image>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                return model;
            }
            if (DescriptorImpl.anyRequiredFieldEmpty(imageCompartmentId)) {
                imageCompartmentId = compartmentId;
            }
            try {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                ArrayList<String> lstImage = new ArrayList<String>();
                for (Image imageId : client.getImagesList(imageCompartmentId)) {
                    if (lstImage.contains(imageId.getId())) continue;
                    model.add(imageId.getDisplayName(), imageId.getId());
                    lstImage.add(imageId.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get images list", e);
            }
            return model;
        }

        public ListBoxModel doFillShapeItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId, @QueryParameter String availableDomain, @QueryParameter String imageId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<First select 'Availability Domain' and 'Image' above>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId, imageId)) {
                return model;
            }
            try {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                ArrayList<String> lstShape = new ArrayList<String>();
                for (Shape shape : client.getShapesList(compartmentId, availableDomain, imageId)) {
                    if (lstShape.contains(shape.getShape())) continue;
                    model.add(shape.getShape(), shape.getShape());
                    lstShape.add(shape.getShape());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get shapes list", e);
            }
            return model;
        }

        public ListBoxModel doFillNumberOfOcpusItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId, @QueryParameter String availableDomain, @QueryParameter String imageId, @QueryParameter String shape) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId, availableDomain, imageId, shape)) {
                model.clear();
                model.add("<First select 'Availability Domain' and 'Image' and 'Shape' above>", "");
                return model;
            }
            if (!shape.contains("Flex") && !shape.contains("Generic")) {
                model.clear();
                model.add("<This field only takes effect for flexible and generic shapes if selected>", "");
                return model;
            }
            try {
                model.clear();
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                Integer[] ocpuOptions = client.getMinMaxOcpus(compartmentId, availableDomain, imageId, shape);
                IntStream.range(ocpuOptions[0], ocpuOptions[1] + 1).forEach(n -> model.add(Integer.toString(n)));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get ocpus options list", e);
            }
            return model;
        }

        public ListBoxModel doFillMemoryInGBsItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId, @QueryParameter String availableDomain, @QueryParameter String imageId, @QueryParameter String shape) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId, availableDomain, imageId, shape)) {
                model.clear();
                model.add("<First select 'Availability Domain' and 'Image' and 'Shape' above>", "");
                return model;
            }
            if (!shape.contains("Flex") && !shape.contains("Generic")) {
                model.clear();
                model.add("<This field only takes effect for flexible and generic shapes if selected>", "");
                return model;
            }
            try {
                model.clear();
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                Integer[] memoryOptions = client.getMinMaxMemory(compartmentId, availableDomain, imageId, shape);
                IntStream.range(memoryOptions[0], memoryOptions[1] + 1).forEach(n -> model.add(Integer.toString(n)));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get memory options list", e);
            }
            return model;
        }

        public ListBoxModel doFillVcnCompartmentIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a compartmentId>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                model.add("<First select 'Compartment'>", "");
                return model;
            }
            try {
                Tenancy tenant = this.getTenantCached(credentialsId, maxAsyncThreads);
                model.add(tenant.getName(), tenant.getId());
                for (Compartment compartment : this.getCompartmentsCached(credentialsId, maxAsyncThreads)) {
                    model.add(compartment.getName(), compartment.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get compartment list", e);
            }
            return model;
        }

        public ListBoxModel doFillVcnIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId, @QueryParameter String vcnCompartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a Virtual Cloud Network>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                return model;
            }
            if (DescriptorImpl.anyRequiredFieldEmpty(vcnCompartmentId)) {
                vcnCompartmentId = compartmentId;
            }
            try {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                for (Vcn vcnId : client.getVcnList(vcnCompartmentId)) {
                    model.add(vcnId.getDisplayName(), vcnId.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get VCN list", e);
            }
            return model;
        }

        public ListBoxModel doFillSubnetCompartmentIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String compartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<Select a compartmentId>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, compartmentId)) {
                model.add("<First select 'Compartment'>", "");
                return model;
            }
            try {
                Tenancy tenant = this.getTenantCached(credentialsId, maxAsyncThreads);
                model.add(tenant.getName(), tenant.getId());
                for (Compartment compartment : this.getCompartmentsCached(credentialsId, maxAsyncThreads)) {
                    model.add(compartment.getName(), compartment.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get compartment list", e);
            }
            return model;
        }

        public ListBoxModel doFillSubnetIdItems(@QueryParameter @RelativePath(value="..") String credentialsId, @QueryParameter @RelativePath(value="..") String maxAsyncThreads, @QueryParameter String availableDomain, @QueryParameter String vcnId, @QueryParameter String compartmentId, @QueryParameter String vcnCompartmentId, @QueryParameter String subnetCompartmentId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            model.add("<First select 'Availability Domain' and 'Virtual Cloud Network' above>", "");
            if (DescriptorImpl.anyRequiredFieldEmpty(credentialsId, availableDomain, vcnId, compartmentId)) {
                return model;
            }
            if (DescriptorImpl.anyRequiredFieldEmpty(subnetCompartmentId)) {
                subnetCompartmentId = vcnCompartmentId;
            }
            try {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                for (Subnet subnet : client.getSubNetList(subnetCompartmentId, vcnId)) {
                    if (null != subnet.getAvailabilityDomain() && !subnet.getAvailabilityDomain().equals(availableDomain)) continue;
                    model.add(subnet.getDisplayName(), subnet.getId());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get subnet list", e);
            }
            return model;
        }

        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String sshCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (context == null ? instance != null && !instance.hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(sshCredentialsId);
            }
            ArrayList domainRequirements = new ArrayList();
            return result.includeMatchingAs(ACL.SYSTEM, context, SSHUserPrivateKey.class, domainRequirements, SSHAuthenticator.matcher());
        }

        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)Messages.BaremetalCloudAgentTemplate_labelString_exclusiveEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIdleTerminationMinutes(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckStartTimeoutSeconds(@QueryParameter String value) {
            return BaremetalCloudAgentTemplate.checkStartTimeoutSeconds(value).getFormValidation();
        }

        public FormValidation doCheckInstanceCap(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        private String getCacheKey(String credentialsId, String maxAsyncThreads) {
            return credentialsId + ":" + maxAsyncThreads;
        }

        private synchronized Tenancy getTenantCached(String credentialsId, String maxAsyncThreads) throws Exception {
            String key = this.getCacheKey(credentialsId, maxAsyncThreads);
            long now = System.currentTimeMillis();
            if (!this.tenantCache.containsKey(key) || now - this.tenantTimestamp.getOrDefault(key, 0L) > 30000L) {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                Tenancy tenant = client.getTenant();
                this.tenantCache.put(key, tenant);
                this.tenantTimestamp.put(key, now);
            }
            return this.tenantCache.get(key);
        }

        private synchronized List<Compartment> getCompartmentsCached(String credentialsId, String maxAsyncThreads) throws Exception {
            String key = this.getCacheKey(credentialsId, maxAsyncThreads);
            long now = System.currentTimeMillis();
            if (!this.compartmentsCache.containsKey(key) || now - this.compartmentsTimestamp.getOrDefault(key, 0L) > 30000L) {
                BaremetalCloudClient client = DescriptorImpl.getClient(credentialsId, maxAsyncThreads);
                List<Compartment> list = client.getCompartmentsList();
                this.compartmentsCache.put(key, list);
                this.compartmentsTimestamp.put(key, now);
            }
            return this.compartmentsCache.get(key);
        }
    }
}

