/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic.properties;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.Secret;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Pattern;
import jenkins.security.FIPS140;
import jenkins.security.SecurityListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.oic.Messages;
import org.jenkinsci.plugins.oic.OicUserDetails;
import org.jenkinsci.plugins.oic.OidcProperty;
import org.jenkinsci.plugins.oic.OidcPropertyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCrypt;

public class EscapeHatch
extends OidcProperty {
    public static final Pattern B_CRYPT_PATTERN = Pattern.compile("\\A\\$[^$]+\\$\\d+\\$[./0-9A-Za-z]{53}");
    @NonNull
    private final String username;
    @CheckForNull
    private final String group;
    @NonNull
    private final Secret secret;
    private static final Random RANDOM = new Random();

    @DataBoundConstructor
    public EscapeHatch(@NonNull String username, @CheckForNull String group, @NonNull Secret secret) throws Descriptor.FormException {
        if (FIPS140.useCompliantAlgorithms()) {
            throw new Descriptor.FormException("Cannot use Escape Hatch in FIPS-140 mode", "escapeHatch");
        }
        String sanitizedUsername = Util.fixEmptyAndTrim((String)username);
        if (sanitizedUsername == null) {
            throw new Descriptor.FormException("Username must not be blank", "username");
        }
        this.username = sanitizedUsername;
        this.group = Util.fixEmptyAndTrim((String)group);
        String secretAsString = Secret.toString((Secret)secret);
        this.secret = B_CRYPT_PATTERN.matcher(secretAsString).matches() ? secret : Secret.fromString((String)BCrypt.hashpw((String)secretAsString, (String)BCrypt.gensalt()));
    }

    @CheckForNull
    public String getUsername() {
        return this.username;
    }

    @CheckForNull
    public String getGroup() {
        return this.group;
    }

    @NonNull
    public Secret getSecret() {
        return this.secret;
    }

    private void randomWait() {
        try {
            Thread.sleep(1000L + RANDOM.nextLong(1000L));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    @NonNull
    public Optional<Authentication> authenticate(@NonNull Authentication authentication) {
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            this.randomWait();
            if (this.check(authentication.getPrincipal().toString(), authentication.getCredentials().toString())) {
                ArrayList<Object> grantedAuthorities = new ArrayList<Object>();
                grantedAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
                if (StringUtils.isNotBlank((String)this.group)) {
                    grantedAuthorities.add(new SimpleGrantedAuthority(this.group));
                }
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)this.username, (Object)"", grantedAuthorities);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                OicUserDetails userDetails = new OicUserDetails(this.username, grantedAuthorities);
                SecurityListener.fireAuthenticated2((UserDetails)userDetails);
                return Optional.of(token);
            }
            throw new BadCredentialsException("Wrong username and password: " + String.valueOf(authentication));
        }
        return Optional.empty();
    }

    public boolean check(@NonNull String username, @CheckForNull String password) {
        return username.equals(this.username) && BCrypt.checkpw((String)password, (String)Secret.toString((Secret)this.secret));
    }

    protected Object readResolve() {
        if (FIPS140.useCompliantAlgorithms()) {
            throw new IllegalStateException(Messages.OicSecurityRealm_EscapeHatchFipsMode());
        }
        return this;
    }

    @Extension
    public static class CrumbExclusionImpl
    extends CrumbExclusion {
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if ("/securityRealm/escapeHatch".equals(pathInfo)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }

    public static class DescriptorImpl
    extends OidcPropertyDescriptor {
        @Extension
        @CheckForNull
        public static DescriptorImpl createIfApplicable() {
            if (FIPS140.useCompliantAlgorithms()) {
                return null;
            }
            return new DescriptorImpl();
        }

        @NonNull
        public String getDisplayName() {
            return "Escape Hatch";
        }
    }
}

