/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTab;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedCronTabList;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;

public class ParameterizedNextExecutionsUtils {
    private ParameterizedNextExecutionsUtils() {
    }

    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        Calendar cal = null;
        TimeZone timezone = null;
        try {
            Method isDisabledMethod = project.getClass().getMethod("isDisabled", new Class[0]);
            isDisabledMethod.setAccessible(true);
            if (((Boolean)isDisabledMethod.invoke((Object)project, new Object[0])).booleanValue()) {
                return null;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException isDisabledMethod) {
            // empty catch block
        }
        Map triggers = project.getTriggers();
        Iterator iterator = triggers.entrySet().iterator();
        while (iterator.hasNext()) {
            Trigger trigger = (Trigger)iterator.next().getValue();
            if (!trigger.getClass().equals(triggerClass) || !triggerClass.equals(ParameterizedTimerTrigger.class)) continue;
            try {
                Field triggerTabsField = ParameterizedTimerTrigger.class.getDeclaredField("cronTabList");
                triggerTabsField.setAccessible(true);
                ParameterizedCronTabList parameterizedCronTabList = (ParameterizedCronTabList)triggerTabsField.get(trigger);
                Field crontablistTabsField = ParameterizedCronTabList.class.getDeclaredField("cronTabs");
                crontablistTabsField.setAccessible(true);
                ArrayList parameterizedCrons = (ArrayList)crontablistTabsField.get(parameterizedCronTabList);
                for (ParameterizedCronTab parameterizedCron : parameterizedCrons) {
                    Field crontablistField = ParameterizedCronTab.class.getDeclaredField("cronTabList");
                    crontablistField.setAccessible(true);
                    CronTabList list = (CronTabList)crontablistField.get(parameterizedCron);
                    Field crontablistTabsField1 = CronTabList.class.getDeclaredField("tabs");
                    crontablistTabsField1.setAccessible(true);
                    Vector crons = (Vector)crontablistTabsField1.get(list);
                    for (CronTab cronTab : crons) {
                        timezone = cronTab.getTimeZone() != null ? cronTab.getTimeZone() : TimeZone.getDefault();
                        GregorianCalendar now = new GregorianCalendar(timezone);
                        cal = cal == null || cal.compareTo(cronTab.ceil((Calendar)now)) > 0 ? cronTab.ceil((Calendar)now) : cal;
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        if (cal != null) {
            return new NextBuilds(project, cal);
        }
        return null;
    }
}

