/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.scheduler.RareOrImpossibleDateException;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import jenkins.model.ParameterizedJobMixIn;

public class NextExecutionsUtils {
    private NextExecutionsUtils() {
    }

    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        Calendar cal = null;
        try {
            Method isDisabledMethod = project.getClass().getMethod("isDisabled", new Class[0]);
            isDisabledMethod.setAccessible(true);
            if (((Boolean)isDisabledMethod.invoke((Object)project, new Object[0])).booleanValue()) {
                return null;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        for (Trigger trigger : project.getTriggers().values()) {
            if (!trigger.getClass().equals(triggerClass)) continue;
            try {
                Field triggerTabsField = Trigger.class.getDeclaredField("tabs");
                triggerTabsField.setAccessible(true);
                CronTabList cronTabList = (CronTabList)triggerTabsField.get(trigger);
                Field crontablistTabsField = CronTabList.class.getDeclaredField("tabs");
                crontablistTabsField.setAccessible(true);
                Vector crons = (Vector)crontablistTabsField.get(cronTabList);
                for (CronTab cronTab : crons) {
                    TimeZone timezone = cronTab.getTimeZone() != null ? cronTab.getTimeZone() : TimeZone.getDefault();
                    try {
                        Calendar next = cronTab.ceil((Calendar)new GregorianCalendar(timezone));
                        if (cal != null && cal.compareTo(next) <= 0) continue;
                        cal = next;
                    }
                    catch (RareOrImpossibleDateException rareOrImpossibleDateException) {}
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            }
        }
        if (cal != null) {
            return new NextBuilds(project, cal);
        }
        return null;
    }
}

