/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.plugin;

import com.netsparker.cloud.model.ScanRequestResult;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Run;
import hudson.util.HttpResponses;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.verb.GET;

public class NCScanResultAction
implements Action,
RunAction2 {
    private ScanRequestResult scanRequestResult;
    private transient Run run;

    public NCScanResultAction(ScanRequestResult scanRequestResult) {
        this.scanRequestResult = scanRequestResult;
    }

    public ScanRequestResult getScanRequestResult() {
        return this.scanRequestResult;
    }

    public void setScanRequestResult(ScanRequestResult scanRequestResult) {
        this.scanRequestResult = scanRequestResult;
    }

    public String getError() {
        if (this.scanRequestResult.isError()) {
            return "true";
        }
        return "false";
    }

    public String getReportGenerated() {
        if (this.scanRequestResult.isReportGenerated()) {
            return "true";
        }
        return "false";
    }

    @GET
    public HttpResponse doGetContent() {
        String content = this.scanRequestResult.getReport().getContent();
        return HttpResponses.html((String)content);
    }

    @CheckForNull
    public String getIconFileName() {
        return "document.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Netsparker Enterprise Report";
    }

    @CheckForNull
    public String getUrlName() {
        return "netsparkercloudreport";
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run getRun() {
        return this.run;
    }
}

