/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.plugin;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.netsparker.cloud.model.IgnoredVulnerabilityStateFilters;
import com.netsparker.cloud.model.ProxyBlock;
import com.netsparker.cloud.model.ScanCancelRequest;
import com.netsparker.cloud.model.ScanCancelRequestResult;
import com.netsparker.cloud.model.ScanInfoRequest;
import com.netsparker.cloud.model.ScanInfoRequestResult;
import com.netsparker.cloud.model.ScanRequest;
import com.netsparker.cloud.model.ScanRequestResult;
import com.netsparker.cloud.model.ScanTaskState;
import com.netsparker.cloud.model.ScanType;
import com.netsparker.cloud.model.VCSCommit;
import com.netsparker.cloud.model.WebsiteModel;
import com.netsparker.cloud.model.WebsiteModelRequest;
import com.netsparker.cloud.model.WebsiteProfileModel;
import com.netsparker.cloud.plugin.Messages;
import com.netsparker.cloud.plugin.NCScanResultAction;
import com.netsparker.cloud.plugin.NCScanSCMAction;
import com.netsparker.cloud.utility.AppCommon;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.jenkinsci.Symbol;
import org.json.simple.parser.ParseException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

public class NCScanBuilder
extends Builder
implements SimpleBuildStep {
    private String ncScanType;
    private String ncWebsiteId;
    private String ncProfileId;
    private Secret ncApiToken;
    private String ncServerURL;
    private String credentialsId;
    private String ncSeverity;
    private Boolean ncStopScan;
    private Boolean ncConfirmed;
    private Boolean ncDoNotFail;
    private Boolean ncIgnoreFalsePositive;
    private Boolean ncIgnoreRiskAccepted;
    private IgnoredVulnerabilityStateFilters ncFilters = new IgnoredVulnerabilityStateFilters();
    private String ncReportType;
    private String ncScanTaskId;
    private Boolean ncAbortScan;
    private Boolean ncCancelEventFired;
    private Boolean useProxy;
    private String pHost;
    private String pPort;
    private String pUser;
    private String pPassword;
    private static final String apiTokenBuildParameterName = "APITOKEN";

    @DataBoundConstructor
    public NCScanBuilder(String ncScanType, String ncWebsiteId, String ncProfileId, Boolean ncDoNotFail, String ncReportType) {
        this.ncScanType = ncScanType == null ? "" : ncScanType;
        this.ncWebsiteId = ncWebsiteId == null ? "" : ncWebsiteId;
        this.ncProfileId = ncProfileId == null ? "" : ncProfileId;
        this.ncDoNotFail = ncDoNotFail;
        this.ncReportType = ncReportType == null || ncReportType.equals("null") ? "ExecutiveSummary" : ncReportType;
    }

    public String getNcSeverity() {
        return this.ncSeverity;
    }

    public Boolean getNcStopScan() {
        return this.ncStopScan;
    }

    public Boolean getNcConfirmed() {
        return this.ncConfirmed;
    }

    public Boolean getNcDoNotFail() {
        return this.ncDoNotFail;
    }

    public String getNcScanType() {
        return this.ncScanType;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public IgnoredVulnerabilityStateFilters getFilters() {
        return this.ncFilters;
    }

    public void setFilters() {
        this.ncFilters = new IgnoredVulnerabilityStateFilters();
        this.ncFilters.setFalsePositive(this.ncIgnoreFalsePositive);
        this.ncFilters.setAcceptedRisk(this.ncIgnoreRiskAccepted);
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setNcScanType(String ncScanType) {
        this.ncScanType = ncScanType;
    }

    public String getNcWebsiteId() {
        return this.ncWebsiteId;
    }

    public void setNcWebsiteId(String ncTargetURL) {
        this.ncWebsiteId = ncTargetURL;
    }

    public String getNcProfileId() {
        return this.ncProfileId;
    }

    public void setNcProfileId(String ncProfileId) {
        this.ncProfileId = ncProfileId;
    }

    public String getNcServerURL() {
        return this.ncServerURL;
    }

    @DataBoundSetter
    public void setNcSeverity(String ncSeverity) {
        this.ncSeverity = ncSeverity;
    }

    @DataBoundSetter
    public void setNcStopScan(Boolean ncStopScan) {
        this.ncStopScan = ncStopScan;
    }

    @DataBoundSetter
    public void setNcConfirmed(Boolean ncConfirmed) {
        this.ncConfirmed = ncConfirmed;
    }

    @DataBoundSetter
    public void setNcDoNotFail(Boolean ncDoNotFail) {
        this.ncDoNotFail = ncDoNotFail;
    }

    @DataBoundSetter
    public void setNcServerURL(String ncServerURL) {
        this.ncServerURL = ncServerURL;
    }

    public Secret getNcApiToken() {
        if (this.ncApiToken == null) {
            this.ncApiToken = this.getDescriptor().getNcApiToken();
        }
        return this.ncApiToken;
    }

    @DataBoundSetter
    public void setNcApiToken(Object ncApiToken) {
        if (ncApiToken.getClass() == String.class) {
            this.ncApiToken = Secret.fromString((String)((String)ncApiToken));
        }
        if (ncApiToken.getClass() == Secret.class) {
            this.ncApiToken = (Secret)ncApiToken;
        }
    }

    public Boolean getNcIgnoreFalsePositive() {
        return this.ncIgnoreFalsePositive;
    }

    @DataBoundSetter
    public void setNcIgnoreFalsePositive(Boolean ncIgnoreFalsePositive) {
        this.ncIgnoreFalsePositive = ncIgnoreFalsePositive;
    }

    public Boolean getNcIgnoreRiskAccepted() {
        return this.ncIgnoreRiskAccepted;
    }

    @DataBoundSetter
    public void setNcIgnoreRiskAccepted(Boolean ncIgnoreRiskAccepted) {
        this.ncIgnoreRiskAccepted = ncIgnoreRiskAccepted;
    }

    public String getNcReportType() {
        return this.ncReportType;
    }

    @DataBoundSetter
    public void setNcReportType(String ncReportType) {
        this.ncReportType = ncReportType;
    }

    public void setScanTaskId(String ncScanTaskId) {
        this.ncScanTaskId = ncScanTaskId;
    }

    public String getScanTaskId() {
        return this.ncScanTaskId;
    }

    public void setCancelState(Boolean ncCancelEventFired) {
        this.ncCancelEventFired = ncCancelEventFired;
    }

    public Boolean getCancelState() {
        return this.ncCancelEventFired;
    }

    @DataBoundSetter
    public void setNcAbortScan(Boolean ncAbortScan) {
        this.ncAbortScan = ncAbortScan;
    }

    public Boolean getNcAbortScan() {
        return this.ncAbortScan;
    }

    @DataBoundSetter
    public void setUseProxy(Boolean useProxy) {
        this.useProxy = useProxy;
    }

    public Boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setpHost(String pHost) {
        this.pHost = pHost;
    }

    public String getpHost() {
        return this.pHost;
    }

    @DataBoundSetter
    public void setpPort(String pPort) {
        this.pPort = pPort;
    }

    public String getpPort() {
        return this.pPort;
    }

    @DataBoundSetter
    public void setpUser(String pUser) {
        this.pUser = pUser;
    }

    public String getpUser() {
        return this.pUser;
    }

    @DataBoundSetter
    public void setpPassword(String pPassword) {
        this.pPassword = pPassword;
    }

    public String getpPassword() {
        return this.pPassword;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.logInfo("Scan step created...", listener);
        NCScanSCMAction scmAction = (NCScanSCMAction)build.getAction(NCScanSCMAction.class);
        VCSCommit commit = scmAction == null ? VCSCommit.empty(build) : scmAction.getVcsCommit();
        try {
            this.ScanRequestHandler(build, commit, listener);
        }
        catch (RuntimeException e) {
            this.logInfo(e.getMessage(), listener);
            throw e;
        }
        catch (AbortException e) {
            try {
                Boolean cancelScanWhenUserAbortsOperation;
                Boolean useProxy;
                StandardUsernamePasswordCredentials credential;
                String ncServerURL;
                DescriptorImpl descriptor = this.getDescriptor();
                String string = ncServerURL = StringUtils.isBlank((String)this.getNcServerURL()) ? descriptor.getNcServerURL() : this.getNcServerURL();
                if (!StringUtils.isEmpty((String)this.credentialsId) && (credential = AppCommon.findCredentialsById(this.credentialsId, (String)build.getEnvironment(listener).get((Object)"job_name"))) != null) {
                    ncServerURL = credential.getUsername();
                    this.ncApiToken = credential.getPassword();
                }
                if (this.ncApiToken == null || this.ncApiToken.getPlainText().isEmpty()) {
                    Secret secret = this.ncApiToken = this.getNcApiToken() != null && StringUtils.isBlank((String)this.getNcApiToken().getPlainText()) ? descriptor.getNcApiToken() : this.getNcApiToken();
                }
                if (Secret.toString((Secret)this.ncApiToken) == "$APITOKEN") {
                    this.ncApiToken = this.GetApiTokenFromBuildParameters(build);
                }
                ProxyBlock proxy = null;
                String pHost = null;
                String pPort = null;
                String pUser = null;
                String pPassword = null;
                Boolean bl = useProxy = this.getUseProxy() == null ? descriptor.getUseProxy() : this.getUseProxy();
                if (useProxy != null && useProxy.booleanValue()) {
                    pHost = StringUtils.isBlank((String)this.getpHost()) ? descriptor.getpHost() : this.getpHost();
                    pPort = StringUtils.isBlank((String)this.getpPort()) ? descriptor.getpPort() : this.getpPort();
                    pUser = StringUtils.isBlank((String)this.getpUser()) ? descriptor.getpUser() : this.getpUser();
                    pPassword = StringUtils.isBlank((String)this.getpPassword()) ? descriptor.getpPassword() : this.getpPassword();
                    proxy = new ProxyBlock(useProxy, pHost, pPort, pUser, pPassword);
                }
                if ((cancelScanWhenUserAbortsOperation = this.getNcAbortScan()).booleanValue() && !this.getCancelState().booleanValue()) {
                    this.CancelScan(ncServerURL, this.ncApiToken, proxy, this.getScanTaskId(), listener);
                }
            }
            catch (RuntimeException ex) {
                this.logInfo(ex.getMessage(), listener);
                throw ex;
            }
            catch (Exception ex) {
                this.logInfo(ex.getMessage(), listener);
            }
            this.logInfo(e.getMessage(), listener);
        }
        catch (Exception e) {
            try {
                build.replaceAction((Action)new NCScanResultAction(ScanRequestResult.errorResult("Scan Request Failed:: " + e.getMessage())));
            }
            catch (Exception ex) {
                build.addAction((Action)new NCScanResultAction(ScanRequestResult.errorResult("Scan Request Failed:: " + e.getMessage())));
            }
            build.setResult(Result.FAILURE);
        }
    }

    private Secret GetApiTokenFromBuildParameters(Run<?, ?> build) {
        Object value;
        ParameterValue parameter;
        Secret secret = null;
        ParametersAction parametersAction = (ParametersAction)build.getAction(ParametersAction.class);
        if (parametersAction != null && (parameter = (ParameterValue)parametersAction.getAllParameters().stream().filter(p -> p.getName().contains(apiTokenBuildParameterName)).findAny().orElse(null)) != null && parameter.getValue() != null && (value = parameter.getValue()) != null && value.getClass() != null) {
            if (value.getClass() == Secret.class) {
                secret = (Secret)value;
            } else if (value.getClass() == String.class) {
                secret = Secret.fromString((String)((String)value));
            }
        }
        return secret;
    }

    private void ScanRequestHandler(Run<?, ?> build, VCSCommit commit, TaskListener listener) throws Exception {
        StandardUsernamePasswordCredentials credential;
        Boolean useProxy;
        DescriptorImpl descriptor = this.getDescriptor();
        String ncServerURL = StringUtils.isBlank((String)this.getNcServerURL()) ? descriptor.getNcServerURL() : this.getNcServerURL();
        Secret ncApiToken = null;
        ProxyBlock proxy = null;
        String pHost = null;
        String pPort = null;
        String pUser = null;
        String pPassword = null;
        Boolean bl = useProxy = this.getUseProxy() == null ? descriptor.getUseProxy() : this.getUseProxy();
        if (useProxy != null && useProxy.booleanValue()) {
            pHost = StringUtils.isBlank((String)this.getpHost()) ? descriptor.getpHost() : this.getpHost();
            pPort = StringUtils.isBlank((String)this.getpPort()) ? descriptor.getpPort() : this.getpPort();
            pUser = StringUtils.isBlank((String)this.getpUser()) ? descriptor.getpUser() : this.getpUser();
            pPassword = StringUtils.isBlank((String)this.getpPassword()) ? descriptor.getpPassword() : this.getpPassword();
            proxy = new ProxyBlock(useProxy, pHost, pPort, pUser, pPassword);
        }
        String rootUrl = null;
        if (!StringUtils.isEmpty((String)this.credentialsId) && (credential = AppCommon.findCredentialsById(this.credentialsId, (String)build.getEnvironment(listener).get((Object)"job_name"))) != null) {
            ncServerURL = credential.getUsername();
            ncApiToken = credential.getPassword();
        }
        if (ncApiToken == null || ncApiToken.getPlainText().isEmpty()) {
            Secret secret = ncApiToken = this.getNcApiToken() != null && StringUtils.isBlank((String)this.getNcApiToken().getPlainText()) ? descriptor.getNcApiToken() : this.getNcApiToken();
        }
        if (Secret.toString(ncApiToken) == "$APITOKEN") {
            ncApiToken = this.GetApiTokenFromBuildParameters(build);
        }
        if (StringUtils.isEmpty(rootUrl)) {
            rootUrl = descriptor.getRootURL();
        }
        commit.setRootURL(rootUrl);
        ScanRequest scanRequest = new ScanRequest(ncServerURL, ncApiToken, this.ncScanType, this.ncWebsiteId, this.ncProfileId, commit, proxy);
        this.logInfo("Requesting scan...", listener);
        ClassicHttpResponse scanRequestResponse = scanRequest.scanRequest();
        this.logInfo("Response status code: " + scanRequestResponse.getCode(), listener);
        ScanRequestResult scanRequestResult = new ScanRequestResult(scanRequestResponse, ncServerURL, ncApiToken, this.ncReportType, proxy);
        build.replaceAction((Action)new NCScanResultAction(scanRequestResult));
        this.setFilters();
        this.setScanTaskId(scanRequestResult.getScanTaskId());
        if (scanRequestResult.getHttpStatusCode() == 201 && !scanRequestResult.isError()) {
            this.ScanRequestSuccessHandler(ncServerURL, ncApiToken, proxy, scanRequestResult, scanRequestResult.getScanTaskId(), this.ncDoNotFail, this.ncConfirmed, this.ncFilters, listener);
        } else {
            this.ScanRequestFailureHandler(scanRequestResult, listener);
        }
    }

    private void ScanRequestSuccessHandler(String ncServerURL, Secret ncApiToken, ProxyBlock proxy, ScanRequestResult scanRequestResult, String scanTaskId, Boolean doNotFail, Boolean isConfirmed, IgnoredVulnerabilityStateFilters filters, TaskListener listener) throws IOException, URISyntaxException, InterruptedException {
        this.logInfo("Scan requested successfully.", listener);
        ScanTaskState scanStatus = ScanTaskState.Queued;
        Boolean scanAbortedExternally = false;
        Boolean scanInfoConnectionError = false;
        Boolean isScanStarted = false;
        Boolean isSeverityBreaked = false;
        try {
            while (!scanStatus.equals((Object)ScanTaskState.Complete)) {
                ScanInfoRequest scanInfoRequest = new ScanInfoRequest(ncServerURL, ncApiToken, scanTaskId, this.ncDoNotFail, this.ncConfirmed, this.ncFilters, proxy);
                this.logInfo("Requesting scan info...", listener);
                ClassicHttpResponse scanInfoRequestResponse = scanInfoRequest.scanInfoRequest();
                this.logInfo("Response scan info status code: " + scanInfoRequestResponse.getCode(), listener);
                ScanInfoRequestResult scanInfoRequestResult = new ScanInfoRequestResult(scanInfoRequestResponse);
                if (scanInfoRequestResult.isError()) {
                    scanInfoConnectionError = true;
                    this.logInfo("Get scan info error", listener);
                    this.logError(scanInfoRequestResult.getErrorMessage(), listener);
                    throw new AbortException("Error when getting scan info!");
                }
                scanStatus = scanInfoRequestResult.getScanTaskState();
                if (scanInfoRequestResult.checkSeverity(this.ncSeverity)) {
                    isSeverityBreaked = true;
                    String severityText = this.SeverityOptionsForBuildFailMesssage().get(this.ncSeverity);
                    String failMessage = "Build failed because scan contains " + severityText + " severity!";
                    this.logInfo(failMessage, listener);
                    throw new AbortException(failMessage);
                }
                if (scanStatus.equals((Object)ScanTaskState.Scanning) && !isScanStarted.booleanValue()) {
                    isScanStarted = true;
                    this.logInfo("Scan started...", listener);
                } else if (scanStatus.equals((Object)ScanTaskState.Failed) || scanStatus.equals((Object)ScanTaskState.Cancelled) || scanStatus.equals((Object)ScanTaskState.Paused) || scanStatus.equals((Object)ScanTaskState.Pausing)) {
                    scanAbortedExternally = true;
                    this.logInfo("Scan aborted because state is " + scanStatus.toString(), listener);
                    throw new AbortException("The scan was aborted outside of this instance");
                }
                Thread.sleep(10000L);
            }
            this.logInfo("Scan completed...", listener);
        }
        catch (AbortException e) {
            Boolean isCancel = scanInfoConnectionError != false || this.ncStopScan != null && this.ncStopScan != false && (isSeverityBreaked != false || scanAbortedExternally == false);
            if (isCancel.booleanValue()) {
                this.CancelScan(ncServerURL, ncApiToken, proxy, scanTaskId, listener);
                this.setCancelState(true);
            } else {
                this.setCancelState(false);
            }
            throw new AbortException("The build was aborted");
        }
        catch (Exception e) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            this.logInfo(errors.toString(), listener);
            this.setCancelState(false);
            throw new AbortException("The build was aborted");
        }
    }

    private HashMap<String, String> SeverityOptionsForBuildFailMesssage() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("DoNotFail", "Do not fail the build");
        options.put("Critical", "Critical");
        options.put("Critical,High", "High or above");
        options.put("Critical,High,Medium", "Medium or above");
        options.put("Critical,High,Medium,Low", "Low or above");
        options.put("Critical,High,Medium,Low,Best Practice", "Best Practices or above");
        return options;
    }

    private void CancelScan(String ncServerURL, Secret ncApiToken, ProxyBlock proxy, String scanTaskId, TaskListener listener) throws IOException, MalformedURLException, NullPointerException, URISyntaxException {
        ScanCancelRequest scanCancelRequest = new ScanCancelRequest(ncServerURL, ncApiToken, scanTaskId, proxy);
        this.logInfo("Requesting scan cancel...", listener);
        ClassicHttpResponse scanCancelRequestResponse = scanCancelRequest.scanCancelRequest();
        this.logInfo("Response scan cancel status code: " + scanCancelRequestResponse.getCode(), listener);
        ScanCancelRequestResult scanCancelRequestResult = new ScanCancelRequestResult(scanCancelRequestResponse);
        if (scanCancelRequestResult.isError()) {
            this.logInfo("Scan cancel error", listener);
            this.logError(scanCancelRequestResult.getErrorMessage(), listener);
            throw new AbortException("Error when scan cancel!");
        }
        this.logInfo("Scan canceled Id:" + scanTaskId, listener);
    }

    private void ScanRequestFailureHandler(ScanRequestResult scanRequestResult, TaskListener listener) throws Exception {
        this.logError("Scan request failed. Error Message: " + scanRequestResult.getErrorMessage(), listener);
        throw new Exception("Netsparker Enterprise Plugin: Failed to start the scan. Response status code: " + scanRequestResult.getHttpStatusCode());
    }

    private void logInfo(String message, TaskListener listener) {
        listener.getLogger().println("> Netsparker Enterprise Plugin: " + message);
    }

    private void logError(String message, TaskListener listener) {
        listener.error("> Netsparker Enterprise Plugin: " + message);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"NCScanBuilder"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private long lastEditorId = 0L;
        private ArrayList<WebsiteModel> websiteModels = new ArrayList();
        private String ncServerURL;
        private Secret ncApiToken;
        private String rootURL;
        private Boolean useProxy;
        private String pHost;
        private String pPort;
        private String pUser;
        private String pPassword;

        public DescriptorImpl() {
            super(NCScanBuilder.class);
            this.load();
            Logger.getLogger(DescriptorImpl.class.getName()).info("Netsparker Descriptor loaded");
        }

        public String getNcServerURL() {
            return this.ncServerURL;
        }

        public void setNcServerURL(String ncServerURL) {
            this.ncServerURL = ncServerURL;
        }

        public Secret getNcApiToken() {
            return this.ncApiToken;
        }

        public void setNcApiToken(String ncApiToken) {
            this.ncApiToken = Secret.fromString((String)ncApiToken);
        }

        public String getRootURL() {
            return this.rootURL;
        }

        public Boolean getUseProxy() {
            return this.useProxy;
        }

        public void setUseProxy(Boolean useProxy) {
            this.useProxy = useProxy;
        }

        public String getpHost() {
            return this.pHost;
        }

        public void setpHost(String pHost) {
            this.pHost = pHost;
        }

        public String getpPort() {
            return this.pPort;
        }

        public void setpPort(String pPort) {
            this.pPort = pPort;
        }

        public String getpUser() {
            return this.pUser;
        }

        public void setpUser(String pUser) {
            this.pUser = pUser;
        }

        public String getpPassword() {
            return this.pPassword;
        }

        public void setpPassword(String pPassword) {
            this.pPassword = pPassword;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            Logger.getLogger(DescriptorImpl.class.getName()).info("NCScanBuilder descriptor isApplicable called");
            return true;
        }

        public String getDisplayName() {
            Logger.getLogger(DescriptorImpl.class.getName()).info("NCScanBuilder getDisplayName called");
            return Messages.NCScanBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            this.ncServerURL = formData.getString("ncServerURL");
            this.ncApiToken = Secret.fromString((String)formData.getString("ncApiToken"));
            this.useProxy = formData.getBoolean("useProxy");
            this.pHost = formData.getString("pHost");
            this.pPort = formData.getString("pPort");
            this.pUser = formData.getString("pUser");
            this.pPassword = formData.getString("pPassword");
            this.rootURL = Jenkins.get().getRootUrl();
            this.save();
            return super.configure(req, formData);
        }

        public String getConfigPage() {
            ProxyBlock proxy = null;
            if (this.useProxy != null && this.useProxy.booleanValue()) {
                proxy = new ProxyBlock(this.useProxy, this.pHost, this.pPort, this.pUser, this.pPassword);
            }
            try {
                this.updateWebsiteModels(this.ncServerURL, this.ncApiToken, proxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.getConfigPage();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item owner, @QueryParameter String credentialsId) {
            StandardListBoxModel listBoxModel = new StandardListBoxModel();
            listBoxModel.includeEmptyValue();
            if (owner == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !owner.hasPermission(Item.EXTENDED_READ) && !owner.hasPermission(CredentialsProvider.USE_ITEM)) {
                return listBoxModel.includeCurrentValue(credentialsId);
            }
            for (StandardUsernamePasswordCredentials credentialToAdd : AppCommon.findCredentials(owner)) {
                listBoxModel.with((IdCredentials)credentialToAdd);
            }
            listBoxModel.includeCurrentValue(credentialsId);
            return listBoxModel;
        }

        @JavaScriptMethod
        public synchronized String createEditorId() {
            return String.valueOf(this.lastEditorId++);
        }

        public ListBoxModel doFillNcScanTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Please Select Scan Type", "");
            model.add("Incremental", "Incremental");
            model.add("Full (With primary profile)", "FullWithPrimaryProfile");
            model.add("Full (With selected profile)", "FullWithSelectedProfile");
            return model;
        }

        public ListBoxModel doFillNcWebsiteIdItems(@QueryParameter String credentialsId) {
            if (!StringUtils.isEmpty((String)credentialsId)) {
                this.doTestConnection(credentialsId);
            }
            ListBoxModel model = new ListBoxModel();
            model.add("Please select website", "");
            for (WebsiteModel websiteModel : this.websiteModels) {
                model.add(websiteModel.getDisplayName(), websiteModel.getId());
            }
            return model;
        }

        public ListBoxModel doFillNcProfileIdItems(@QueryParameter String ncWebsiteId) {
            WebsiteModel websiteModel = new WebsiteModel();
            for (WebsiteModel wm : this.websiteModels) {
                if (ncWebsiteId == null || !wm.getId().equals(ncWebsiteId)) continue;
                websiteModel = wm;
                break;
            }
            ArrayList<WebsiteProfileModel> websiteProfileModels = websiteModel.getProfiles();
            ListBoxModel model = new ListBoxModel();
            if (websiteProfileModels.isEmpty()) {
                String placeholderText = "-- No profile found --";
                model.add(placeholderText, "");
            } else {
                model.add("Please Select Scan Profile", "");
                for (WebsiteProfileModel websiteProfileModel : websiteProfileModels) {
                    boolean isSelected = websiteProfileModels.size() == 1;
                    model.add((Object)new ListBoxModel.Option(websiteProfileModel.getName(), websiteProfileModel.getId(), isSelected));
                }
            }
            return model;
        }

        public ListBoxModel doFillNcReportTypeItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Please Select Report Type", "");
            model.add("Detailed Scan Report", "ScanDetail");
            model.add("Executive Summary", "ExecutiveSummary");
            model.add("Full Scan Detail", "FullScanDetail");
            model.add("HIPAA Compliance", "HIPAACompliance");
            model.add("ISO 27001 Compliance", "Iso27001Compliance");
            model.add("Knowledge Base", "KnowledgeBase");
            model.add("OWASP Top Ten 2013", "OwaspTopTen2013");
            model.add("OWASP Top Ten 2017", "OwaspTopTen2017");
            model.add("PCI DSS Compliance", "PCICompliance");
            model.add("SANS Top 25", "SansTop25");
            model.add("WASC Threat Classification", "WASC");
            return model;
        }

        private int updateWebsiteModels(String ncServerURL, Secret ncApiToken, ProxyBlock proxy) throws IOException, URISyntaxException, ParseException {
            WebsiteModelRequest websiteModelRequest = new WebsiteModelRequest(ncServerURL, ncApiToken, proxy);
            ClassicHttpResponse response = websiteModelRequest.getPluginWebSiteModels();
            int statusCode = response.getCode();
            if (statusCode == 200) {
                this.websiteModels = new ArrayList();
                this.websiteModels.addAll(websiteModelRequest.getWebsiteModels());
            } else if (statusCode == 401) {
                this.websiteModels.clear();
            }
            return statusCode;
        }

        private FormValidation validateConnection(String ncServerURL, Secret ncApiToken, ProxyBlock proxy) {
            try {
                int statusCode = this.updateWebsiteModels(ncServerURL, ncApiToken, proxy);
                if (statusCode == 200) {
                    return FormValidation.ok((String)"Successfully connected to the Netsparker Enterprise.");
                }
                return FormValidation.error((String)("Netsparker Enterprise rejected the request. HTTP status code: " + statusCode));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Failed to connect to the Netsparker Enterprise. : " + e.toString()));
            }
        }

        @POST
        public FormValidation doValidateAPI(@QueryParameter String ncServerURL, @QueryParameter Secret ncApiToken, @QueryParameter Boolean useProxy, @QueryParameter String pHost, @QueryParameter String pPort, @QueryParameter String pUser, @QueryParameter String pPassword) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ProxyBlock proxy = null;
            if (useProxy != null && useProxy.booleanValue()) {
                proxy = new ProxyBlock(useProxy, pHost, pPort, pUser, pPassword);
            }
            return this.validateConnection(ncServerURL, ncApiToken, proxy);
        }

        public FormValidation doTestConnection(@QueryParameter String credentialsId) {
            String errorTemplate = "Error: %s";
            try {
                String descriptorUrl = DescriptorImpl.getCurrentDescriptorByNameUrl();
                StandardUsernamePasswordCredentials credential = AppCommon.findCredentialsById(credentialsId, descriptorUrl);
                if (credential == null) {
                    return FormValidation.error((String)"Error: %s", (Object[])new Object[]{"Credentials not found."});
                }
                String serverURL = credential.getUsername();
                Secret apiToken = credential.getPassword();
                ProxyBlock proxy = null;
                if (this.useProxy != null && this.useProxy.booleanValue()) {
                    proxy = new ProxyBlock(this.useProxy, this.pHost, this.pPort, this.pUser, this.pPassword);
                }
                return this.validateConnection(serverURL, apiToken, proxy);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Error: %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        public FormValidation doCheckNcServerURL(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_missingApiURL());
            }
            if (!AppCommon.isUrlValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidApiURL());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckNcApiToken(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_missingApiToken());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcScanType(@QueryParameter String value) {
            try {
                ScanType.valueOf(value);
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidScanType());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcWebsiteId(@QueryParameter String value) {
            if (!AppCommon.isGUIDValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidWebsiteId());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNcProfileId(@QueryParameter String value, @QueryParameter String ncScanType) {
            boolean isRequired;
            try {
                ScanType type = ScanType.valueOf(ncScanType);
                isRequired = type != ScanType.FullWithPrimaryProfile;
            }
            catch (Exception ex) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidProfileId());
            }
            if (isRequired && !AppCommon.isGUIDValid(value)) {
                return FormValidation.error((String)Messages.NCScanBuilder_DescriptorImpl_errors_invalidProfileId());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillNcSeverityItems() throws IOException {
            ListBoxModel items = new ListBoxModel();
            items.add("Do not fail the build", "DoNotFail");
            items.add("Critical", "Critical");
            items.add("High or above", "Critical,High");
            items.add("Medium or above", "Critical,High,Medium");
            items.add("Low or above", "Critical,High,Medium,Low");
            items.add("Best Practices or above", "Critical,High,Medium,Low,Best Practice");
            return items;
        }
    }
}

