/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.utility.AppCommon;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.util.VersionNumber;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class VCSCommit {
    private final String ciBuildServerVersion;
    private final String ciNcPluginVersion;
    private final String buildId;
    private final String buildConfigurationName;
    private final String buildURL;
    private final boolean buildHasChange;
    private final String versionControlName;
    private final String committer;
    private final String vcsVersion;
    private final String ciTimestamp;
    private String rootURL = "";

    public VCSCommit(Run<?, ?> build, ChangeLogSet<?> changelog) {
        this.buildId = String.valueOf(build.number);
        this.buildConfigurationName = build.getParent().getName();
        this.buildURL = this.getBuildURL(build);
        SimpleDateFormat iso8601DateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        boolean bl = this.buildHasChange = changelog != null && !changelog.isEmptySet();
        if (this.buildHasChange) {
            this.versionControlName = changelog.getKind();
            ChangeLogSet.Entry change = (ChangeLogSet.Entry)changelog.getItems()[0];
            long ciTimestampInMilliseconds = change.getTimestamp();
            this.ciTimestamp = iso8601DateTimeFormat.format(new Date(ciTimestampInMilliseconds));
            User author = change.getAuthor();
            this.vcsVersion = change.getCommitId();
            String fullName = author.getFullName();
            String displayName = author.getDisplayName();
            this.committer = AppCommon.isValidEmailAddress(fullName) ? fullName : (AppCommon.isValidEmailAddress(displayName) ? displayName : fullName);
        } else {
            this.versionControlName = "";
            this.ciTimestamp = iso8601DateTimeFormat.format(new Date());
            this.vcsVersion = "";
            this.committer = "";
        }
        VersionNumber versionNumber = Jenkins.getVersion();
        this.ciBuildServerVersion = versionNumber != null ? versionNumber.toString() : "Not found.";
        this.ciNcPluginVersion = null;
    }

    public static VCSCommit empty(Run<?, ?> build) {
        return new VCSCommit(build, null);
    }

    public void setRootURL(String rootURL) {
        if (rootURL == null) {
            this.rootURL = "";
            return;
        }
        this.rootURL = rootURL;
    }

    public void addVcsCommitInfo(List<NameValuePair> params) {
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildId", this.buildId));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.IntegrationSystem", "Jenkins"));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildServerVersion", this.ciBuildServerVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiNcPluginVersion", this.ciNcPluginVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildConfigurationName", this.buildConfigurationName));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildUrl", this.rootURL + this.buildURL));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiBuildHasChange", String.valueOf(this.buildHasChange)));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.CiTimestamp", this.ciTimestamp));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.VcsName", this.versionControlName));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.VcsVersion", this.vcsVersion));
        params.add((NameValuePair)new BasicNameValuePair("VcsCommitInfoModel.Committer", this.committer));
    }

    private String getBuildURL(Run<?, ?> build) {
        try {
            return build.getUrl();
        }
        catch (Exception ex) {
            return "";
        }
    }
}

