/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ScanRequestBase;
import com.netsparker.cloud.utility.AppCommon;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.json.simple.parser.ParseException;

public class ScanCancelRequestResult
extends ScanRequestBase {
    private final int httpStatusCode;
    private String data;
    private String scanTaskID;
    private boolean isError;
    private String errorMessage;

    public static ScanCancelRequestResult errorResult(String errorMessage) {
        return new ScanCancelRequestResult(errorMessage);
    }

    private ScanCancelRequestResult(String errorMessage) {
        this.errorMessage = errorMessage;
        this.httpStatusCode = 0;
        this.isError = true;
        this.data = "";
    }

    public ScanCancelRequestResult(ClassicHttpResponse response) throws MalformedURLException, URISyntaxException {
        this.httpStatusCode = response.getCode();
        boolean bl = this.isError = this.httpStatusCode != 200;
        if (!this.isError) {
            try {
                this.data = AppCommon.parseResponseToString(response);
                boolean bl2 = this.isError = (Boolean)AppCommon.parseJsonValue(this.data, "IsValid") == false;
                if (!this.isError) {
                    this.scanTaskID = (String)AppCommon.parseJsonValue(this.data, "ScanTaskId");
                } else {
                    this.errorMessage = (String)AppCommon.parseJsonValue(this.data, "ErrorMessage");
                }
            }
            catch (ParseException ex) {
                this.isError = true;
                this.errorMessage = "Scan info request result is not parsable::: " + ex.toString();
            }
            catch (IOException ex) {
                this.isError = true;
                this.errorMessage = "Scan info request result is not readable::: " + ex.toString();
            }
        }
    }

    public String getScanTaskId() {
        return this.scanTaskID;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.isError;
    }
}

