package com.netsparker.cloud.model;

import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IgnoredVulnerabilityStateFilters{

    private String filtersString;
    private JSONObject filtersJsonObject;
    private Boolean present;
    private Boolean fixedUnconfirmed;
    private Boolean fixedCantRetest;
    private Boolean fixedConfirmed;
    private Boolean revived;
    private Boolean scanning;
    private Boolean ignored;
    private Boolean acceptedRisk;
    private Boolean falsePositive;

    public IgnoredVulnerabilityStateFilters(){
        assignAllToFalse();
    }

    // GETTERS & SETTERS

    public String getFiltersString(){
        return filtersString;
    }

    public void setFiltersString() {
        JSONObject object = new JSONObject();
        object.put("present" , this.present);
        object.put("fixedUnconfirmed" , this.fixedUnconfirmed);
        object.put("fixedCantRetest" , this.fixedCantRetest);
        object.put("fixedConfirmed" , this.fixedConfirmed);
        object.put("revived" , this.revived);
        object.put("scanning" , this.scanning);
        object.put("ignored" , this.ignored);
        object.put("acceptedRisk" , this.acceptedRisk);
        object.put("falsePositive" , this.falsePositive);
        this.filtersJsonObject = object;
        this.filtersString = object.toJSONString();
    }

    public JSONObject getFiltersJsonObject() {
        return filtersJsonObject;
    }

    public void setFiltersJsonObject() throws ParseException {
        JSONParser jsonParser = new JSONParser();
        this.filtersJsonObject = (JSONObject) jsonParser.parse(getFiltersString());
    }

    public Boolean getPresent() {
        return present;
    }

    public void setPresent(Boolean present) {
        this.present = present;
    }

    public Boolean getFixedUnconfirmed() {
        return fixedUnconfirmed;
    }

    public void setFixedUnconfirmed(Boolean fixedUnconfirmed) {
        this.fixedUnconfirmed = fixedUnconfirmed;
    }

    public Boolean getFixedCantRetest() {
        return fixedCantRetest;
    }

    public void setFixedCantRetest(Boolean fixedCantRetest) {
        this.fixedCantRetest = fixedCantRetest;
    }

    public Boolean getFixedConfirmed() {
        return fixedConfirmed;
    }

    public void setFixedConfirmed(Boolean fixedConfirmed) {
        this.fixedConfirmed = fixedConfirmed;
    }

    public Boolean getRevived() {
        return revived;
    }

    public void setRevived(Boolean revived) {
        this.revived = revived;
    }

    public Boolean getScanning() {
        return scanning;
    }

    public void setScanning(Boolean scanning) {
        this.scanning = scanning;
    }

    public Boolean getIgnored() {
        return ignored;
    }

    public void setIgnored(Boolean ignored) {
        this.ignored = ignored;
    }

    public Boolean getAcceptedRisk() {
        return acceptedRisk;
    }

    public void setAcceptedRisk(Boolean acceptedRisk) {
        this.acceptedRisk = acceptedRisk;
    }

    public Boolean getFalsePositive() {
        return falsePositive;
    }

    public void setFalsePositive(Boolean falsePositive) {
        this.falsePositive = falsePositive;
    }

    private void assignAllToFalse(){
        this.present = false;
        this.fixedUnconfirmed = false;
        this.fixedCantRetest = false;
        this.fixedConfirmed = false;
        this.revived = false;
        this.scanning = false;
        this.ignored = false;
        this.acceptedRisk = false;
        this.falsePositive = false;
    }

    private void assignAllToTrue(){
        this.present = true;
        this.fixedUnconfirmed = true;
        this.fixedCantRetest = true;
        this.fixedConfirmed = true;
        this.revived = true;
        this.scanning = true;
        this.ignored = true;
        this.acceptedRisk = true;
        this.falsePositive = true;
    }

}


