/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinci.plugins.mock_slave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jenkinci.plugins.mock_slave.UnboundedBlockingByteQueue;

final class Throttler {
    private final int latency;
    private final int bandwidth;
    private final InputStream is;
    private final OutputStream os;

    Throttler(int latency, int bandwidth, InputStream is, OutputStream os) throws IOException {
        this.latency = latency;
        this.bandwidth = bandwidth;
        UnboundedBlockingByteQueue in = new UnboundedBlockingByteQueue("in", 131072, 1.3f);
        new StreamCopyThread("incoming", is, new DelayedOutputStream(in)).start();
        this.is = new DelayedInputStream(in);
        UnboundedBlockingByteQueue out = new UnboundedBlockingByteQueue("out", 131072, 1.3f);
        new StreamCopyThread("outgoing", new DelayedInputStream(out), os).start();
        this.os = new DelayedOutputStream(out);
    }

    InputStream is() {
        return this.is;
    }

    OutputStream os() {
        return this.os;
    }

    private static class StreamCopyThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        StreamCopyThread(String threadName, InputStream in, OutputStream out) {
            super(threadName);
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                try {
                    int c;
                    while ((c = this.in.read()) != -1) {
                        this.out.write(c);
                    }
                }
                finally {
                    this.in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class DelayedOutputStream
    extends OutputStream {
        private final UnboundedBlockingByteQueue stream;

        DelayedOutputStream(UnboundedBlockingByteQueue stream) {
            this.stream = stream;
        }

        @Override
        public void write(int b) throws IOException {
            long t = System.currentTimeMillis() + (long)Throttler.this.latency;
            this.stream.write((byte)(t >>> 56));
            this.stream.write((byte)(t >>> 48));
            this.stream.write((byte)(t >>> 40));
            this.stream.write((byte)(t >>> 32));
            this.stream.write((byte)(t >>> 24));
            this.stream.write((byte)(t >>> 16));
            this.stream.write((byte)(t >>> 8));
            this.stream.write((byte)(t >>> 0));
            this.stream.write((byte)b);
        }

        @Override
        public void close() throws IOException {
            for (int i = 0; i < 8; ++i) {
                this.stream.write((byte)0);
            }
        }
    }

    private static class DelayedInputStream
    extends InputStream {
        private final UnboundedBlockingByteQueue stream;

        DelayedInputStream(UnboundedBlockingByteQueue stream) {
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            try {
                long now;
                long t = ((long)this.stream.read() << 56) + ((long)(this.stream.read() & 0xFF) << 48) + ((long)(this.stream.read() & 0xFF) << 40) + ((long)(this.stream.read() & 0xFF) << 32) + ((long)(this.stream.read() & 0xFF) << 24) + (long)((this.stream.read() & 0xFF) << 16) + (long)((this.stream.read() & 0xFF) << 8) + (long)((this.stream.read() & 0xFF) << 0);
                if (t == 0L) {
                    return -1;
                }
                while ((now = System.currentTimeMillis()) < t) {
                    Thread.sleep(t - now);
                }
                byte b = this.stream.read();
                return (b + 256) % 256;
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            int max = Math.min(len, Math.max(this.available(), 1));
            for (i = 0; i < max; ++i) {
                int c = this.read();
                if (c == -1) {
                    return i - 1;
                }
                b[off + i] = (byte)c;
            }
            return i;
        }

        @Override
        public int available() throws IOException {
            int r = this.stream.available() / 9;
            return r;
        }
    }
}

