/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinci.plugins.mock_slave;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.queue.QueueListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.StreamCopyThread;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.util.Listeners;
import jenkins.util.Timer;
import org.apache.commons.io.FileUtils;
import org.jenkinci.plugins.mock_slave.MockSlave;
import org.jenkinci.plugins.mock_slave.MockSlaveLauncher;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class MockCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(MockCloud.class.getName());
    @DataBoundSetter
    public Node.Mode mode = Node.Mode.NORMAL;
    private int numExecutors = 1;
    private String labelString = "";
    private Boolean oneShot = true;
    private boolean inbound;
    private int maximum;

    @DataBoundConstructor
    public MockCloud(String name) {
        super(name);
    }

    public String getLabels() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setLabels(String labels) {
        this.labelString = Util.fixNull((String)labels);
    }

    public boolean getOneShot() {
        return this.oneShot;
    }

    @DataBoundSetter
    public void setOneShot(boolean oneShot) {
        this.oneShot = oneShot;
    }

    public int getExecutors() {
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setExecutors(int executors) {
        this.numExecutors = executors;
    }

    public boolean isInbound() {
        return this.inbound;
    }

    @DataBoundSetter
    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public int getMaximum() {
        return this.maximum;
    }

    @DataBoundSetter
    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    private Object readResolve() {
        if (this.oneShot == null) {
            this.oneShot = this.numExecutors == 1;
        }
        return this;
    }

    public boolean canProvision(Cloud.CloudState state) {
        Label label = state.getLabel();
        LOGGER.fine(() -> "checking whether " + this.name + " can provision " + String.valueOf(label));
        return label == null ? this.mode == Node.Mode.NORMAL : label.matches((Collection)Label.parse((String)this.labelString));
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Cloud.CloudState state, int excessWorkload) {
        int originalExcessWorkload = excessWorkload;
        LOGGER.fine(() -> "name=" + this.name + " label=" + String.valueOf(state.getLabel()) + " additionalPlannedCapacity=" + state.getAdditionalPlannedCapacity() + " excessWorkload=" + originalExcessWorkload);
        ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
        while (excessWorkload > 0) {
            CompletableFuture<Object> future;
            long curr;
            if (this.maximum > 0 && (curr = Jenkins.get().getNodes().stream().filter(n -> {
                if (!(n instanceof MockCloudSlave)) return false;
                MockCloudSlave mcs = (MockCloudSlave)((Object)n);
                if (!this.name.equals(mcs.cloudName)) return false;
                return true;
            }).count()) >= (long)this.maximum) {
                int more = excessWorkload;
                LOGGER.fine(() -> this.name + " already running " + curr + " agents \u2265" + this.maximum + "; will not provision " + more + " more");
                break;
            }
            long cnt = ((DescriptorImpl)this.getDescriptor()).newNodeNumber();
            try {
                MockCloudSlave agent = new MockCloudSlave(this.name, "mock-agent-" + cnt, this.inbound);
                agent.setNodeDescription("Mock agent #" + cnt);
                agent.setMode(this.mode);
                agent.setNumExecutors(this.numExecutors);
                agent.setLabelString(this.labelString);
                agent.setRetentionStrategy((RetentionStrategy)(this.oneShot != false ? new OnceRetentionStrategy(5) : new CloudRetentionStrategy(1)));
                future = CompletableFuture.completedFuture(agent);
            }
            catch (Descriptor.FormException | IOException x) {
                future = CompletableFuture.failedFuture(x);
            }
            r.add(new NodeProvisioner.PlannedNode("Mock Agent #" + cnt, future, this.numExecutors));
            excessWorkload -= this.numExecutors;
        }
        LOGGER.fine(() -> this.name + " planning to provision " + r.size() + " agents");
        return r;
    }

    @Symbol(value={"mock"})
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        private long counter;

        public DescriptorImpl() {
            this.load();
        }

        synchronized long newNodeNumber() {
            ++this.counter;
            this.save();
            return this.counter;
        }

        @Restricted(value={DoNotUse.class})
        public String nextAgentName() {
            return "mock-agent-" + (this.counter + 1L);
        }

        public String getDisplayName() {
            return "Mock Cloud";
        }

        public FormValidation doCheckOneShot(@QueryParameter int executors, @QueryParameter boolean oneShot) {
            if (oneShot && executors != 1) {
                return FormValidation.error((String)"One-shot mode should only be used when agents have one executor apiece.");
            }
            return FormValidation.ok();
        }
    }

    private static final class MockCloudSlave
    extends AbstractCloudSlave {
        final String cloudName;

        private MockCloudSlave(String cloudName, String slaveName, boolean inbound) throws Descriptor.FormException, IOException {
            super(slaveName, MockSlave.root(slaveName), (ComputerLauncher)(inbound ? new MockInboundLauncher() : new MockSlaveLauncher(0, 0)));
            this.cloudName = cloudName;
        }

        public AbstractCloudComputer<?> createComputer() {
            return new MockCloudComputer(this);
        }

        protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        }

        @Extension
        public static final class DescriptorImpl
        extends Slave.SlaveDescriptor {
            public boolean isInstantiable() {
                return false;
            }
        }
    }

    @Extension(ordinal=100.0)
    public static class NoDelayProvisionerStrategy
    extends NodeProvisioner.Strategy {
        public NodeProvisioner.StrategyDecision apply(NodeProvisioner.StrategyState strategyState) {
            int availableCapacity;
            Label label = strategyState.getLabel();
            LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
            int previousCapacity = availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getPlannedCapacitySnapshot() + strategyState.getAdditionalPlannedCapacity();
            int currentDemand = snapshot.getQueueLength();
            LOGGER.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
            if (availableCapacity < currentDemand) {
                ArrayList jenkinsClouds = new ArrayList(Jenkins.get().clouds);
                Cloud.CloudState cloudState = new Cloud.CloudState(label, strategyState.getAdditionalPlannedCapacity());
                for (Cloud cloud : jenkinsClouds) {
                    int workloadToProvision = currentDemand - availableCapacity;
                    if (!(cloud instanceof MockCloud) || !cloud.canProvision(cloudState) || CloudProvisioningListener.all().stream().anyMatch(cl -> cl.canProvision(cloud, cloudState, workloadToProvision) != null)) continue;
                    Collection plannedNodes = cloud.provision(cloudState, workloadToProvision);
                    LOGGER.fine(() -> cloud.name + " planned " + plannedNodes.size() + " new nodes");
                    Listeners.notify(CloudProvisioningListener.class, (boolean)true, cl -> cl.onStarted(cloud, strategyState.getLabel(), plannedNodes));
                    strategyState.recordPendingLaunches(plannedNodes);
                    int ac = availableCapacity += plannedNodes.size();
                    LOGGER.fine(() -> cloud.name + " after provisioning, available capacity: " + ac + "; current demand: " + currentDemand);
                    if (availableCapacity < currentDemand) continue;
                    break;
                }
            }
            if (availableCapacity > previousCapacity && label != null) {
                LOGGER.fine("Suggesting NodeProvisioner review");
                Timer.get().schedule(() -> ((NodeProvisioner)label.nodeProvisioner).suggestReviewNow(), 1L, TimeUnit.SECONDS);
            }
            if (availableCapacity >= currentDemand) {
                LOGGER.fine("Provisioning completed");
                return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
            }
            LOGGER.fine("Provisioning not complete, consulting remaining strategies");
            return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
        }

        @Extension
        public static class FastProvisioning
        extends QueueListener {
            public void onEnterBuildable(Queue.BuildableItem item) {
                Jenkins jenkins = Jenkins.get();
                Label label = item.getAssignedLabel();
                for (Cloud cloud : jenkins.clouds) {
                    if (!(cloud instanceof MockCloud) || !cloud.canProvision(new Cloud.CloudState(label, 0))) continue;
                    (label == null ? jenkins.unlabeledNodeProvisioner : label.nodeProvisioner).suggestReviewNow();
                }
            }
        }
    }

    private static final class MockCloudComputer
    extends AbstractCloudComputer<MockCloudSlave> {
        MockCloudComputer(MockCloudSlave slave) {
            super((AbstractCloudSlave)slave);
        }
    }

    private static final class MockInboundLauncher
    extends JNLPLauncher {
        private transient Process proc;

        MockInboundLauncher() {
        }

        public boolean isLaunchSupported() {
            return this.proc == null;
        }

        public void launch(SlaveComputer computer, TaskListener listener) {
            LOGGER.fine(() -> "launching agent for " + computer.getName());
            try {
                File agentJar = new File(Jenkins.get().getRootDir(), "agent.jar");
                if (!agentJar.isFile()) {
                    FileUtils.copyURLToFile((URL)new Slave.JnlpJar("agent.jar").getURL(), (File)agentJar);
                }
                this.proc = new ProcessBuilder("java", "-jar", agentJar.getAbsolutePath(), "-url", JenkinsLocationConfiguration.get().getUrl(), "-name", computer.getName(), "-secret", computer.getJnlpMac()).redirectErrorStream(true).start();
                new StreamCopyThread("I/O of " + computer.getName(), this.proc.getInputStream(), (OutputStream)listener.getLogger()).start();
                Instant max = Instant.now().plus(Duration.ofSeconds(15L));
                while (computer.isOffline() && Instant.now().isBefore(max)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception x) {
                Functions.printStackTrace((Throwable)x, (PrintWriter)listener.error("Failed to launch"));
            }
        }

        public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
            LOGGER.fine(() -> "terminating agent for " + computer.getName());
            this.proc.destroy();
        }
    }
}

