/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.rest.model;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ModelObject
implements Serializable {
    private static final int TOSTRING_CUT = "fi.meliora.testlab.ext.rest.model.".length();
    private static final boolean SKIP_LAZY_FIELDS = true;

    protected int toStringCut() {
        return TOSTRING_CUT;
    }

    public String toString(int indent, Set<ModelObject> written) {
        StringBuilder buf = new StringBuilder();
        Class<?> clazz = this.getClass();
        Method[] methods = clazz.getMethods();
        buf.append('\n');
        Iterator list = null;
        for (Method method : methods) {
            Method m = method;
            String name = m.getName();
            if ((!name.startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2)) continue;
            name = name.startsWith("is") ? name.substring(2) : name.substring(3);
            for (int j = 0; j < indent; ++j) {
                buf.append(' ');
            }
            buf.append("<");
            buf.append(name);
            buf.append(">");
            try {
                boolean skip = false;
                try {
                    Field f = clazz.getDeclaredField(Character.toLowerCase(name.charAt(0)) + name.substring(1));
                    for (Annotation a : f.getAnnotations()) {
                        String anno = a.toString();
                        if (!anno.contains("fetch=LAZY")) continue;
                        skip = true;
                        break;
                    }
                }
                catch (NoSuchFieldException f) {
                    // empty catch block
                }
                if (skip) {
                    buf.append("[skipped lazy loaded field]");
                } else {
                    Object o = m.invoke((Object)this, (Object[])null);
                    if (o == this) {
                        buf.append("[super]");
                    } else if (o instanceof ModelObject) {
                        if (written.contains(o)) {
                            buf.append("[parent ");
                            buf.append(name);
                            buf.append("]");
                        } else {
                            buf.append(((ModelObject)o).toString(indent + 4, written));
                            for (int j = 0; j < indent; ++j) {
                                buf.append(' ');
                            }
                        }
                    } else if (o instanceof Collection) {
                        buf.append('\n');
                        for (Object obi : (Collection)o) {
                            int j;
                            if (obi instanceof ModelObject) {
                                ModelObject xe = (ModelObject)obi;
                                for (j = 0; j < indent + 4; ++j) {
                                    buf.append(' ');
                                }
                                buf.append("<");
                                buf.append(xe.getClass().getName().substring(this.toStringCut()));
                                buf.append(">");
                                buf.append(xe.toString(indent + 8, written));
                                for (j = 0; j < indent + 4; ++j) {
                                    buf.append(' ');
                                }
                                buf.append("</");
                                buf.append(xe.getClass().getName().substring(this.toStringCut()));
                                buf.append(">");
                                buf.append('\n');
                                continue;
                            }
                            for (j = 0; j < indent; ++j) {
                                buf.append(' ');
                            }
                            buf.append(obi);
                            buf.append('\n');
                        }
                        for (int j = 0; j < indent; ++j) {
                            buf.append(' ');
                        }
                    } else {
                        buf.append(o);
                    }
                }
            }
            catch (Throwable iae) {
                buf.append("[call to getter failed]");
            }
            buf.append("</");
            buf.append(name);
            buf.append(">\n");
            written.add(this);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("\n<");
        buf.append(this.getClass().getName().substring(this.toStringCut()));
        buf.append(">");
        buf.append(this.toString(4, new HashSet<ModelObject>()));
        buf.append("</");
        buf.append(this.getClass().getName().substring(this.toStringCut()));
        buf.append(">\n");
        return buf.toString();
    }
}

