/*
 * Decompiled with CFR 0.152.
 */
package fi.meliora.testlab.ext.jenkins;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSFilter
implements Filter {
    private static final Logger log = Logger.getLogger(CORSFilter.class.getName());
    private boolean enabled = false;
    private List<String> origins = null;
    private static final String CORS_HANDLE_OPTIONS_METHOD = System.getProperty("cors.options", "true");
    private static final String CORS_METHODS = System.getProperty("cors.methods", "GET, POST, PUT, DELETE");
    private static final String CORS_HEADERS = System.getProperty("cors.headers", "Authorization, .crumb, Origin, Jenkins-Crumb");
    private static final String CORS_CREDENTIALS = System.getProperty("cors.credentials", "true");

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getOrigins() {
        return this.origins;
    }

    public void setOrigins(List<String> origins) {
        this.origins = origins;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled) {
            log.finest("doFilter: CORSFilter enabled for origins " + String.valueOf(this.origins));
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && this.origins != null && this.origins.size() > 0) {
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                String origin = req.getHeader("Origin");
                if (origin != null) {
                    log.finest("doFilter: CORSFilter processing request for Origin: " + origin);
                    if (this.origins.contains("*") || this.origins.contains(origin)) {
                        log.finest("doFilter: CORSFilter adding headers.");
                        resp.addHeader("Access-Control-Allow-Origin", URLEncoder.encode(origin, StandardCharsets.UTF_8.name()));
                        resp.addHeader("Access-Control-Allow-Methods", CORS_METHODS);
                        resp.addHeader("Access-Control-Allow-Headers", CORS_HEADERS);
                        resp.addHeader("Access-Control-Allow-Credentials", CORS_CREDENTIALS);
                        if (Boolean.valueOf(CORS_HANDLE_OPTIONS_METHOD).booleanValue() && "OPTIONS".equals(req.getMethod())) {
                            resp.setStatus(200);
                            return;
                        }
                    }
                }
            }
        } else {
            log.finest("doFilter: CORSFilter disabled.");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.fine("CORSFilter.init()");
    }

    public void destroy() {
        log.fine("CORSFilter.destroy()");
    }
}

