/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.configuration;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ReconfigurableDescribable;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import jenkins.plugins.logstash.Messages;
import jenkins.plugins.logstash.persistence.AbstractLogstashIndexerDao;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public abstract class LogstashIndexer<T extends AbstractLogstashIndexerDao>
extends AbstractDescribableImpl<LogstashIndexer<?>>
implements ExtensionPoint,
ReconfigurableDescribable<LogstashIndexer<?>> {
    protected transient T instance;

    @NonNull
    public synchronized T getInstance() {
        if (this.instance == null) {
            this.instance = this.createIndexerInstance();
        }
        return this.instance;
    }

    public void validate() throws Exception {
    }

    protected abstract T createIndexerInstance();

    public static DescriptorExtensionList<LogstashIndexer<?>, Descriptor<LogstashIndexer<?>>> all() {
        return Jenkins.getInstance().getDescriptorList(LogstashIndexer.class);
    }

    public LogstashIndexer<T> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        req.bindJSON((Object)this, form);
        return this;
    }

    public static abstract class LogstashIndexerDescriptor
    extends Descriptor<LogstashIndexer<?>> {
        public FormValidation doCheckPort(@QueryParameter(value="value") String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.ValueIsInt());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHost(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)Messages.PleaseProvideHost());
            }
            return FormValidation.ok();
        }

        public abstract int getDefaultPort();
    }
}

