/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.FilePath;
import hudson.plugins.logparser.CompiledPatterns;
import hudson.plugins.logparser.LogParserConsts;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class LogParserUtils {
    public static String[] readParsingRules(FilePath parsingRulesFile) throws IOException {
        try {
            return parsingRulesFile.readToString().split("\n");
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public static boolean skipParsingRule(String parsingRule) {
        return parsingRule == null || parsingRule.equals("") || parsingRule.charAt(0) == '#' || parsingRule.startsWith("\\s") || parsingRule.startsWith("\r") || parsingRule.contains("$header");
    }

    public static String standardizeStatus(String status) {
        String result = status;
        if (result.equalsIgnoreCase("ok")) {
            result = "NONE";
        } else if (result.equalsIgnoreCase("end")) {
            result = "INFO";
        } else if (result.equalsIgnoreCase("warn") || result.equalsIgnoreCase("end")) {
            result = "WARNING";
        } else if (LogParserConsts.LEGAL_STATUS.contains(result.toUpperCase(Locale.ENGLISH))) {
            result = result.toUpperCase(Locale.ENGLISH);
        }
        return result;
    }

    public static CompiledPatterns compilePatterns(String[] parsingRulesArray, Logger logger) {
        Pattern[] result = new Pattern[parsingRulesArray.length];
        StringBuffer badParsingRules = new StringBuffer();
        ArrayList<String> extraTags = new ArrayList<String>();
        for (int i = 0; i < parsingRulesArray.length; ++i) {
            String parsingRule = parsingRulesArray[i];
            result[i] = null;
            if (LogParserUtils.skipParsingRule(parsingRule)) continue;
            try {
                Pattern p;
                String[] ruleParts = parsingRule.split("\\s");
                String regexp = ruleParts[1];
                String tag = ruleParts[0];
                if (!LogParserConsts.LEGAL_STATUS.contains(tag.toUpperCase(Locale.ENGLISH)) && !Arrays.asList("OK", "END", "WARN").contains(tag.toUpperCase(Locale.ENGLISH))) {
                    extraTags.add(tag);
                }
                int firstDash = parsingRule.indexOf(47);
                int lastDash = parsingRule.lastIndexOf(47);
                if (firstDash == -1 || lastDash == -1) continue;
                regexp = parsingRule.substring(firstDash + 1, lastDash);
                result[i] = p = Pattern.compile(regexp);
                continue;
            }
            catch (Exception e) {
                String errorMsg = "Bad parsing rule:" + parsingRule + ", Error:" + e.getMessage();
                logger.log(Level.SEVERE, errorMsg);
                badParsingRules.append('\n');
                badParsingRules.append(errorMsg);
            }
        }
        CompiledPatterns fullResult = new CompiledPatterns();
        fullResult.setCompiledPatters(result);
        fullResult.setError(badParsingRules.toString());
        fullResult.setExtraTags(extraTags);
        return fullResult;
    }

    public static String getSectionCountKey(String status, int sectionNumber) {
        return sectionNumber + "-" + status;
    }

    public static int getNumThreads() {
        int result = 2;
        String maxThreadsByEnvStr = System.getenv("HUDSON_LOG_PARSER_THREADS");
        if (maxThreadsByEnvStr != null) {
            try {
                result = Integer.parseInt(maxThreadsByEnvStr);
            }
            catch (Exception e) {
                Logger.getLogger("getNumThreads").log(Level.FINEST, "HUDSON_LOG_PARSER_THREADS is not an integer - using default");
            }
        }
        return result;
    }

    public static int getLinesPerThread() {
        int result = 10000;
        String linesByEnvStr = System.getenv("HUDSON_LOG_PARSER_LINES_PER_THREAD");
        if (linesByEnvStr != null) {
            try {
                result = Integer.parseInt(linesByEnvStr);
            }
            catch (Exception e) {
                Logger.getLogger("getLinesPerThread").log(Level.FINEST, "HUDSON_LOG_PARSER_LINES_PER_THREAD is not an integer - using default");
            }
        }
        return result;
    }

    public static int countLines(String filename) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new FileReader(filename));){
            int count = 0;
            while (reader.readLine() != null) {
                ++count;
            }
            int n = count = reader.getLineNumber();
            return n;
        }
    }

    private LogParserUtils() {
    }
}

