/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserParser;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.ParserRuleFile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class LogParserPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    static final String NULL_PARSING_RULES = "Path to global parsing rules is null";
    private static final long serialVersionUID = 1L;
    public boolean unstableOnWarning;
    public boolean failBuildOnError;
    public boolean showGraphs;
    public String parsingRulesPath = null;
    public boolean useProjectRule;
    public String projectRulePath = null;

    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    private LogParserPublisher(boolean unstableOnWarning, boolean failBuildOnError, boolean showGraphs, String parsingRulesPath, boolean useProjectRule, String projectRulePath) {
        this.unstableOnWarning = unstableOnWarning;
        this.failBuildOnError = failBuildOnError;
        this.showGraphs = showGraphs;
        this.parsingRulesPath = parsingRulesPath;
        this.useProjectRule = useProjectRule;
        this.projectRulePath = projectRulePath;
    }

    @DataBoundConstructor
    public LogParserPublisher(boolean useProjectRule, String projectRulePath, String parsingRulesPath) {
        if (useProjectRule) {
            this.projectRulePath = Util.fixEmpty((String)projectRulePath);
            this.parsingRulesPath = null;
        } else {
            this.parsingRulesPath = Util.fixEmpty((String)parsingRulesPath);
            this.projectRulePath = null;
        }
        this.useProjectRule = useProjectRule;
    }

    @DataBoundSetter
    public void setUnstableOnWarning(boolean unstableOnWarning) {
        this.unstableOnWarning = unstableOnWarning;
    }

    @DataBoundSetter
    public void setFailBuildOnError(boolean failBuildOnError) {
        this.failBuildOnError = failBuildOnError;
    }

    @DataBoundSetter
    public void setShowGraphs(boolean showGraphs) {
        this.showGraphs = showGraphs;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        LogParserResult result = new LogParserResult();
        try {
            FilePath parsingRulesFile;
            boolean preformattedHtml;
            boolean bl = preformattedHtml = !((DescriptorImpl)this.getDescriptor()).getLegacyFormatting();
            if (this.useProjectRule) {
                parsingRulesFile = new FilePath(workspace, this.projectRulePath);
            } else {
                if (this.parsingRulesPath == null) {
                    logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + String.valueOf(build), NULL_PARSING_RULES);
                    result.setFailedToParseError(NULL_PARSING_RULES);
                    build.setResult(Result.ABORTED);
                    build.addAction((Action)new LogParserAction(build, result, this.showGraphs));
                    return;
                }
                parsingRulesFile = new FilePath(new File(this.parsingRulesPath));
            }
            LogParserParser parser = new LogParserParser(parsingRulesFile, preformattedHtml, launcher.getChannel());
            result = parser.parseLog(build);
            if (this.failBuildOnError && result.getTotalErrors() > 0) {
                build.setResult(Result.FAILURE);
            } else if (this.unstableOnWarning && result.getTotalWarnings() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + String.valueOf(build), e);
            result.setFailedToParseError(e.toString());
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + String.valueOf(build), e);
            result.setFailedToParseError(e.toString());
            build.setResult(Result.ABORTED);
        }
        LogParserAction action = new LogParserAction(build, result, this.showGraphs);
        build.addAction((Action)action);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return (BuildStepDescriptor)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<ParserRuleFile> getParserRuleChoices() {
        return ((DescriptorImpl)this.getDescriptor()).getParsingRulesGlobal();
    }

    @Extension
    @Symbol(value={"logParser"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<ParserRuleFile> parsingRulesGlobal = new ArrayList<ParserRuleFile>();
        private boolean useLegacyFormatting = false;

        public DescriptorImpl() {
            super(LogParserPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Console output (build log) parsing";
        }

        public String getHelpFile() {
            return "/plugin/log-parser/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<ParserRuleFile> getParsingRulesGlobal() {
            return this.parsingRulesGlobal;
        }

        @DataBoundSetter
        public void setParsingRulesGlobal(List<ParserRuleFile> parsingRulesChoices) {
            this.parsingRulesGlobal = parsingRulesChoices;
        }

        public boolean getLegacyFormatting() {
            return this.useLegacyFormatting;
        }

        @DataBoundSetter
        public void setLegacyFormatting(boolean useLegacyFormatting) {
            this.useLegacyFormatting = useLegacyFormatting;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.useLegacyFormatting = false;
            this.parsingRulesGlobal = new ArrayList<ParserRuleFile>();
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public ListBoxModel doFillParsingRulesPathItems() {
            ListBoxModel items = new ListBoxModel();
            for (ParserRuleFile file : this.parsingRulesGlobal) {
                items.add(file.getName(), file.getPath());
            }
            return items;
        }
    }
}

