/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.LogParserConsts;
import hudson.plugins.logparser.LogParserDisplayConsts;
import hudson.plugins.logparser.LogParserUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jenkins.model.Jenkins;

public final class LogParserWriter {
    public static void writeHeaderTemplateToAllLinkFiles(HashMap<String, BufferedWriter> writers, int sectionCounter) throws IOException {
        List<String> statuses = LogParserConsts.STATUSES_WITH_SECTIONS_IN_LINK_FILES;
        for (String status : statuses) {
            BufferedWriter linkWriter = writers.get(status);
            String str = "HEADER HERE: #" + sectionCounter;
            linkWriter.write(str + "\n");
        }
    }

    public static void writeWrapperHtml(String buildWrapperPath) throws IOException {
        String wrapperHtml = "<frameset cols=\"270,*\">\n<frame src=\"log_ref.html\" scrolling=auto name=\"sidebar\">\n<frame src=\"log_content.html\" scrolling=auto name=\"content\">\n<noframes>\n<p>Viewing the build report requires a Frames-enabled browser</p>\n<a href='build.log'>build log</a>\n</noframes>\n</frameset>\n";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(buildWrapperPath));){
            writer.write("<frameset cols=\"270,*\">\n<frame src=\"log_ref.html\" scrolling=auto name=\"sidebar\">\n<frame src=\"log_content.html\" scrolling=auto name=\"content\">\n<noframes>\n<p>Viewing the build report requires a Frames-enabled browser</p>\n<a href='build.log'>build log</a>\n</noframes>\n</frameset>\n");
        }
    }

    public static void writeReferenceHtml(String buildRefPath, ArrayList<String> headerForSection, HashMap<String, Integer> statusCountPerSection, HashMap<String, String> iconTable, HashMap<String, String> linkListDisplay, HashMap<String, String> linkListDisplayPlural, HashMap<String, Integer> statusCount, HashMap<String, String> linkFiles, List<String> extraTags) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(buildRefPath));){
            writer.write(LogParserConsts.getHtmlOpeningTags());
            LogParserWriter.writeLinks(writer, "ERROR", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
            LogParserWriter.writeLinks(writer, "WARNING", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
            LogParserWriter.writeLinks(writer, "INFO", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
            LogParserWriter.writeLinks(writer, "DEBUG", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
            for (String extraTag : extraTags) {
                LogParserWriter.writeLinks(writer, extraTag, headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
            }
            writer.write(LogParserConsts.getHtmlClosingTags());
        }
    }

    private static void writeLinks(BufferedWriter writer, String status, ArrayList<String> headerForSection, HashMap<String, Integer> statusCountPerSection, HashMap<String, String> iconTable, HashMap<String, String> linkListDisplay, HashMap<String, String> linkListDisplayPlural, HashMap<String, Integer> statusCount, HashMap<String, String> linkFiles) throws IOException {
        String linkListDisplayStrPlural;
        String linkListDisplayStr;
        String statusIcon = iconTable.get(status);
        if (statusIcon == null) {
            statusIcon = "blue.gif";
        }
        if ((linkListDisplayStr = linkListDisplay.get(status)) == null) {
            linkListDisplayStr = LogParserDisplayConsts.getDefaultLinkListDisplay(status);
        }
        if ((linkListDisplayStrPlural = linkListDisplayPlural.get(status)) == null) {
            linkListDisplayStrPlural = LogParserDisplayConsts.getDefaultLinkListDisplayPlural(status);
        }
        String linkListCount = statusCount.get(status).toString();
        String hudsonRoot = Jenkins.get().getRootUrl();
        String iconLocation = String.format("%s/plugin/log-parser/images/", Jenkins.RESOURCE_PATH).substring(1);
        String styles = "<style>\n    ul {margin-left: 0; padding-left: 1em;}\n    ul li {font-size: small; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; margin-top: .5em; }\n    ul li:hover {white-space: normal;}\n    ul li a:link {text-decoration: none;}\n    ul li:hover a:link {text-decoration: underline;}\n</style>\n";
        writer.write("<style>\n    ul {margin-left: 0; padding-left: 1em;}\n    ul li {font-size: small; white-space: nowrap; text-overflow: ellipsis; overflow: hidden; margin-top: .5em; }\n    ul li:hover {white-space: normal;}\n    ul li a:link {text-decoration: none;}\n    ul li:hover a:link {text-decoration: underline;}\n</style>\n");
        String linksStart = "<img src=\"" + hudsonRoot + iconLocation + statusIcon + "\" style=\"margin: 2px;\" width=\"24\" alt=\"" + linkListDisplayStr + " Icon\" height=\"24\" />\n<a class=\"lpp-toggle-list\" href=\"#\" data-display-category=\"" + linkListDisplayStr + "\"><STRONG>" + linkListDisplayStr + " (" + linkListCount + ")</STRONG></a><br />\n<ul style=\"display: none;\" id=\"" + linkListDisplayStr + "\" >\n";
        writer.write(linksStart);
        try (BufferedReader reader = new BufferedReader(new FileReader(linkFiles.get(status)));){
            String line;
            String summaryLine = "<br/>(SUMMARY_INT_HERE LINK_LIST_DISPLAY_STR in this section)<br/>";
            String headerTemplateRegexp = "HEADER HERE:";
            String headerTemplateSplitBy = "#";
            while ((line = reader.readLine()) != null) {
                String curSummaryLine = null;
                if (line.startsWith("HEADER HERE:")) {
                    int headerNum = Integer.parseInt(line.split("#")[1]);
                    line = headerForSection.get(headerNum);
                    String key = LogParserUtils.getSectionCountKey(status, headerNum);
                    Integer summaryInt = statusCountPerSection.get(key);
                    if (summaryInt == null || summaryInt == 0) {
                        line = null;
                    } else {
                        String linkListDisplayStrWithPlural = linkListDisplayStr;
                        if (summaryInt > 1) {
                            linkListDisplayStrWithPlural = linkListDisplayStrPlural;
                        }
                        curSummaryLine = "<br/>(SUMMARY_INT_HERE LINK_LIST_DISPLAY_STR in this section)<br/>".replace("SUMMARY_INT_HERE", summaryInt.toString()).replace("LINK_LIST_DISPLAY_STR", linkListDisplayStrWithPlural);
                    }
                }
                if (line != null) {
                    writer.write(line);
                    writer.newLine();
                }
                if (curSummaryLine == null) continue;
                writer.write(curSummaryLine);
                writer.newLine();
            }
        }
        String linksEnd = "</ul>\n";
        writer.write("</ul>\n");
    }

    private LogParserWriter() {
    }
}

