/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.FilePath;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.logparser.CompiledPatterns;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserConsts;
import hudson.plugins.logparser.LogParserDisplayConsts;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.LogParserStatusComputer;
import hudson.plugins.logparser.LogParserUtils;
import hudson.plugins.logparser.LogParserWriter;
import hudson.plugins.timestamper.api.TimestamperAPI;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LogParserParser {
    private final HashMap<String, Integer> statusCount = new HashMap();
    private final HashMap<String, BufferedWriter> writers = new HashMap();
    private final HashMap<String, String> linkFiles = new HashMap();
    private final String[] parsingRulesArray;
    private final Pattern[] compiledPatterns;
    private final CompiledPatterns compiledPatternsPlusError;
    private final List<String> extraTags;
    private final HashMap<String, Integer> statusCountPerSection = new HashMap();
    private final ArrayList<String> headerForSection = new ArrayList();
    private int sectionCounter = 0;
    private final LogParserDisplayConsts displayConstants = new LogParserDisplayConsts();
    private final VirtualChannel channel;
    private final boolean preformattedHtml;

    public LogParserParser(FilePath parsingRulesFile, boolean preformattedHtml, VirtualChannel channel) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        this.parsingRulesArray = LogParserUtils.readParsingRules(parsingRulesFile);
        this.compiledPatternsPlusError = LogParserUtils.compilePatterns(this.parsingRulesArray, logger);
        this.compiledPatterns = this.compiledPatternsPlusError.getCompiledPatterns();
        this.extraTags = this.compiledPatternsPlusError.getExtraTags();
        this.preformattedHtml = preformattedHtml;
        this.channel = channel;
        this.statusCount.put("ERROR", 0);
        this.statusCount.put("WARNING", 0);
        this.statusCount.put("INFO", 0);
        this.statusCount.put("DEBUG", 0);
        for (String extraTag : this.extraTags) {
            this.statusCount.put(extraTag, 0);
        }
    }

    @Deprecated
    public LogParserResult parseLog(AbstractBuild<?, ?> build) throws IOException, InterruptedException {
        return this.parseLog((Run<?, ?>)build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogParserResult parseLog(Run<?, ?> build) throws IOException, InterruptedException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        InputStream log = build.getLogInputStream();
        String logDirectory = build.getRootDir().getAbsolutePath();
        String parsedFilePath = logDirectory + "/log_content.html";
        String errorLinksFilePath = logDirectory + "/logerrorLinks.html";
        String warningLinksFilePath = logDirectory + "/logwarningLinks.html";
        String infoLinksFilePath = logDirectory + "/loginfoLinks.html";
        String debugLinksFilePath = logDirectory + "/logdebugLinks.html";
        HashMap<String, CallSite> linksFilePathByExtraTags = new HashMap<String, CallSite>();
        for (String extraTag : this.extraTags) {
            linksFilePathByExtraTags.put(extraTag, (CallSite)((Object)(logDirectory + "/log" + extraTag + "Links.html")));
        }
        String buildRefPath = logDirectory + "/log_ref.html";
        String buildWrapperPath = logDirectory + "/log.html";
        this.linkFiles.put("ERROR", errorLinksFilePath);
        this.linkFiles.put("WARNING", warningLinksFilePath);
        this.linkFiles.put("INFO", infoLinksFilePath);
        this.linkFiles.put("DEBUG", debugLinksFilePath);
        for (String string : this.extraTags) {
            this.linkFiles.put(string, (String)linksFilePathByExtraTags.get(string));
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(parsedFilePath));){
            this.writers.put("ERROR", new BufferedWriter(new FileWriter(errorLinksFilePath)));
            this.writers.put("WARNING", new BufferedWriter(new FileWriter(warningLinksFilePath)));
            this.writers.put("INFO", new BufferedWriter(new FileWriter(infoLinksFilePath)));
            this.writers.put("DEBUG", new BufferedWriter(new FileWriter(debugLinksFilePath)));
            for (String extraTag : this.extraTags) {
                this.writers.put(extraTag, new BufferedWriter(new FileWriter((String)linksFilePathByExtraTags.get(extraTag))));
            }
            String string = " <a target=\"content\" href=\"log_content.html\">Beginning of log</a>";
            LogParserWriter.writeHeaderTemplateToAllLinkFiles(this.writers, this.sectionCounter);
            this.headerForSection.add(" <a target=\"content\" href=\"log_content.html\">Beginning of log</a>");
            writer.write(LogParserConsts.getHtmlOpeningTags());
            String styles = "<style>\n  body {margin-left:.5em; }\n  pre {font-family: Consolas, \"Courier New\"; word-wrap: break-word; }\n  pre span {word-wrap: break-word; } \n</style>\n";
            writer.write("<style>\n  body {margin-left:.5em; }\n  pre {font-family: Consolas, \"Courier New\"; word-wrap: break-word; }\n  pre span {word-wrap: break-word; } \n</style>\n");
            if (this.preformattedHtml) {
                writer.write("<pre>");
            }
            this.parseLogBody(build, writer, log, logger);
            if (this.preformattedHtml) {
                writer.write("</pre>");
            }
            writer.write(LogParserConsts.getHtmlClosingTags());
        }
        catch (Throwable throwable) {
            for (BufferedWriter writer2 : this.writers.values()) {
                writer2.close();
            }
            throw throwable;
        }
        for (BufferedWriter bufferedWriter : this.writers.values()) {
            bufferedWriter.close();
        }
        LogParserWriter.writeReferenceHtml(buildRefPath, this.headerForSection, this.statusCountPerSection, this.displayConstants.getIconTable(), this.displayConstants.getLinkListDisplay(), this.displayConstants.getLinkListDisplayPlural(), this.statusCount, this.linkFiles, this.extraTags);
        LogParserWriter.writeWrapperHtml(buildWrapperPath);
        String buildUrlPath = build.getUrl();
        String string = LogParserAction.getUrlNameStat();
        String parsedLogURL = buildUrlPath + string + "/log.html";
        LogParserResult result = new LogParserResult();
        result.setHtmlLogFile(parsedFilePath);
        result.setTotalErrors(this.statusCount.get("ERROR"));
        result.setTotalWarnings(this.statusCount.get("WARNING"));
        result.setTotalInfos(this.statusCount.get("INFO"));
        result.setTotalDebugs(this.statusCount.get("DEBUG"));
        for (String extraTag : this.extraTags) {
            result.putTotalCountsByExtraTag(extraTag, this.statusCount.get(extraTag));
        }
        result.setErrorLinksFile(errorLinksFilePath);
        result.setWarningLinksFile(warningLinksFilePath);
        result.setInfoLinksFile(infoLinksFilePath);
        result.setDebugLinksFile(debugLinksFilePath);
        for (String extraTag : this.extraTags) {
            result.putLinksFileByExtraTag(extraTag, (String)linksFilePathByExtraTags.get(extraTag));
        }
        result.setParsedLogURL(parsedLogURL);
        result.setHtmlLogPath(logDirectory);
        result.setBadParsingRulesError(this.compiledPatternsPlusError.getError());
        result.setExtraTags(this.extraTags);
        return result;
    }

    public String parseLine(String line) throws IOException {
        return this.parseLine(line, null);
    }

    public static String convertEscapeSequencesToHtml(String text) {
        return text.replaceAll("\u001b\\[(\\d{1,2})(;\\d{1,2})?(;\\d{1,2})?m", "");
    }

    public String parseLine(String line, String status) throws IOException {
        String parsedLine = line;
        String effectiveStatus = status;
        if (status == null) {
            effectiveStatus = "NONE";
        } else if (status.equals("START")) {
            effectiveStatus = "INFO";
        }
        parsedLine = ConsoleNote.removeNotes((String)parsedLine);
        parsedLine = parsedLine.replaceAll("<", "&lt;");
        parsedLine = parsedLine.replaceAll(">", "&gt;");
        parsedLine = LogParserParser.convertEscapeSequencesToHtml(parsedLine);
        if (effectiveStatus != null && !effectiveStatus.equals("NONE")) {
            String parsedLineColoredAndMarked;
            this.incrementCounter(effectiveStatus);
            this.incrementCounterPerSection(effectiveStatus, this.sectionCounter);
            String parsedLineColored = this.colorLine(parsedLine, effectiveStatus);
            parsedLine = parsedLineColoredAndMarked = this.addMarkerAndLink(parsedLineColored, effectiveStatus, status);
        }
        StringBuffer result = new StringBuffer(parsedLine);
        if (!this.preformattedHtml) {
            result.append("<br/>\n");
        }
        return result.toString();
    }

    public void incrementCounter(String status) {
        int currentVal = this.statusCount.get(status);
        this.statusCount.put(status, currentVal + 1);
    }

    public void incrementCounterPerSection(String status, int sectionNumber) {
        String key = LogParserUtils.getSectionCountKey(status, sectionNumber);
        Integer currentValInteger = this.statusCountPerSection.get(key);
        if (currentValInteger == null) {
            currentValInteger = 0;
        }
        int newVal = currentValInteger + 1;
        this.statusCountPerSection.put(key, newVal);
    }

    private String colorLine(String line, String status) {
        String color = this.displayConstants.getColorTable().get(status);
        if (color == null) {
            color = "blue";
        }
        StringBuffer result = new StringBuffer("<span class=\"");
        result.append(status.toLowerCase());
        result.append("\" style=\"color: ");
        result.append(color);
        result.append("\">");
        result.append(line);
        result.append("</span>");
        return result.toString();
    }

    private String addMarkerAndLink(String line, String effectiveStatus, String status) throws IOException {
        String statusCountStr = this.statusCount.get(effectiveStatus).toString();
        String marker = effectiveStatus + statusCountStr;
        StringBuffer shortLink = new StringBuffer(" <a target=\"content\" href=\"log_content.html#");
        shortLink.append(marker);
        shortLink.append("\">");
        shortLink.append(line);
        shortLink.append("</a>");
        StringBuffer link = new StringBuffer("<li>");
        link.append(statusCountStr);
        link.append(shortLink);
        link.append("</li>");
        BufferedWriter linkWriter = this.writers.get(effectiveStatus);
        linkWriter.write(link.toString());
        linkWriter.newLine();
        StringBuffer markedLine = new StringBuffer("<p><a name=\"");
        markedLine.append(marker);
        markedLine.append("\"></a></p>");
        markedLine.append(line);
        if (status.equals("START")) {
            ++this.sectionCounter;
            LogParserWriter.writeHeaderTemplateToAllLinkFiles(this.writers, this.sectionCounter);
            StringBuffer brShortLink = new StringBuffer("<br/>");
            brShortLink.append(shortLink);
            this.headerForSection.add(brShortLink.toString());
        }
        return markedLine.toString();
    }

    private void parseLogBody(Run<?, ?> build, BufferedWriter writer, InputStream log, Logger logger) throws IOException, InterruptedException {
        String signature = build.getParent().getName() + "_build_" + build.getNumber();
        logger.log(Level.INFO, "LogParserParser: Start parsing : " + signature);
        Calendar calendarStart = Calendar.getInstance();
        Charset charset = build.getCharset();
        HashMap lineStatusMatches = (HashMap)this.channel.call((Callable)new LogParserStatusComputer(log, this.parsingRulesArray, this.compiledPatterns, signature, charset));
        String query = "time=yyyy-MM-dd HH:MM:ss.SSS&appendLog";
        try (BufferedReader reader = TimestamperAPI.get().read(build, query);){
            String line;
            int line_num = 0;
            while ((line = reader.readLine()) != null) {
                String status = (String)lineStatusMatches.get(String.valueOf(line_num));
                String parsedLine = this.parseLine(line, status);
                writer.write(parsedLine);
                writer.newLine();
                ++line_num;
            }
        }
        Calendar calendarEnd = Calendar.getInstance();
        long diffSeconds = (calendarEnd.getTimeInMillis() - calendarStart.getTimeInMillis()) / 1000L;
        long diffMinutes = diffSeconds / 60L;
        logger.log(Level.INFO, "LogParserParser: Parsing took " + diffMinutes + " minutes (" + diffSeconds + ") seconds.");
    }
}

