/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.ParsingInput;
import hudson.plugins.logparser.ParsingStrategy;
import hudson.plugins.logparser.ParsingStrategyLocator;
import hudson.remoting.RemoteInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.regex.Pattern;
import jenkins.security.MasterToSlaveCallable;

public class LogParserStatusComputer
extends MasterToSlaveCallable<HashMap<String, String>, RuntimeException> {
    private static final long serialVersionUID = 646211554890510833L;
    private final String[] parsingRulesArray;
    private final Pattern[] compiledPatterns;
    private final InputStream remoteLog;
    private final String signature;
    private final String charsetName;

    public LogParserStatusComputer(InputStream log, String[] parsingRulesArray, Pattern[] compiledPatterns, String signature, Charset charset) {
        this.parsingRulesArray = parsingRulesArray;
        this.compiledPatterns = compiledPatterns;
        this.remoteLog = new RemoteInputStream(log, RemoteInputStream.Flag.GREEDY);
        this.signature = signature;
        this.charsetName = charset.name();
    }

    @Deprecated
    public LogParserStatusComputer(InputStream log, String[] parsingRulesArray, Pattern[] compiledPatterns, String signature) throws IOException, InterruptedException {
        this(log, parsingRulesArray, compiledPatterns, signature, Charset.defaultCharset());
    }

    public HashMap<String, String> call() {
        try {
            return this.computeStatusMatches(this.remoteLog, this.signature, this.charsetName);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<String, String> computeStatusMatches(InputStream log, String signature, String charsetName) throws IOException, InterruptedException {
        ParsingStrategyLocator locator = ParsingStrategyLocator.create();
        ParsingStrategy strategy = locator.get();
        ParsingInput input = new ParsingInput(this.parsingRulesArray, this.compiledPatterns, log, signature, charsetName);
        return strategy.parse(input);
    }
}

