/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.LocalChannel;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import jenkins.plugins.itemstorage.GlobalItemStorage;
import jenkins.plugins.itemstorage.ObjectPath;
import jenkins.plugins.jobcacher.Cache;
import jenkins.plugins.jobcacher.CacheDescriptor;
import jenkins.plugins.jobcacher.CacheManager;
import jenkins.plugins.jobcacher.Messages;
import jenkins.plugins.jobcacher.arbitrary.ArbitraryFileCacheStrategy;
import jenkins.plugins.jobcacher.arbitrary.SimpleArbitraryFileCacheStrategy;
import jenkins.plugins.jobcacher.arbitrary.TarArbitraryFileCacheStrategy;
import jenkins.plugins.jobcacher.arbitrary.WorkspaceHelper;
import jenkins.plugins.jobcacher.arbitrary.ZipArbitraryFileCacheStrategy;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class ArbitraryFileCache
extends Cache {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_VALIDITY_DECIDING_FILE_HASH_FILE_EXTENSION = ".hash";
    private static final String CACHE_VALIDITY_DECIDING_FILE_DIGEST_ALGORITHM = "MD5";
    private static final String CACHE_FILENAME_PART_SEP = "-";
    private String path;
    private String includes;
    private String excludes;
    private boolean useDefaultExcludes = true;
    private String cacheValidityDecidingFile;
    private CompressionMethod compressionMethod = CompressionMethod.TARGZ;
    private String cacheName;

    @DataBoundConstructor
    public ArbitraryFileCache(String path, String includes, String excludes) {
        this.path = path;
        this.includes = StringUtils.isNotBlank((CharSequence)includes) ? includes : "**/*";
        this.excludes = excludes;
    }

    @DataBoundSetter
    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public boolean getUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    @DataBoundSetter
    public void setCompressionMethod(CompressionMethod compressionMethod) {
        if (compressionMethod == CompressionMethod.NONE) {
            compressionMethod = CompressionMethod.TARGZ;
        }
        this.compressionMethod = compressionMethod;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    @DataBoundSetter
    public void setCacheValidityDecidingFile(String cacheValidityDecidingFile) {
        this.cacheValidityDecidingFile = cacheValidityDecidingFile;
    }

    public String getCacheValidityDecidingFile() {
        return this.cacheValidityDecidingFile;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @DataBoundSetter
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    private String getSkipCacheTriggerFileHashFileName() {
        return this.createCacheBaseName() + CACHE_VALIDITY_DECIDING_FILE_HASH_FILE_EXTENSION;
    }

    public String createCacheBaseName() {
        String generatedCacheName = ArbitraryFileCache.deriveCachePath(this.path);
        if (StringUtils.isEmpty((CharSequence)this.cacheName)) {
            return generatedCacheName;
        }
        return generatedCacheName + CACHE_FILENAME_PART_SEP + this.cacheName;
    }

    @Override
    public String getTitle() {
        return Messages.ArbitraryFileCache_displayName();
    }

    @Override
    public Cache.Saver cache(ObjectPath cachesRoot, ObjectPath fallbackCachesRoot, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment, boolean skipRestore) throws IOException, InterruptedException {
        String expandedPath = initialEnvironment.expand(this.path);
        FilePath resolvedPath = workspace.child(expandedPath);
        ExistingCache existingCache = this.resolveExistingValidCache(cachesRoot, fallbackCachesRoot, workspace, listener);
        if (existingCache == null) {
            this.logMessage("Skip restoring cache as no up-to-date cache exists", listener);
            return new SaverImpl(expandedPath);
        }
        if (skipRestore) {
            this.logMessage("Skip restoring cache due skipRestore parameter", listener);
        } else {
            this.logMessage("Restoring cache...", listener);
            long cacheRestorationStartTime = System.nanoTime();
            try {
                existingCache.restore(resolvedPath, workspace);
                long cacheRestorationEndTime = System.nanoTime();
                this.logMessage("Cache restored in " + Duration.ofNanos(cacheRestorationEndTime - cacheRestorationStartTime).toMillis() + "ms", listener);
            }
            catch (Exception e) {
                this.logMessage("Failed to restore cache, cleaning up " + this.path + "...", e, listener);
                resolvedPath.deleteRecursive();
            }
        }
        return new SaverImpl(expandedPath);
    }

    private ExistingCache resolveExistingValidCache(ObjectPath cachesRoot, ObjectPath fallbackCachesRoot, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        this.logMessage("Searching cache in job specific caches...", listener);
        ExistingCache cache = this.resolveExistingValidCache(cachesRoot, workspace, listener);
        if (cache != null) {
            this.logMessage("Found cache in job specific caches", listener);
            return cache;
        }
        this.logMessage("Searching cache in default caches...", listener);
        cache = this.resolveExistingValidCache(fallbackCachesRoot, workspace, listener);
        if (cache != null) {
            this.logMessage("Found cache in default caches", listener);
            return cache;
        }
        return null;
    }

    private ExistingCache resolveExistingValidCache(ObjectPath cachesRoot, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ExistingCache existingCache = this.resolveExistingCache(cachesRoot);
        if (existingCache == null || !existingCache.getCompressionMethod().isSupported()) {
            return null;
        }
        if (!this.isCacheValidityDecidingFileConfigured()) {
            return existingCache;
        }
        if (!this.isOneCacheValidityDecidingFilePresent(workspace)) {
            this.logMessage("cacheValidityDecidingFile configured, but file(s) not present in workspace - considering cache anyway", listener);
            return existingCache;
        }
        return this.isCacheOutdated(cachesRoot, workspace, listener) ? null : existingCache;
    }

    private ExistingCache resolveExistingCache(ObjectPath cachesRoot) throws IOException, InterruptedException {
        if (cachesRoot == null) {
            return null;
        }
        for (CompressionMethod compressionMethod : CompressionMethod.values()) {
            ObjectPath cache = this.resolveCachePathForCompressionMethod(cachesRoot, compressionMethod);
            if (!cache.exists()) continue;
            return new ExistingCache(cache, compressionMethod);
        }
        return null;
    }

    private ObjectPath resolveCachePathForCompressionMethod(ObjectPath cachesRoot, CompressionMethod compressionMethod) throws IOException, InterruptedException {
        return cachesRoot.child(compressionMethod.getCacheStrategy().createCacheName(this.createCacheBaseName()));
    }

    private boolean isCacheOutdated(ObjectPath cachesRoot, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ObjectPath previousClearCacheTriggerFileHash = this.resolvePreviousCacheValidityDecidingFileHashFile(cachesRoot);
        if (!previousClearCacheTriggerFileHash.exists()) {
            this.logMessage("cacheValidityDecidingFile configured, but previous hash not available - cache outdated", listener);
            return true;
        }
        if (!this.matchesCurrentCacheValidityDecidingFileHash(previousClearCacheTriggerFileHash, workspace, listener)) {
            this.logMessage("cacheValidityDecidingFile configured, but previous hash does not match - cache outdated", listener);
            return true;
        }
        return false;
    }

    private boolean isCacheValidityDecidingFileConfigured() {
        return StringUtils.isNotEmpty((CharSequence)this.cacheValidityDecidingFile);
    }

    private ObjectPath resolvePreviousCacheValidityDecidingFileHashFile(ObjectPath cachesRoot) throws IOException, InterruptedException {
        String skipCacheTriggerFileHashFileName = this.createCacheValidityDecidingFileHashFileName(this.createCacheBaseName());
        return cachesRoot.child(skipCacheTriggerFileHashFileName);
    }

    private String createCacheValidityDecidingFileHashFileName(String baseName) {
        return baseName + CACHE_VALIDITY_DECIDING_FILE_HASH_FILE_EXTENSION;
    }

    private boolean matchesCurrentCacheValidityDecidingFileHash(ObjectPath previousCacheValidityDecidingFileHashFile, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        if (!this.isOneCacheValidityDecidingFilePresent(workspace)) {
            return false;
        }
        try (WorkspaceHelper.TempFile tempFile = WorkspaceHelper.createTempFile(workspace, CACHE_VALIDITY_DECIDING_FILE_HASH_FILE_EXTENSION);){
            boolean bl;
            block13: {
                previousCacheValidityDecidingFileHashFile.copyTo(tempFile.get());
                InputStream inputStream = tempFile.get().read();
                try {
                    String previousCacheValidityDecidingFileHash = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    String currentCacheValidityDecidingFileHash = this.getCurrentCacheValidityDecidingFileHash(workspace, listener);
                    bl = StringUtils.equals((CharSequence)previousCacheValidityDecidingFileHash, (CharSequence)currentCacheValidityDecidingFileHash);
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return bl;
        }
    }

    private String getCurrentCacheValidityDecidingFileHash(FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        if (!this.isOneCacheValidityDecidingFilePresent(workspace)) {
            throw new IllegalStateException("path " + this.cacheValidityDecidingFile + " cannot be resolved within the current workspace");
        }
        try {
            FilePath[] cacheValidityDecidingFiles;
            MessageDigest messageDigest = MessageDigest.getInstance(CACHE_VALIDITY_DECIDING_FILE_DIGEST_ALGORITHM);
            for (FilePath cacheValidityDecidingFile : cacheValidityDecidingFiles = this.resolveCacheValidityDecidingFiles(workspace)) {
                try (InputStream inputStream = cacheValidityDecidingFile.read();){
                    DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
                    IOUtils.copy((InputStream)digestInputStream, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                }
            }
            String hash = Util.toHexString((byte[])messageDigest.digest());
            this.logMessage("got hash " + hash + " for cacheValidityDecidingFile(s) - actual file(s): " + this.joinAsRelativePaths(cacheValidityDecidingFiles), listener);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private String joinAsRelativePaths(FilePath[] cacheValidityDecidingFiles) {
        return Arrays.stream(cacheValidityDecidingFiles).map(FilePath::getRemote).collect(Collectors.joining(", "));
    }

    private boolean isOneCacheValidityDecidingFilePresent(FilePath workspace) throws IOException, InterruptedException {
        return this.resolveCacheValidityDecidingFiles(workspace).length > 0;
    }

    private FilePath[] resolveCacheValidityDecidingFiles(FilePath workspace) throws IOException, InterruptedException {
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String decidingFilePattern : this.cacheValidityDecidingFile.split(",")) {
            if (decidingFilePattern.startsWith("!")) {
                excludes.add(decidingFilePattern.substring(1));
                continue;
            }
            includes.add(decidingFilePattern);
        }
        return workspace.list(String.join((CharSequence)",", includes), String.join((CharSequence)",", excludes));
    }

    private void logMessage(String message, Exception exception, TaskListener listener) {
        this.logMessage(message, listener);
        exception.printStackTrace(listener.getLogger());
    }

    private void logMessage(String message, TaskListener listener) {
        Object cacheIdentifier = this.path;
        if (this.getCacheName() != null) {
            cacheIdentifier = (String)cacheIdentifier + " (" + this.getCacheName() + ")";
        }
        listener.getLogger().println("[Cache for " + (String)cacheIdentifier + " with id " + ArbitraryFileCache.deriveCachePath(this.path) + "] " + message);
    }

    public HttpResponse doDynamic(StaplerRequest2 req, StaplerResponse2 rsp, @AncestorInPath Job<?, ?> job) throws IOException, ServletException, InterruptedException {
        ObjectPath cache = CacheManager.getCachePath(GlobalItemStorage.get().getStorage(), job).child(ArbitraryFileCache.deriveCachePath(this.path));
        if (!cache.exists()) {
            req.getView((Object)this, "noCache.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return null;
        }
        return cache.browse(req, rsp, job, this.path);
    }

    public static enum CompressionMethod {
        NONE(new SimpleArbitraryFileCacheStrategy(), false, true),
        ZIP(new ZipArbitraryFileCacheStrategy(), true, true),
        TARGZ(new TarArbitraryFileCacheStrategy(GzipCompressorOutputStream::new, GzipCompressorInputStream::new, ".tgz"), true, false),
        TARGZ_BEST_SPEED(new TarArbitraryFileCacheStrategy(os -> new GzipCompressorOutputStream(os, CompressionMethod.gzipParametersBestSpeed()), GzipCompressorInputStream::new, ".tgz"), true, false),
        TAR(new TarArbitraryFileCacheStrategy(os -> os, is -> is, ".tar"), true, false),
        TAR_ZSTD(new TarArbitraryFileCacheStrategy(out -> {
            ZstdOutputStream outputStream = new ZstdOutputStream(out);
            outputStream.setWorkers(0);
            return outputStream;
        }, ZstdInputStream::new, ".tar.zst"), true, false);

        private final ArbitraryFileCacheStrategy cacheStrategy;
        private final boolean supported;
        private final boolean deprecated;

        private static GzipParameters gzipParametersBestSpeed() {
            GzipParameters gzipParameters = new GzipParameters();
            gzipParameters.setCompressionLevel(1);
            return gzipParameters;
        }

        private CompressionMethod(ArbitraryFileCacheStrategy cacheStrategy, boolean supported, boolean deprecated) {
            this.cacheStrategy = cacheStrategy;
            this.supported = supported;
            this.deprecated = deprecated;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public ArbitraryFileCacheStrategy getCacheStrategy() {
            return this.cacheStrategy;
        }
    }

    private static class ExistingCache {
        private final ObjectPath cache;
        private final CompressionMethod compressionMethod;

        private ExistingCache(ObjectPath cache, CompressionMethod compressionMethod) {
            this.cache = cache;
            this.compressionMethod = compressionMethod;
        }

        public ObjectPath getCache() {
            return this.cache;
        }

        public CompressionMethod getCompressionMethod() {
            return this.compressionMethod;
        }

        public void restore(FilePath target, FilePath workspace) throws IOException, InterruptedException {
            this.compressionMethod.getCacheStrategy().restore(this.cache, target, workspace);
        }
    }

    private class SaverImpl
    extends Cache.Saver {
        private static final long serialVersionUID = 1L;
        private final String expandedPath;

        public SaverImpl(String expandedPath) {
            this.expandedPath = expandedPath;
        }

        @Override
        public long calculateSize(ObjectPath objectPath, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            return (Long)workspace.child(this.expandedPath).act((FilePath.FileCallable)new Cache.DirectorySize(ArbitraryFileCache.this.includes, ArbitraryFileCache.this.excludes));
        }

        @Override
        public void save(ObjectPath cachesRoot, ObjectPath defaultCachesRoot, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            ExistingCache existingCache;
            FilePath resolvedPath = workspace.child(this.expandedPath);
            if (!resolvedPath.exists()) {
                ArbitraryFileCache.this.logMessage("Cannot create cache as the path does not exist", listener);
                if (this.isPathOutsideWorkspace(resolvedPath, workspace) && this.isMaybeInsideDockerContainer(workspace)) {
                    ArbitraryFileCache.this.logMessage("Note that paths outside the workspace while using the Docker Pipeline plugin are not supported", listener);
                }
                return;
            }
            if (ArbitraryFileCache.this.isCacheValidityDecidingFileConfigured()) {
                ExistingCache existingValidCache = ArbitraryFileCache.this.resolveExistingValidCache(defaultCachesRoot, workspace, listener);
                if (existingValidCache != null) {
                    ArbitraryFileCache.this.logMessage("Skip cache creation as the default cache is still valid", listener);
                    return;
                }
                existingValidCache = ArbitraryFileCache.this.resolveExistingValidCache(cachesRoot, workspace, listener);
                if (existingValidCache != null) {
                    ArbitraryFileCache.this.logMessage("Skip cache creation as the cache is up-to-date", listener);
                    return;
                }
            }
            if ((existingCache = ArbitraryFileCache.this.resolveExistingCache(cachesRoot)) != null && existingCache.getCompressionMethod() != ArbitraryFileCache.this.compressionMethod) {
                ArbitraryFileCache.this.logMessage("Delete existing cache as the compression method has been changed", listener);
                existingCache.getCache().deleteRecursive();
            }
            ObjectPath cache = ArbitraryFileCache.this.resolveCachePathForCompressionMethod(cachesRoot, ArbitraryFileCache.this.compressionMethod);
            ArbitraryFileCache.this.logMessage("Creating cache...", listener);
            long cacheCreationStartTime = System.nanoTime();
            try {
                ArbitraryFileCache.this.compressionMethod.getCacheStrategy().cache(resolvedPath, ArbitraryFileCache.this.includes, ArbitraryFileCache.this.excludes, ArbitraryFileCache.this.useDefaultExcludes, cache, workspace);
                if (ArbitraryFileCache.this.compressionMethod.isDeprecated()) {
                    listener.getLogger().println("WARNING: Compression method " + ArbitraryFileCache.this.compressionMethod.name() + " is deprecated. Please switch to a supported compression method.");
                }
                if (ArbitraryFileCache.this.isCacheValidityDecidingFileConfigured() && ArbitraryFileCache.this.isOneCacheValidityDecidingFilePresent(workspace)) {
                    this.updateSkipCacheTriggerFileHash(cachesRoot, workspace, listener);
                }
                long cacheCreationEndTime = System.nanoTime();
                ArbitraryFileCache.this.logMessage("Cache created in " + Duration.ofNanos(cacheCreationEndTime - cacheCreationStartTime).toMillis() + "ms", listener);
            }
            catch (Exception e) {
                ArbitraryFileCache.this.logMessage("Failed to create cache", e, listener);
            }
        }

        private boolean isPathOutsideWorkspace(FilePath resolvedPath, FilePath workspace) {
            return !StringUtils.startsWith((CharSequence)resolvedPath.getRemote(), (CharSequence)workspace.getRemote());
        }

        private boolean isMaybeInsideDockerContainer(FilePath workspace) {
            return workspace.getChannel() == null || workspace.getChannel() instanceof LocalChannel;
        }

        private void updateSkipCacheTriggerFileHash(ObjectPath cachesRoot, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
            try (WorkspaceHelper.TempFile tempFile = WorkspaceHelper.createTempFile(workspace, ArbitraryFileCache.CACHE_VALIDITY_DECIDING_FILE_HASH_FILE_EXTENSION);){
                tempFile.get().write(ArbitraryFileCache.this.getCurrentCacheValidityDecidingFileHash(workspace, listener), StandardCharsets.UTF_8.displayName());
                ObjectPath skipCacheTriggerFileHashFile = cachesRoot.child(ArbitraryFileCache.this.getSkipCacheTriggerFileHashFileName());
                skipCacheTriggerFileHashFile.copyFrom(tempFile.get());
            }
        }
    }

    @Extension
    @Symbol(value={"arbitraryFileCache"})
    public static final class DescriptorImpl
    extends CacheDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ArbitraryFileCache_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCompressionMethodItems() {
            ListBoxModel items = new ListBoxModel();
            for (CompressionMethod method : CompressionMethod.values()) {
                items.add(method.name());
            }
            return items;
        }
    }
}

