/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jobcacher.arbitrary;

import hudson.Util;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;

class SymlinkSafeDirScanner
extends DirScanner {
    private static final long serialVersionUID = 1L;
    private final String includes;
    private final String excludes;
    private final boolean useDefaultExcludes;

    SymlinkSafeDirScanner(String includes, String excludes, boolean useDefaultExcludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void scan(File dir, FileVisitor visitor) throws IOException {
        if (!dir.exists()) {
            return;
        }
        this.scanRealFiles(dir, visitor);
        if (visitor.understandsSymlink()) {
            String[] includePatterns = SymlinkSafeDirScanner.parsePatterns(this.includes, "**");
            String[] excludePatterns = SymlinkSafeDirScanner.parsePatterns(this.excludes, null);
            String[] defaultExcludePatterns = this.useDefaultExcludes ? DirectoryScanner.getDefaultExcludes() : new String[]{};
            this.scanSymlinks(dir, dir, visitor, includePatterns, excludePatterns, defaultExcludePatterns);
        }
    }

    private void scanRealFiles(File dir, FileVisitor visitor) throws IOException {
        FileSet fs = Util.createFileSet((File)dir, (String)this.includes, (String)this.excludes);
        fs.setFollowSymlinks(false);
        fs.setDefaultexcludes(this.useDefaultExcludes);
        DirectoryScanner ds = fs.getDirectoryScanner(new Project());
        for (String relativePath : ds.getIncludedFiles()) {
            this.scanSingle(new File(dir, relativePath), relativePath, visitor);
        }
    }

    private void scanSymlinks(File current, File baseDir, FileVisitor visitor, String[] includePatterns, String[] excludePatterns, String[] defaultExcludePatterns) throws IOException {
        File[] children = current.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (Files.isSymbolicLink(child.toPath())) {
                String relativePath = baseDir.toPath().relativize(child.toPath()).toString();
                if (!SymlinkSafeDirScanner.matchesPatterns(relativePath, includePatterns, excludePatterns, defaultExcludePatterns)) continue;
                this.scanSingle(child, relativePath, visitor);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.scanSymlinks(child, baseDir, visitor, includePatterns, excludePatterns, defaultExcludePatterns);
        }
    }

    private static boolean matchesPatterns(String relativePath, String[] includePatterns, String[] excludePatterns, String[] defaultExcludePatterns) {
        boolean included = false;
        for (String pattern : includePatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath)) continue;
            included = true;
            break;
        }
        if (!included) {
            return false;
        }
        for (String pattern : excludePatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath)) continue;
            return false;
        }
        for (String pattern : defaultExcludePatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath)) continue;
            return false;
        }
        return true;
    }

    private static String[] parsePatterns(String patterns, String defaultPattern) {
        if (patterns == null || patterns.isBlank()) {
            String[] stringArray;
            if (defaultPattern != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultPattern;
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        String[] tokens = patterns.split(",");
        ArrayList<String> result = new ArrayList<String>();
        for (String token : tokens) {
            String trimmed = token.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result.toArray(new String[0]);
    }
}

