/*
 * Decompiled with CFR 0.152.
 */
package hudson.ivy.builder;

import hudson.Extension;
import hudson.ivy.builder.IvyBuilderType;
import hudson.ivy.builder.IvyBuilderTypeDescriptor;
import hudson.model.Environment;
import hudson.plugins.nant.NantBuilder;
import hudson.tasks.Builder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class NAntIvyBuilderType
extends IvyBuilderType {
    private final String targets;
    private final String nantName;
    private final String nantOpts;
    private final String buildFile;
    private final String nantProperties;

    @DataBoundConstructor
    public NAntIvyBuilderType(String nantName, String buildFile, String targets, String nantProperties, String nantOpts) {
        this.nantName = nantName;
        this.buildFile = buildFile;
        this.targets = targets;
        this.nantProperties = nantProperties;
        this.nantOpts = nantOpts;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getNantName() {
        return this.nantName;
    }

    public String getNantOpts() {
        return this.nantOpts;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getNantProperties() {
        return this.nantProperties;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return new HashMap<String, String>();
    }

    @Override
    public Builder getBuilder(Properties additionalProperties, String overrideTargets, List<Environment> environments) {
        StringBuilder properties = new StringBuilder();
        if (this.nantProperties != null) {
            properties.append(this.nantProperties);
        }
        if (additionalProperties != null) {
            for (String key : additionalProperties.stringPropertyNames()) {
                properties.append("\n");
                properties.append(key).append("=").append(additionalProperties.getProperty(key));
            }
        }
        return new NantBuilder(this.buildFile, this.nantName, overrideTargets == null ? this.targets : overrideTargets, properties.length() == 0 ? null : properties.toString());
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends IvyBuilderTypeDescriptor {
        public String getDisplayName() {
            return "NAnt Builder";
        }

        public NantBuilder.NantInstallation[] getInstallations() {
            return ((NantBuilder.DescriptorImpl)Jenkins.get().getDescriptorByType(NantBuilder.DescriptorImpl.class)).getInstallations();
        }
    }
}

