/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.auth;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import jenkins.plugins.http_request.auth.Authenticator;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpHost;

public class CredentialBasicAuthentication
implements Authenticator {
    private static final long serialVersionUID = 8034231374732499786L;
    private final StandardUsernamePasswordCredentials credential;
    private final Map<HttpHost, StandardUsernamePasswordCredentials> extraCredentials = new Hashtable<HttpHost, StandardUsernamePasswordCredentials>();

    public CredentialBasicAuthentication(StandardUsernamePasswordCredentials credential) {
        this.credential = credential;
    }

    public void addCredentials(HttpHost host, StandardUsernamePasswordCredentials credentials) {
        if (host == null || credentials == null) {
            throw new IllegalArgumentException("Null target host or credentials");
        }
        this.extraCredentials.put(host, this.credential);
    }

    @Override
    public String getKeyName() {
        return this.credential.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpClientContext context, HttpUriRequestBase requestBase, PrintStream logger) {
        this.prepare(clientBuilder, context, requestBase);
        return clientBuilder.build();
    }

    public void prepare(HttpClientBuilder clientBuilder, HttpClientContext context, HttpUriRequestBase requestBase) {
        try {
            this.prepare(clientBuilder, context, URIUtils.extractHost((URI)requestBase.getUri()));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void prepare(HttpClientBuilder clientBuilder, HttpClientContext context, HttpHost targetHost) {
        CredentialBasicAuthentication.auth(clientBuilder, context, targetHost, this.credential.getUsername(), this.credential.getPassword().getPlainText(), this.extraCredentials);
    }

    static void auth(HttpClientBuilder clientBuilder, HttpClientContext context, HttpHost targetHost, String username, String password, Map<HttpHost, StandardUsernamePasswordCredentials> extraCreds) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        BasicAuthCache authCache = new BasicAuthCache();
        UsernamePasswordCredentials mainCredentials = new UsernamePasswordCredentials(username, password.toCharArray());
        CredentialBasicAuthentication.setCredentials(targetHost, provider, (AuthCache)authCache, (Credentials)mainCredentials);
        if (extraCreds != null && !extraCreds.isEmpty()) {
            for (Map.Entry<HttpHost, StandardUsernamePasswordCredentials> creds : extraCreds.entrySet()) {
                UsernamePasswordCredentials extraCredentials = new UsernamePasswordCredentials(creds.getValue().getUsername(), creds.getValue().getPassword().getPlainText().toCharArray());
                CredentialBasicAuthentication.setCredentials(creds.getKey(), provider, (AuthCache)authCache, (Credentials)extraCredentials);
            }
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        context.setAuthCache((AuthCache)authCache);
        context.setCredentialsProvider((CredentialsProvider)provider);
    }

    static void setCredentials(HttpHost targetHost, BasicCredentialsProvider provider, AuthCache authCache, Credentials credentials) {
        provider.setCredentials(new AuthScope(targetHost), credentials);
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.initPreemptive(credentials);
        authCache.put(targetHost, (AuthScheme)basicScheme);
    }
}

