/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin.deflake;

import com.google.jenkins.flakyTestHandler.plugin.HistoryAggregatedFlakyTestResultAction;
import com.google.jenkins.flakyTestHandler.plugin.deflake.DeflakeAction;
import com.google.jenkins.flakyTestHandler.plugin.deflake.DeflakeCause;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResultAction;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class DeflakeListener
extends RunListener<Run> {
    private static final Logger LOGGER = Logger.getLogger(DeflakeListener.class.getName());

    public DeflakeListener() {
        super(Run.class);
    }

    public void onCompleted(Run run, TaskListener listener) {
        TestResultAction testResultAction = (TestResultAction)run.getAction(TestResultAction.class);
        HistoryAggregatedFlakyTestResultAction historyAction = (HistoryAggregatedFlakyTestResultAction)run.getParent().getAction(HistoryAggregatedFlakyTestResultAction.class);
        if (historyAction != null) {
            historyAction.aggregateOneBuild(run);
        }
        if (testResultAction != null && testResultAction.getFailCount() > 0) {
            run.addAction((Action)new DeflakeAction(DeflakeListener.getFailingTestClassMethodMap(testResultAction.getFailedTests())));
        }
    }

    public void onStarted(Run build, TaskListener listener) {
        List causesList = build.getCauses();
        try {
            for (Cause cause : causesList) {
                if (!(cause instanceof DeflakeCause)) continue;
                build.setDisplayName(build.getDisplayName() + ": " + cause.getShortDescription());
                return;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to set deflake build name: " + e.getMessage());
        }
    }

    static Map<String, Set<String>> getFailingTestClassMethodMap(List<CaseResult> caseResultList) {
        HashMap<String, Set<String>> classMethodMap = new HashMap<String, Set<String>>();
        if (caseResultList != null) {
            for (CaseResult caseResult : caseResultList) {
                if (!classMethodMap.containsKey(caseResult.getClassName())) {
                    classMethodMap.put(caseResult.getClassName(), new HashSet());
                }
                ((Set)classMethodMap.get(caseResult.getClassName())).add(caseResult.getName());
            }
        }
        return classMethodMap;
    }
}

