/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastBuildColumn
extends ListViewColumn {
    private int sortType = 0;
    private int buildType = 0;
    private boolean useRelative = false;
    private boolean showLink = false;
    private static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";

    @DataBoundConstructor
    public LastBuildColumn(int sortType, int buildType, boolean useRelative, boolean showLink) {
        this.sortType = sortType;
        this.buildType = buildType;
        this.useRelative = useRelative;
        this.showLink = showLink;
    }

    public LastBuildColumn() {
        this(0, 0, false, false);
    }

    public int getSortType() {
        return this.sortType;
    }

    public int getBuildType() {
        return this.buildType;
    }

    public boolean getUseRelative() {
        return this.useRelative;
    }

    public boolean getShowLink() {
        return this.showLink;
    }

    public Run<?, ?> getBuild(Job<?, ?> job) {
        switch (this.getBuildType()) {
            case 0: {
                return job.getLastBuild();
            }
            case 1: {
                return job.getLastCompletedBuild();
            }
            case 2: {
                return job.getLastFailedBuild();
            }
            case 3: {
                return job.getLastSuccessfulBuild();
            }
            case 4: {
                return job.getLastUnsuccessfulBuild();
            }
            case 5: {
                return job.getLastStableBuild();
            }
            case 6: {
                return job.getLastUnstableBuild();
            }
        }
        return job.getLastBuild();
    }

    public String getBuildTypeString() {
        switch (this.getBuildType()) {
            case 0: {
                return Messages.LastBuildColumn_LastBuild();
            }
            case 1: {
                return Messages.LastBuildColumn_LastCompletedBuild();
            }
            case 2: {
                return Messages.LastBuildColumn_LastFailedBuild();
            }
            case 3: {
                return Messages.LastBuildColumn_LastSuccessfulBuild();
            }
            case 4: {
                return Messages.LastBuildColumn_LastUnsuccessfulBuild();
            }
            case 5: {
                return Messages.LastBuildColumn_LastStableBuild();
            }
            case 6: {
                return Messages.LastBuildColumn_LastUnstableBuild();
            }
        }
        return Messages.LastBuildColumn_LastBuild();
    }

    public String getBuildTypeUrl() {
        switch (this.getBuildType()) {
            case 0: {
                return "lastBuild";
            }
            case 1: {
                return "lastCompletedBuild";
            }
            case 2: {
                return "lastFailedBuild";
            }
            case 3: {
                return "lastSuccessfulBuild";
            }
            case 4: {
                return "lastUnsuccessfulBuild";
            }
            case 5: {
                return "lastStableBuild";
            }
            case 6: {
                return "lastUnstableBuild";
            }
        }
        return "lastBuild";
    }

    public String getLastBuildStartAbsoluteString(Run<?, ?> build) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        return sdf.format(build.getStartTimeInMillis());
    }

    public long getBuildEndTimeInMillis(Run<?, ?> build) {
        return build.getStartTimeInMillis() + build.getDuration();
    }

    public String getLastBuildEndAbsoluteString(Run<?, ?> build) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        return sdf.format(this.getBuildEndTimeInMillis(build));
    }

    public String getLastBuildEndRelativeString(Run<?, ?> build) {
        long duration = new GregorianCalendar().getTimeInMillis() - this.getBuildEndTimeInMillis(build);
        return Util.getPastTimeString((long)duration);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.LastBuildColumn_DisplayName();
        }
    }
}

