/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.PropertiesGetter;
import org.jenkinsci.plugins.envinject.service.PropertiesLoader;

public class PropertiesVariablesRetriever
extends MasterToSlaveFileCallable<Map<String, String>> {
    @CheckForNull
    private String propertiesFilePath;
    @CheckForNull
    private Map<String, String> propertiesContent;
    @NonNull
    private Map<String, String> currentEnvVars;
    @NonNull
    private EnvInjectLogger logger;

    public PropertiesVariablesRetriever(@CheckForNull String propertiesFilePath, @CheckForNull Map<String, String> propertiesContent, @NonNull Map<String, String> currentEnvVars, @NonNull EnvInjectLogger logger) {
        this.propertiesFilePath = propertiesFilePath;
        this.propertiesContent = propertiesContent;
        this.currentEnvVars = currentEnvVars;
        this.logger = logger;
    }

    public Map<String, String> invoke(@CheckForNull File base, @CheckForNull VirtualChannel channel) throws IOException, InterruptedException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            PropertiesLoader loader = new PropertiesLoader();
            if (this.propertiesFilePath != null) {
                String propertiesFilePathResolved = Util.replaceMacro((String)this.propertiesFilePath, this.currentEnvVars);
                File propertiesFile = this.getFile(base, propertiesFilePathResolved = propertiesFilePathResolved.replace("\\", "/"));
                if (propertiesFile == null) {
                    String message = String.format("The given properties file path '%s' doesn't exist.", propertiesFilePathResolved);
                    this.logger.error(message);
                    String patternMessage = String.format("Missing file path was resolved from pattern '%s' .", this.propertiesFilePath);
                    this.logger.error(patternMessage);
                    throw new EnvInjectException(message);
                }
                this.logger.info(String.format("Injecting as environment variables the properties file path '%s'", propertiesFilePathResolved));
                result.putAll(loader.getVarsFromPropertiesFile(propertiesFile, this.currentEnvVars));
                this.logger.info("Variables injected successfully.");
            }
            if (this.propertiesContent != null) {
                PropertiesGetter propertiesGetter = new PropertiesGetter();
                this.logger.info(String.format("Injecting as environment variables the properties content %n%s%n", propertiesGetter.getPropertiesContentFromMapObject(this.propertiesContent)));
                for (Map.Entry<String, String> entry : this.propertiesContent.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (result.containsKey(key)) {
                        LinkedHashMap<String, String> oldValueMap = new LinkedHashMap<String, String>();
                        oldValueMap.put(key, (String)result.get(key));
                        value = Util.replaceMacro((String)value, oldValueMap);
                    }
                    result.put(key, value);
                }
                this.logger.info("Variables injected successfully.");
            }
        }
        catch (EnvInjectException envEx) {
            throw new IOException(envEx.getMessage());
        }
        return result;
    }

    @CheckForNull
    private File getFile(@CheckForNull File base, @NonNull String scriptFilePath) {
        File file = new File(scriptFilePath);
        if (file.exists()) {
            return file;
        }
        file = new File(base, scriptFilePath);
        return file.exists() ? file : null;
    }
}

