/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.WorkspaceListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectPasswordsMasker;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.jenkinsci.plugins.envinject.service.EnvironmentVariablesNodeLoader;
import org.jenkinsci.plugins.envinject.util.RunHelper;

@Extension
public class EnvInjectListener
extends RunListener<Run>
implements Serializable {
    public Environment setUpEnvironment(@NonNull AbstractBuild build, @NonNull Launcher launcher, @NonNull BuildListener listener) throws IOException, InterruptedException {
        if (this.isEligibleJobType((Run<?, ?>)build)) {
            EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
            try {
                Node buildNode = build.getBuiltOn();
                if (buildNode != null) {
                    this.loadEnvironmentVariablesNode((Run<?, ?>)build, buildNode, logger);
                }
                if (this.isEnvInjectJobPropertyActive((Run<?, ?>)build)) {
                    return this.setUpEnvironmentJobPropertyObject((Run<?, ?>)build, launcher, listener, logger);
                }
                return this.setUpEnvironmentWithoutJobPropertyObject(build, launcher, listener);
            }
            catch (Run.RunnerAbortedException rre) {
                logger.info("Fail the build.");
                throw new Run.RunnerAbortedException();
            }
            catch (EnvInjectException e) {
                e.printStackTrace(listener.error("SEVERE ERROR occurs"));
                throw new Run.RunnerAbortedException();
            }
        }
        return new Environment(){};
    }

    private boolean isEligibleJobType(@NonNull Run<?, ?> build) {
        Job job = build instanceof MatrixRun ? ((MatrixRun)build).getParentBuild().getParent() : build.getParent();
        return job instanceof BuildableItemWithBuildWrappers;
    }

    private void loadEnvironmentVariablesNode(@NonNull Run<?, ?> build, @NonNull Node buildNode, @NonNull EnvInjectLogger logger) throws EnvInjectException {
        Map<String, String> configNodeEnvVars = EnvironmentVariablesNodeLoader.gatherEnvVarsForNode(build, buildNode, logger);
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(buildNode.getRootPath());
        try {
            envInjectActionSetter.addEnvVarsToRun(build, configNodeEnvVars);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException((Throwable)ie);
        }
    }

    private boolean isEnvInjectJobPropertyActive(@NonNull Run<?, ?> run) {
        EnvInjectJobProperty envInjectJobProperty = RunHelper.getEnvInjectJobProperty(run);
        return envInjectJobProperty != null;
    }

    private Environment setUpEnvironmentJobPropertyObject(@NonNull Run<?, ?> build, @NonNull Launcher launcher, @NonNull BuildListener listener, @NonNull EnvInjectLogger logger) throws IOException, InterruptedException, EnvInjectException {
        FilePath rootPath;
        logger.info("Preparing an environment for the build.");
        EnvInjectJobProperty envInjectJobProperty = RunHelper.getEnvInjectJobProperty(build);
        assert (envInjectJobProperty != null);
        EnvInjectJobPropertyInfo info = envInjectJobProperty.getInfo();
        assert (envInjectJobProperty.isOn());
        Map<String, String> previousEnvVars = RunHelper.getEnvVarsPreviousSteps(build, logger);
        LinkedHashMap<String, String> infraEnvVarsNode = new LinkedHashMap<String, String>(previousEnvVars);
        LinkedHashMap<String, String> infraEnvVarsMaster = new LinkedHashMap<String, String>(previousEnvVars);
        if (envInjectJobProperty.isKeepJenkinsSystemVariables()) {
            logger.info("Keeping Jenkins system variables.");
            infraEnvVarsMaster.putAll(EnvInjectVariableGetter.getJenkinsSystemEnvVars(true));
            infraEnvVarsNode.putAll(EnvInjectVariableGetter.getJenkinsSystemEnvVars(false));
        }
        if (envInjectJobProperty.isKeepBuildVariables()) {
            logger.info("Keeping Jenkins build variables.");
            Map<String, String> buildVariables = RunHelper.getBuildVariables(build, logger);
            infraEnvVarsMaster.putAll(buildVariables);
            infraEnvVarsNode.putAll(buildVariables);
        }
        if ((rootPath = this.getNodeRootPath()) != null && info != null) {
            final EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
            int resultCode = envInjectEnvVarsService.executeScript(info.isLoadFilesFromMaster(), info.getScriptContent(), rootPath, info.getScriptFilePath(), infraEnvVarsMaster, infraEnvVarsNode, launcher, listener);
            if (resultCode != 0) {
                build.setResult(Result.FAILURE);
                throw new Run.RunnerAbortedException();
            }
            Map<String, String> groovyMapEnvVars = envInjectEnvVarsService.executeGroovyScript(logger, info.getSecureGroovyScript(), infraEnvVarsNode);
            Map<String, String> propertiesVariables = envInjectEnvVarsService.getEnvVarsPropertiesJobProperty(rootPath, logger, info.isLoadFilesFromMaster(), info.getPropertiesFilePath(), info.getPropertiesContentMap(previousEnvVars), infraEnvVarsMaster, infraEnvVarsNode);
            Map<String, String> contributionVariables = this.getEnvVarsByContribution(build, envInjectJobProperty, logger, listener);
            final Map<String, String> mergedVariables = envInjectEnvVarsService.getMergedVariables(infraEnvVarsNode, propertiesVariables, groovyMapEnvVars, contributionVariables);
            new EnvInjectActionSetter(rootPath).addEnvVarsToRun(build, mergedVariables);
            return new Environment(){

                public void buildEnvVars(Map<String, String> env) {
                    envInjectEnvVarsService.resolveVars(mergedVariables, mergedVariables);
                    env.putAll(mergedVariables);
                }
            };
        }
        logger.info(rootPath != null ? "Cannot retrieve info from the EnvInject job property. It may be missing, hence skipping injection." : "Node root path is not available. Likely node is offline. Skipping injection");
        return new Environment(){};
    }

    @NonNull
    private Environment setUpEnvironmentWithoutJobPropertyObject(@NonNull AbstractBuild build, @NonNull Launcher launcher, @NonNull BuildListener listener) throws IOException, InterruptedException, EnvInjectException {
        final HashMap<String, String> resultVariables = new HashMap<String, String>();
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        Map<String, String> previousEnvVars = RunHelper.getEnvVarsPreviousSteps(build, logger);
        resultVariables.putAll(previousEnvVars);
        resultVariables.putAll(EnvInjectVariableGetter.getJenkinsSystemEnvVars(false));
        resultVariables.putAll(RunHelper.getBuildVariables(build, logger));
        FilePath rootPath = this.getNodeRootPath();
        if (rootPath != null) {
            new EnvInjectActionSetter(rootPath).addEnvVarsToRun((Run<?, ?>)build, (Map<String, String>)resultVariables);
        }
        return new Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.putAll(resultVariables);
            }
        };
    }

    @CheckForNull
    private Node getNode() {
        Computer computer = Computer.currentComputer();
        if (computer == null) {
            return null;
        }
        return computer.getNode();
    }

    @CheckForNull
    private FilePath getNodeRootPath() {
        Node node = this.getNode();
        if (node != null) {
            return node.getRootPath();
        }
        return null;
    }

    @NonNull
    private Map<String, String> getEnvVarsByContribution(@NonNull Run<?, ?> run, @NonNull EnvInjectJobProperty envInjectJobProperty, @NonNull EnvInjectLogger logger, @NonNull BuildListener listener) throws EnvInjectException {
        HashMap<String, String> contributionVariables = new HashMap<String, String>();
        EnvInjectJobPropertyContributor[] contributors = envInjectJobProperty.getContributors();
        if (contributors != null) {
            logger.info("Injecting contributions.");
            for (EnvInjectJobPropertyContributor contributor : contributors) {
                contributor.contributeEnvVarsToRun(run, (TaskListener)listener, contributionVariables);
            }
        }
        return contributionVariables;
    }

    public void onCompleted(Run run, TaskListener listener) {
        EnvInjectPluginAction envInjectAction;
        if (!(run instanceof AbstractBuild)) {
            return;
        }
        if (!this.isEligibleJobType(run)) {
            return;
        }
        EnvVars envVars = new EnvVars();
        EnvInjectLogger logger = new EnvInjectLogger(listener);
        EnvInjectPasswordsMasker passwordsMasker = new EnvInjectPasswordsMasker();
        passwordsMasker.maskPasswordParametersIfAny(run, (Map<String, String>)envVars, logger);
        if (!(run instanceof MatrixBuild) && (envInjectAction = (EnvInjectPluginAction)run.getAction(EnvInjectPluginAction.class)) == null) {
            try {
                envVars.putAll((Map)run.getEnvironment(listener));
            }
            catch (IOException | InterruptedException e) {
                logger.error("SEVERE ERROR occurs: " + e.getMessage());
                throw new Run.RunnerAbortedException();
            }
        }
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(this.getNodeRootPath());
        try {
            envInjectActionSetter.addEnvVarsToRun(run, (Map<String, String>)envVars);
        }
        catch (IOException | InterruptedException | EnvInjectException e) {
            logger.error("SEVERE ERROR occurs: " + e.getMessage());
            throw new Run.RunnerAbortedException();
        }
    }

    @Extension
    public static class JobSetupEnvironmentWorkspaceListener
    extends WorkspaceListener {
        public void beforeUse(AbstractBuild build, FilePath ws, BuildListener listener) {
            EnvInjectJobProperty envInjectJobProperty = RunHelper.getEnvInjectJobProperty(build);
            if (envInjectJobProperty == null) {
                return;
            }
            EnvInjectLogger envInjectLogger = new EnvInjectLogger((TaskListener)listener);
            if (envInjectJobProperty.isKeepBuildVariables()) {
                try {
                    Map<String, String> previousEnvVars = RunHelper.getEnvVarsPreviousSteps(build, envInjectLogger);
                    if (previousEnvVars.get("WORKSPACE") == null) {
                        previousEnvVars.put("WORKSPACE", ws.getRemote());
                    }
                    EnvInjectEnvVars envInjectEnvVars = new EnvInjectEnvVars(envInjectLogger);
                    envInjectEnvVars.resolveVars(previousEnvVars, previousEnvVars);
                    Map<String, String> cleanVariables = envInjectEnvVars.removeUnsetVars(previousEnvVars);
                    Node builtOn = build.getBuiltOn();
                    new EnvInjectActionSetter(builtOn != null ? builtOn.getRootPath() : null).addEnvVarsToRun((Run<?, ?>)build, cleanVariables);
                }
                catch (EnvInjectException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

