// CHECKSTYLE:OFF

package hudson.plugins.copyartifact;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CopyArtifact.FailedToCopy}: {@code Failed to copy artifacts
     * from {0} with filter: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy artifacts from {0} with filter: {1}}
     */
    public static String CopyArtifact_FailedToCopy(Object arg0, Object arg1) {
        return holder.format("CopyArtifact.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code CopyArtifact.FailedToCopy}: {@code Failed to copy artifacts
     * from {0} with filter: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to copy artifacts from {0} with filter: {1}}
     */
    public static Localizable _CopyArtifact_FailedToCopy(Object arg0, Object arg1) {
        return new Localizable(holder, "CopyArtifact.FailedToCopy", arg0, arg1);
    }

    /**
     * Key {@code CopyArtifact.InvalidVariableName}: {@code Contains letters
     * not applicable for variable names.}.
     * 
     * @return
     *     {@code Contains letters not applicable for variable names.}
     */
    public static String CopyArtifact_InvalidVariableName() {
        return holder.format("CopyArtifact.InvalidVariableName");
    }

    /**
     * Key {@code CopyArtifact.InvalidVariableName}: {@code Contains letters
     * not applicable for variable names.}.
     * 
     * @return
     *     {@code Contains letters not applicable for variable names.}
     */
    public static Localizable _CopyArtifact_InvalidVariableName() {
        return new Localizable(holder, "CopyArtifact.InvalidVariableName");
    }

    /**
     * Key {@code ParameterizedBuildSelector.DisplayName}: {@code Specified
     * by a build parameter}.
     * 
     * @return
     *     {@code Specified by a build parameter}
     */
    public static String ParameterizedBuildSelector_DisplayName() {
        return holder.format("ParameterizedBuildSelector.DisplayName");
    }

    /**
     * Key {@code ParameterizedBuildSelector.DisplayName}: {@code Specified
     * by a build parameter}.
     * 
     * @return
     *     {@code Specified by a build parameter}
     */
    public static Localizable _ParameterizedBuildSelector_DisplayName() {
        return new Localizable(holder, "ParameterizedBuildSelector.DisplayName");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamProjectName.NotFound}:
     * {@code Not Found}.
     * 
     * @return
     *     {@code Not Found}
     */
    public static String DownstreamBuildSelector_UpstreamProjectName_NotFound() {
        return holder.format("DownstreamBuildSelector.UpstreamProjectName.NotFound");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamProjectName.NotFound}:
     * {@code Not Found}.
     * 
     * @return
     *     {@code Not Found}
     */
    public static Localizable _DownstreamBuildSelector_UpstreamProjectName_NotFound() {
        return new Localizable(holder, "DownstreamBuildSelector.UpstreamProjectName.NotFound");
    }

    /**
     * Key {@code CopyArtifact.MavenProject}: {@code Artifacts will be copied
     * from all modules of this Maven project; click the help icon to learn
     * about selecting a particular module.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all modules of this Maven
     *     project; click the help icon to learn about selecting a particular
     *     module.}
     */
    public static String CopyArtifact_MavenProject() {
        return holder.format("CopyArtifact.MavenProject");
    }

    /**
     * Key {@code CopyArtifact.MavenProject}: {@code Artifacts will be copied
     * from all modules of this Maven project; click the help icon to learn
     * about selecting a particular module.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all modules of this Maven
     *     project; click the help icon to learn about selecting a particular
     *     module.}
     */
    public static Localizable _CopyArtifact_MavenProject() {
        return new Localizable(holder, "CopyArtifact.MavenProject");
    }

    /**
     * Key {@code CopyArtifact.NoArtifactsPermission}: {@code Not permitted
     * to read artifacts from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not permitted to read artifacts from: {0}}
     */
    public static String CopyArtifact_NoArtifactsPermission(Object arg0) {
        return holder.format("CopyArtifact.NoArtifactsPermission", arg0);
    }

    /**
     * Key {@code CopyArtifact.NoArtifactsPermission}: {@code Not permitted
     * to read artifacts from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Not permitted to read artifacts from: {0}}
     */
    public static Localizable _CopyArtifact_NoArtifactsPermission(Object arg0) {
        return new Localizable(holder, "CopyArtifact.NoArtifactsPermission", arg0);
    }

    /**
     * Key {@code CopyArtifact.MigrationOnMissingProject}: {@code Due to the
     * Copy artifact compatibility mode, set as migration, the build can
     * reach the project {0}.
     *  But in Production mode, this will not be the
     * case anymore.
     *  Please consider adding the CopyArtifactPermission on
     * the project you want to copy.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Due to the Copy artifact compatibility mode, set as migration,
     *     the build can reach the project {0}.
     *      But in Production mode, this
     *     will not be the case anymore.
     *      Please consider adding the
     *     CopyArtifactPermission on the project you want to copy.}
     */
    public static String CopyArtifact_MigrationOnMissingProject(Object arg0) {
        return holder.format("CopyArtifact.MigrationOnMissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.MigrationOnMissingProject}: {@code Due to the
     * Copy artifact compatibility mode, set as migration, the build can
     * reach the project {0}.
     *  But in Production mode, this will not be the
     * case anymore.
     *  Please consider adding the CopyArtifactPermission on
     * the project you want to copy.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Due to the Copy artifact compatibility mode, set as migration,
     *     the build can reach the project {0}.
     *      But in Production mode, this
     *     will not be the case anymore.
     *      Please consider adding the
     *     CopyArtifactPermission on the project you want to copy.}
     */
    public static Localizable _CopyArtifact_MigrationOnMissingProject(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MigrationOnMissingProject", arg0);
    }

    /**
     * Key {@code
     * TriggeredBuildSelector.UpstreamFilterStrategy.UseGlobalSetting}:
     * {@code Use global setting}.
     * 
     * @return
     *     {@code Use global setting}
     */
    public static String TriggeredBuildSelector_UpstreamFilterStrategy_UseGlobalSetting() {
        return holder.format("TriggeredBuildSelector.UpstreamFilterStrategy.UseGlobalSetting");
    }

    /**
     * Key {@code
     * TriggeredBuildSelector.UpstreamFilterStrategy.UseGlobalSetting}:
     * {@code Use global setting}.
     * 
     * @return
     *     {@code Use global setting}
     */
    public static Localizable _TriggeredBuildSelector_UpstreamFilterStrategy_UseGlobalSetting() {
        return new Localizable(holder, "TriggeredBuildSelector.UpstreamFilterStrategy.UseGlobalSetting");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamProjectName.Required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String DownstreamBuildSelector_UpstreamProjectName_Required() {
        return holder.format("DownstreamBuildSelector.UpstreamProjectName.Required");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamProjectName.Required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _DownstreamBuildSelector_UpstreamProjectName_Required() {
        return new Localizable(holder, "DownstreamBuildSelector.UpstreamProjectName.Required");
    }

    /**
     * Key {@code CopyArtifact.MatrixProject}: {@code Artifacts will be
     * copied from all configurations of this multiconfiguration project;
     * click the help icon to learn about selecting a particular
     * configuration.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all configurations of this
     *     multiconfiguration project; click the help icon to learn about
     *     selecting a particular configuration.}
     */
    public static String CopyArtifact_MatrixProject() {
        return holder.format("CopyArtifact.MatrixProject");
    }

    /**
     * Key {@code CopyArtifact.MatrixProject}: {@code Artifacts will be
     * copied from all configurations of this multiconfiguration project;
     * click the help icon to learn about selecting a particular
     * configuration.}.
     * 
     * @return
     *     {@code Artifacts will be copied from all configurations of this
     *     multiconfiguration project; click the help icon to learn about
     *     selecting a particular configuration.}
     */
    public static Localizable _CopyArtifact_MatrixProject() {
        return new Localizable(holder, "CopyArtifact.MatrixProject");
    }

    /**
     * Key {@code CopyArtifact.MissingBuild}: {@code Unable to find a build
     * for artifact copy from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find a build for artifact copy from: {0}}
     */
    public static String CopyArtifact_MissingBuild(Object arg0) {
        return holder.format("CopyArtifact.MissingBuild", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingBuild}: {@code Unable to find a build
     * for artifact copy from: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find a build for artifact copy from: {0}}
     */
    public static Localizable _CopyArtifact_MissingBuild(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MissingBuild", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingProject}: {@code Unable to find project
     * for artifact copy: {0}
     * This may be due to incorrect project name or
     * permission settings; see help for project name in job configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project for artifact copy: {0}
     *     This may be due
     *     to incorrect project name or permission settings; see help for project
     *     name in job configuration.}
     */
    public static String CopyArtifact_MissingProject(Object arg0) {
        return holder.format("CopyArtifact.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingProject}: {@code Unable to find project
     * for artifact copy: {0}
     * This may be due to incorrect project name or
     * permission settings; see help for project name in job configuration.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project for artifact copy: {0}
     *     This may be due
     *     to incorrect project name or permission settings; see help for project
     *     name in job configuration.}
     */
    public static Localizable _CopyArtifact_MissingProject(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingSrcArtifacts}: {@code Unable to access
     * upstream artifacts area {0}. Does source project archive artifacts?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to access upstream artifacts area {0}. Does source
     *     project archive artifacts?}
     */
    public static String CopyArtifact_MissingSrcArtifacts(Object arg0) {
        return holder.format("CopyArtifact.MissingSrcArtifacts", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingSrcArtifacts}: {@code Unable to access
     * upstream artifacts area {0}. Does source project archive artifacts?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to access upstream artifacts area {0}. Does source
     *     project archive artifacts?}
     */
    public static Localizable _CopyArtifact_MissingSrcArtifacts(Object arg0) {
        return new Localizable(holder, "CopyArtifact.MissingSrcArtifacts", arg0);
    }

    /**
     * Key {@code SpecificBuildSelector.DisplayName}: {@code Specific build}.
     * 
     * @return
     *     {@code Specific build}
     */
    public static String SpecificBuildSelector_DisplayName() {
        return holder.format("SpecificBuildSelector.DisplayName");
    }

    /**
     * Key {@code SpecificBuildSelector.DisplayName}: {@code Specific build}.
     * 
     * @return
     *     {@code Specific build}
     */
    public static Localizable _SpecificBuildSelector_DisplayName() {
        return new Localizable(holder, "SpecificBuildSelector.DisplayName");
    }

    /**
     * Key {@code BuildSelectorParameter.DisplayName}: {@code Build selector
     * for Copy Artifact}.
     * 
     * @return
     *     {@code Build selector for Copy Artifact}
     */
    public static String BuildSelectorParameter_DisplayName() {
        return holder.format("BuildSelectorParameter.DisplayName");
    }

    /**
     * Key {@code BuildSelectorParameter.DisplayName}: {@code Build selector
     * for Copy Artifact}.
     * 
     * @return
     *     {@code Build selector for Copy Artifact}
     */
    public static Localizable _BuildSelectorParameter_DisplayName() {
        return new Localizable(holder, "BuildSelectorParameter.DisplayName");
    }

    /**
     * Key {@code DownstreamBuildSelector.DisplayName}: {@code Downstream
     * build of}.
     * 
     * @return
     *     {@code Downstream build of}
     */
    public static String DownstreamBuildSelector_DisplayName() {
        return holder.format("DownstreamBuildSelector.DisplayName");
    }

    /**
     * Key {@code DownstreamBuildSelector.DisplayName}: {@code Downstream
     * build of}.
     * 
     * @return
     *     {@code Downstream build of}
     */
    public static Localizable _DownstreamBuildSelector_DisplayName() {
        return new Localizable(holder, "DownstreamBuildSelector.DisplayName");
    }

    /**
     * Key {@code TriggeredBuildSelector.UpstreamFilterStrategy.UseNewest}:
     * {@code Use the newest build}.
     * 
     * @return
     *     {@code Use the newest build}
     */
    public static String TriggeredBuildSelector_UpstreamFilterStrategy_UseNewest() {
        return holder.format("TriggeredBuildSelector.UpstreamFilterStrategy.UseNewest");
    }

    /**
     * Key {@code TriggeredBuildSelector.UpstreamFilterStrategy.UseNewest}:
     * {@code Use the newest build}.
     * 
     * @return
     *     {@code Use the newest build}
     */
    public static Localizable _TriggeredBuildSelector_UpstreamFilterStrategy_UseNewest() {
        return new Localizable(holder, "TriggeredBuildSelector.UpstreamFilterStrategy.UseNewest");
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.
     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static String BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return holder.format("BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.
     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static Localizable _BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code LastBuildWithArtifactSelector.DisplayName}: {@code Last
     * build with artifacts}.
     * 
     * @return
     *     {@code Last build with artifacts}
     */
    public static String LastBuildWithArtifactSelector_DisplayName() {
        return holder.format("LastBuildWithArtifactSelector.DisplayName");
    }

    /**
     * Key {@code LastBuildWithArtifactSelector.DisplayName}: {@code Last
     * build with artifacts}.
     * 
     * @return
     *     {@code Last build with artifacts}
     */
    public static Localizable _LastBuildWithArtifactSelector_DisplayName() {
        return new Localizable(holder, "LastBuildWithArtifactSelector.DisplayName");
    }

    /**
     * Key {@code WorkspaceSelector.DisplayName}: {@code Copy from WORKSPACE
     * of latest completed build}.
     * 
     * @return
     *     {@code Copy from WORKSPACE of latest completed build}
     */
    public static String WorkspaceSelector_DisplayName() {
        return holder.format("WorkspaceSelector.DisplayName");
    }

    /**
     * Key {@code WorkspaceSelector.DisplayName}: {@code Copy from WORKSPACE
     * of latest completed build}.
     * 
     * @return
     *     {@code Copy from WORKSPACE of latest completed build}
     */
    public static Localizable _WorkspaceSelector_DisplayName() {
        return new Localizable(holder, "WorkspaceSelector.DisplayName");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamBuildNumber.Required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static String DownstreamBuildSelector_UpstreamBuildNumber_Required() {
        return holder.format("DownstreamBuildSelector.UpstreamBuildNumber.Required");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamBuildNumber.Required}:
     * {@code Required}.
     * 
     * @return
     *     {@code Required}
     */
    public static Localizable _DownstreamBuildSelector_UpstreamBuildNumber_Required() {
        return new Localizable(holder, "DownstreamBuildSelector.UpstreamBuildNumber.Required");
    }

    /**
     * Key {@code LastCompletedBuildSelector.DisplayName}: {@code Last
     * completed build (ignoring build status)}.
     * 
     * @return
     *     {@code Last completed build (ignoring build status)}
     */
    public static String LastCompletedBuildSelector_DisplayName() {
        return holder.format("LastCompletedBuildSelector.DisplayName");
    }

    /**
     * Key {@code LastCompletedBuildSelector.DisplayName}: {@code Last
     * completed build (ignoring build status)}.
     * 
     * @return
     *     {@code Last completed build (ignoring build status)}
     */
    public static Localizable _LastCompletedBuildSelector_DisplayName() {
        return new Localizable(holder, "LastCompletedBuildSelector.DisplayName");
    }

    /**
     * Key {@code CopyArtifactPermissionProperty.DisplayName}: {@code
     * Permission to Copy Artifact}.
     * 
     * @return
     *     {@code Permission to Copy Artifact}
     */
    public static String CopyArtifactPermissionProperty_DisplayName() {
        return holder.format("CopyArtifactPermissionProperty.DisplayName");
    }

    /**
     * Key {@code CopyArtifactPermissionProperty.DisplayName}: {@code
     * Permission to Copy Artifact}.
     * 
     * @return
     *     {@code Permission to Copy Artifact}
     */
    public static Localizable _CopyArtifactPermissionProperty_DisplayName() {
        return new Localizable(holder, "CopyArtifactPermissionProperty.DisplayName");
    }

    /**
     * Key {@code SavedBuildSelector.DisplayName}: {@code Latest saved build
     * (marked "keep forever")}.
     * 
     * @return
     *     {@code Latest saved build (marked "keep forever")}
     */
    public static String SavedBuildSelector_DisplayName() {
        return holder.format("SavedBuildSelector.DisplayName");
    }

    /**
     * Key {@code SavedBuildSelector.DisplayName}: {@code Latest saved build
     * (marked "keep forever")}.
     * 
     * @return
     *     {@code Latest saved build (marked "keep forever")}
     */
    public static Localizable _SavedBuildSelector_DisplayName() {
        return new Localizable(holder, "SavedBuildSelector.DisplayName");
    }

    /**
     * Key {@code BuildTrigger.NoProjectSpecified}: {@code No project
     * specified}.
     * 
     * @return
     *     {@code No project specified}
     */
    public static String BuildTrigger_NoProjectSpecified() {
        return holder.format("BuildTrigger.NoProjectSpecified");
    }

    /**
     * Key {@code BuildTrigger.NoProjectSpecified}: {@code No project
     * specified}.
     * 
     * @return
     *     {@code No project specified}
     */
    public static Localizable _BuildTrigger_NoProjectSpecified() {
        return new Localizable(holder, "BuildTrigger.NoProjectSpecified");
    }

    /**
     * Key {@code CopyArtifact.ParameterizedName}: {@code Value references a
     * build parameter, so it cannot be validated.}.
     * 
     * @return
     *     {@code Value references a build parameter, so it cannot be validated.}
     */
    public static String CopyArtifact_ParameterizedName() {
        return holder.format("CopyArtifact.ParameterizedName");
    }

    /**
     * Key {@code CopyArtifact.ParameterizedName}: {@code Value references a
     * build parameter, so it cannot be validated.}.
     * 
     * @return
     *     {@code Value references a build parameter, so it cannot be validated.}
     */
    public static Localizable _CopyArtifact_ParameterizedName() {
        return new Localizable(holder, "CopyArtifact.ParameterizedName");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamBuildNumber.NotFound}:
     * {@code Not Found}.
     * 
     * @return
     *     {@code Not Found}
     */
    public static String DownstreamBuildSelector_UpstreamBuildNumber_NotFound() {
        return holder.format("DownstreamBuildSelector.UpstreamBuildNumber.NotFound");
    }

    /**
     * Key {@code DownstreamBuildSelector.UpstreamBuildNumber.NotFound}:
     * {@code Not Found}.
     * 
     * @return
     *     {@code Not Found}
     */
    public static Localizable _DownstreamBuildSelector_UpstreamBuildNumber_NotFound() {
        return new Localizable(holder, "DownstreamBuildSelector.UpstreamBuildNumber.NotFound");
    }

    /**
     * Key {@code CopyArtifact.Copied}: {@code Copied {0}
     * {0,choice,0#artifacts|1#artifact|1<artifacts} from "{1}" build number
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Copied {0} {0,choice,0#artifacts|1#artifact|1<artifacts} from
     *     "{1}" build number {2}}
     */
    public static String CopyArtifact_Copied(Object arg0, Object arg1, Object arg2) {
        return holder.format("CopyArtifact.Copied", arg0, arg1, arg2);
    }

    /**
     * Key {@code CopyArtifact.Copied}: {@code Copied {0}
     * {0,choice,0#artifacts|1#artifact|1<artifacts} from "{1}" build number
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Copied {0} {0,choice,0#artifacts|1#artifact|1<artifacts} from
     *     "{1}" build number {2}}
     */
    public static Localizable _CopyArtifact_Copied(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "CopyArtifact.Copied", arg0, arg1, arg2);
    }

    /**
     * Key {@code CopyArtifactPermissionProperty.MissingProject}: {@code
     * Unable to find project: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project: {0}}
     */
    public static String CopyArtifactPermissionProperty_MissingProject(Object arg0) {
        return holder.format("CopyArtifactPermissionProperty.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifactPermissionProperty.MissingProject}: {@code
     * Unable to find project: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to find project: {0}}
     */
    public static Localizable _CopyArtifactPermissionProperty_MissingProject(Object arg0) {
        return new Localizable(holder, "CopyArtifactPermissionProperty.MissingProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.AncestorIsNull}: {@code Context Unknown: the
     * value specified cannot be validated}.
     * 
     * @return
     *     {@code Context Unknown: the value specified cannot be validated}
     */
    public static String CopyArtifact_AncestorIsNull() {
        return holder.format("CopyArtifact.AncestorIsNull");
    }

    /**
     * Key {@code CopyArtifact.AncestorIsNull}: {@code Context Unknown: the
     * value specified cannot be validated}.
     * 
     * @return
     *     {@code Context Unknown: the value specified cannot be validated}
     */
    public static Localizable _CopyArtifact_AncestorIsNull() {
        return new Localizable(holder, "CopyArtifact.AncestorIsNull");
    }

    /**
     * Key {@code TriggeredBuildSelector.UpstreamFilterStrategy.UseOldest}:
     * {@code Use the oldest build}.
     * 
     * @return
     *     {@code Use the oldest build}
     */
    public static String TriggeredBuildSelector_UpstreamFilterStrategy_UseOldest() {
        return holder.format("TriggeredBuildSelector.UpstreamFilterStrategy.UseOldest");
    }

    /**
     * Key {@code TriggeredBuildSelector.UpstreamFilterStrategy.UseOldest}:
     * {@code Use the oldest build}.
     * 
     * @return
     *     {@code Use the oldest build}
     */
    public static Localizable _TriggeredBuildSelector_UpstreamFilterStrategy_UseOldest() {
        return new Localizable(holder, "TriggeredBuildSelector.UpstreamFilterStrategy.UseOldest");
    }

    /**
     * Key {@code PermalinkBuildSelector.DisplayName}: {@code Specified by
     * permalink}.
     * 
     * @return
     *     {@code Specified by permalink}
     */
    public static String PermalinkBuildSelector_DisplayName() {
        return holder.format("PermalinkBuildSelector.DisplayName");
    }

    /**
     * Key {@code PermalinkBuildSelector.DisplayName}: {@code Specified by
     * permalink}.
     * 
     * @return
     *     {@code Specified by permalink}
     */
    public static Localizable _PermalinkBuildSelector_DisplayName() {
        return new Localizable(holder, "PermalinkBuildSelector.DisplayName");
    }

    /**
     * Key {@code
     * DownstreamBuildSelector.UpstreamProjectName.NotAbstractProject}:
     * {@code "Downstream build of" is not applicable to this project ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "Downstream build of" is not applicable to this project ({0})}
     */
    public static String DownstreamBuildSelector_UpstreamProjectName_NotAbstractProject(Object arg0) {
        return holder.format("DownstreamBuildSelector.UpstreamProjectName.NotAbstractProject", arg0);
    }

    /**
     * Key {@code
     * DownstreamBuildSelector.UpstreamProjectName.NotAbstractProject}:
     * {@code "Downstream build of" is not applicable to this project ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "Downstream build of" is not applicable to this project ({0})}
     */
    public static Localizable _DownstreamBuildSelector_UpstreamProjectName_NotAbstractProject(Object arg0) {
        return new Localizable(holder, "DownstreamBuildSelector.UpstreamProjectName.NotAbstractProject", arg0);
    }

    /**
     * Key {@code CopyArtifact.MissingSrcWorkspace}: {@code Unable to access
     * upstream workspace for artifact copy. Agent node offline?}.
     * 
     * @return
     *     {@code Unable to access upstream workspace for artifact copy. Agent
     *     node offline?}
     */
    public static String CopyArtifact_MissingSrcWorkspace() {
        return holder.format("CopyArtifact.MissingSrcWorkspace");
    }

    /**
     * Key {@code CopyArtifact.MissingSrcWorkspace}: {@code Unable to access
     * upstream workspace for artifact copy. Agent node offline?}.
     * 
     * @return
     *     {@code Unable to access upstream workspace for artifact copy. Agent
     *     node offline?}
     */
    public static Localizable _CopyArtifact_MissingSrcWorkspace() {
        return new Localizable(holder, "CopyArtifact.MissingSrcWorkspace");
    }

    /**
     * Key {@code CopyArtifactCompatibilityMode.ProductionMode}: {@code
     * Production}.
     * 
     * @return
     *     {@code Production}
     */
    public static String CopyArtifactCompatibilityMode_ProductionMode() {
        return holder.format("CopyArtifactCompatibilityMode.ProductionMode");
    }

    /**
     * Key {@code CopyArtifactCompatibilityMode.ProductionMode}: {@code
     * Production}.
     * 
     * @return
     *     {@code Production}
     */
    public static Localizable _CopyArtifactCompatibilityMode_ProductionMode() {
        return new Localizable(holder, "CopyArtifactCompatibilityMode.ProductionMode");
    }

    /**
     * Key {@code CopyArtifactCompatibilityMode.MigrationMode}: {@code
     * Migration}.
     * 
     * @return
     *     {@code Migration}
     */
    public static String CopyArtifactCompatibilityMode_MigrationMode() {
        return holder.format("CopyArtifactCompatibilityMode.MigrationMode");
    }

    /**
     * Key {@code CopyArtifactCompatibilityMode.MigrationMode}: {@code
     * Migration}.
     * 
     * @return
     *     {@code Migration}
     */
    public static Localizable _CopyArtifactCompatibilityMode_MigrationMode() {
        return new Localizable(holder, "CopyArtifactCompatibilityMode.MigrationMode");
    }

    /**
     * Key {@code CopyArtifact.DisplayName}: {@code Copy artifacts from
     * another project}.
     * 
     * @return
     *     {@code Copy artifacts from another project}
     */
    public static String CopyArtifact_DisplayName() {
        return holder.format("CopyArtifact.DisplayName");
    }

    /**
     * Key {@code CopyArtifact.DisplayName}: {@code Copy artifacts from
     * another project}.
     * 
     * @return
     *     {@code Copy artifacts from another project}
     */
    public static Localizable _CopyArtifact_DisplayName() {
        return new Localizable(holder, "CopyArtifact.DisplayName");
    }

    /**
     * Key {@code StatusBuildSelector.DisplayName}: {@code Latest successful
     * build}.
     * 
     * @return
     *     {@code Latest successful build}
     */
    public static String StatusBuildSelector_DisplayName() {
        return holder.format("StatusBuildSelector.DisplayName");
    }

    /**
     * Key {@code StatusBuildSelector.DisplayName}: {@code Latest successful
     * build}.
     * 
     * @return
     *     {@code Latest successful build}
     */
    public static Localizable _StatusBuildSelector_DisplayName() {
        return new Localizable(holder, "StatusBuildSelector.DisplayName");
    }

    /**
     * Key {@code TriggeredBuildSelector.DisplayName}: {@code Upstream build
     * that triggered this job}.
     * 
     * @return
     *     {@code Upstream build that triggered this job}
     */
    public static String TriggeredBuildSelector_DisplayName() {
        return holder.format("TriggeredBuildSelector.DisplayName");
    }

    /**
     * Key {@code TriggeredBuildSelector.DisplayName}: {@code Upstream build
     * that triggered this job}.
     * 
     * @return
     *     {@code Upstream build that triggered this job}
     */
    public static Localizable _TriggeredBuildSelector_DisplayName() {
        return new Localizable(holder, "TriggeredBuildSelector.DisplayName");
    }

}
