/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.relocate.StandardHandler;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.util.Arrays;
import jenkins.model.Jenkins;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.MockAuthorizationStrategy;

public class StandardHandlerTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void getDestinations() throws Exception {
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        FreeStyleProject j = (FreeStyleProject)d1.createProject(FreeStyleProject.class, "j");
        Folder d2 = (Folder)this.r.jenkins.createProject(Folder.class, "d2");
        Folder d3 = (Folder)this.r.jenkins.createProject(Folder.class, "d3");
        this.r.jenkins.setSecurityRealm((SecurityRealm)this.r.createDummySecurityRealm());
        this.r.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new MockAuthorizationStrategy().grant(new Permission[]{Jenkins.READ, Item.READ}).everywhere().to(new String[]{"joe"}).grant(new Permission[]{Item.CREATE}).onItems(new Item[]{d2}).to(new String[]{"joe"}));
        try (ACLContext ctx = ACL.as((User)User.getOrCreateByIdOrFullName((String)"joe"));){
            Assert.assertEquals(Arrays.asList(d1, d2), (Object)new StandardHandler().validDestinations((Item)j));
            Assert.assertEquals(Arrays.asList(this.r.jenkins, d2), (Object)new StandardHandler().validDestinations((Item)d1));
            Assert.assertNotEquals(Arrays.asList(this.r.jenkins, d3), (Object)new StandardHandler().validDestinations((Item)j));
            Assert.assertNotEquals(Arrays.asList(d1, d3), (Object)new StandardHandler().validDestinations((Item)d1));
        }
    }

    @Test
    public void getDestinationsUsingSubfolders() throws Exception {
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        Folder d11 = (Folder)d1.createProject(Folder.class, "d11");
        FreeStyleProject j = (FreeStyleProject)d1.createProject(FreeStyleProject.class, "j");
        Folder d2 = (Folder)this.r.jenkins.createProject(Folder.class, "d2");
        Folder d3 = (Folder)this.r.jenkins.createProject(Folder.class, "d3");
        Folder d31 = (Folder)d3.createProject(Folder.class, "d31");
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d11, d2, d3, d31), (Object)new StandardHandler().validDestinations((Item)j));
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d2, d3, d31), (Object)new StandardHandler().validDestinations((Item)d11));
        Assert.assertNotEquals((Object)d11, (Object)new StandardHandler().validDestinations((Item)d11));
    }

    @Test
    public void getDestinationsUsingItemsWithSameName() throws Exception {
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        Folder d11 = (Folder)d1.createProject(Folder.class, "d11");
        FreeStyleProject j = (FreeStyleProject)d1.createProject(FreeStyleProject.class, "j");
        Folder d2 = (Folder)this.r.jenkins.createProject(Folder.class, "d2");
        FreeStyleProject g = (FreeStyleProject)d2.createProject(FreeStyleProject.class, "j");
        Folder d3 = (Folder)this.r.jenkins.createProject(Folder.class, "d3");
        Folder d31 = (Folder)d3.createProject(Folder.class, "d11");
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d11, d3, d31), (Object)new StandardHandler().validDestinations((Item)j));
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d2, d31), (Object)new StandardHandler().validDestinations((Item)d11));
        Assert.assertNotEquals((Object)d2, (Object)new StandardHandler().validDestinations((Item)j));
        Assert.assertNotEquals(Arrays.asList(d11, d3), (Object)new StandardHandler().validDestinations((Item)d11));
    }

    @Test
    public void getDestinationsUsingItemsWithSameNameOnRootContext() throws Exception {
        FreeStyleProject j = (FreeStyleProject)this.r.jenkins.createProject(FreeStyleProject.class, "j");
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        Folder d11 = (Folder)d1.createProject(Folder.class, "d11");
        Folder d2 = (Folder)this.r.jenkins.createProject(Folder.class, "d2");
        FreeStyleProject g = (FreeStyleProject)d2.createProject(FreeStyleProject.class, "j");
        Folder d3 = (Folder)this.r.jenkins.createProject(Folder.class, "d3");
        Folder d31 = (Folder)d3.createProject(Folder.class, "d11");
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d11, d3, d31), (Object)new StandardHandler().validDestinations((Item)j));
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d1, d2, d31), (Object)new StandardHandler().validDestinations((Item)d11));
        Assert.assertNotEquals((Object)d2, (Object)new StandardHandler().validDestinations((Item)j));
        Assert.assertNotEquals((Object)d3, (Object)new StandardHandler().validDestinations((Item)d11));
    }

    @Test
    public void getDestinationsMovingAParentFolderInToTheTree() throws Exception {
        Folder d1 = (Folder)this.r.jenkins.createProject(Folder.class, "d1");
        Folder d11 = (Folder)d1.createProject(Folder.class, "d2");
        Folder d12 = (Folder)d11.createProject(Folder.class, "d3");
        Folder d4 = (Folder)this.r.jenkins.createProject(Folder.class, "d4");
        Assert.assertEquals(Arrays.asList(this.r.jenkins, d4), (Object)new StandardHandler().validDestinations((Item)d1));
        Assert.assertNotEquals(Arrays.asList(d11, d12), (Object)new StandardHandler().validDestinations((Item)d1));
    }
}

