/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.config;

import com.cloudbees.hudson.plugins.folder.config.AbstractFolderConfiguration;
import com.cloudbees.hudson.plugins.folder.health.WorstChildHealthMetric;
import hudson.ExtensionFinder;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;

public class AbstractFolderConfigurationTest {
    private static final String GUICE_INITIALIZATION_MESSAGE = "Failed to instantiate Key[type=" + AbstractFolderConfiguration.class.getName() + ", annotation=[none]];";
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public LoggerRule logging = new LoggerRule().record(ExtensionFinder.GuiceFinder.class, Level.INFO).capture(100);

    @Test
    public void testInitialization() {
        MatcherAssert.assertThat((String)"AbstractFolderConfiguration should not cause circular dependency on startup", this.logging.getRecords().stream().filter(lr -> lr.getLevel().intValue() == Level.WARNING.intValue()).filter(lr -> lr.getMessage().contains(GUICE_INITIALIZATION_MESSAGE)).map(lr -> lr.getSourceClassName() + "." + lr.getSourceMethodName() + ": " + lr.getMessage()).collect(Collectors.toList()), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void healthMetricsAppearsInConfiguredGlobally() throws Exception {
        HtmlForm cfg = this.r.createWebClient().goTo("configure").getFormByName("config");
        MatcherAssert.assertThat((String)"adding metrics from Global Configuration", (Object)AbstractFolderConfiguration.get().getHealthMetrics(), (Matcher)Matchers.hasSize((int)cfg.getElementsByAttribute("div", "suffix", "healthMetrics").size()));
    }

    @Test
    public void shouldBeAbleToRemoveHealthMetricConfiguredGlobally() throws Exception {
        ArrayList<WorstChildHealthMetric> healthMetrics = new ArrayList<WorstChildHealthMetric>(1);
        healthMetrics.add(new WorstChildHealthMetric(true));
        AbstractFolderConfiguration.get().setHealthMetrics(healthMetrics);
        HtmlForm cfg = this.r.createWebClient().goTo("configure").getFormByName("config");
        for (HtmlElement element : cfg.getElementsByAttribute("div", "name", "healthMetrics")) {
            element.remove();
        }
        this.r.submit(cfg);
        MatcherAssert.assertThat((String)"deleting all global metrics should result in an empty list", (Object)AbstractFolderConfiguration.get().getHealthMetrics(), (Matcher)Matchers.hasSize((int)0));
    }

    public static class TestInitialization {
        @Initializer(before=InitMilestone.JOB_LOADED, after=InitMilestone.PLUGINS_STARTED)
        public static void init(Jenkins jenkins) {
            AbstractFolderConfiguration.get();
        }

        @Initializer(after=InitMilestone.PLUGINS_STARTED)
        public static void init2(Jenkins jenkins) {
            AbstractFolderConfiguration.get();
        }
    }
}

