/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.EventOutputStreams;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EventOutputStreamsTest {
    @Rule
    public TemporaryFolder work = new TemporaryFolder();

    @Test
    public void given_everyoneFlushing_when_twoThreads_then_outputCorrect() throws Exception {
        this.test(true, true);
    }

    @Test
    public void given_nobodyFlushing_when_twoThreads_then_outputCorrect() throws Exception {
        this.test(false, false);
    }

    @Test
    public void given_oneFlushing_when_twoThreads_then_outputCorrect() throws Exception {
        this.test(true, false);
    }

    public void test(boolean aFlush, boolean bFlush) throws Exception {
        final File file = this.work.newFile();
        EventOutputStreams instance = new EventOutputStreams(new EventOutputStreams.OutputFile(){

            @NonNull
            public File get() {
                return file;
            }
        }, 250L, TimeUnit.MILLISECONDS, 8192, false, Long.MAX_VALUE, 0);
        Thread t1 = new Thread(() -> {
            OutputStream os = instance.get();
            try {
                PrintWriter pw = new PrintWriter(os, aFlush);
                for (int i = 0; i < 10000; ++i) {
                    pw.println(String.format("%1$05dA", i));
                }
                pw.flush();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException pw) {}
                }
            }
        });
        Thread t2 = new Thread(() -> {
            OutputStream os = instance.get();
            try {
                PrintWriter pw = new PrintWriter(os, bFlush);
                for (int i = 0; i < 10000; ++i) {
                    pw.println(String.format("%1$05dB", i));
                }
                pw.flush();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException pw) {}
                }
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        ArrayList as = new ArrayList();
        ArrayList bs = new ArrayList();
        try (Stream<String> lines = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
            lines.forEach(line -> {
                MatcherAssert.assertThat((String)("Line does not have both thread output: '" + StringEscapeUtils.escapeJava((String)line) + "'"), (Object)line.matches("^\\d+[AB](\\d+[AB])+$"), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((String)("Line does not contain a null character: '" + StringEscapeUtils.escapeJava((String)line) + "'"), (Object)line.indexOf(0), (Matcher)Matchers.is((Object)-1));
                if (line.endsWith("A")) {
                    as.add(line);
                } else if (line.endsWith("B")) {
                    bs.add(line);
                } else {
                    Assert.fail((String)("unexpected line: '" + StringEscapeUtils.escapeJava((String)line) + "'"));
                }
            });
        }
        ArrayList sorted = new ArrayList(as);
        Collections.sort(sorted);
        MatcherAssert.assertThat(as, (Matcher)Matchers.is(sorted));
        sorted = new ArrayList(bs);
        Collections.sort(sorted);
        MatcherAssert.assertThat(bs, (Matcher)Matchers.is(sorted));
    }
}

