/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.builduser.utils;

import java.util.Map;

public final class UsernameUtils {
    private UsernameUtils() {
    }

    public static void setUsernameVars(String username, Map<String, String> variables) {
        variables.put("BUILD_USER", username);
        variables.put("BUILD_USER_FIRST_NAME", UsernameUtils.getFirstName(username));
        variables.put("BUILD_USER_LAST_NAME", UsernameUtils.getLastName(username));
    }

    public static String getFirstName(String fullName) {
        if (fullName == null || fullName.trim().isEmpty()) {
            return "";
        }
        String[] parts = UsernameUtils.splitName(fullName);
        return parts[0];
    }

    public static String getLastName(String fullName) {
        if (fullName == null || fullName.trim().isEmpty()) {
            return "";
        }
        String[] parts = UsernameUtils.splitName(fullName);
        return parts.length >= 2 ? parts[1] : "";
    }

    private static String[] splitName(String fullName) {
        return fullName.trim().split("\\s+");
    }
}

