/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.global;

import hudson.Extension;
import hudson.init.Terminator;
import hudson.plugins.build_timeout.global.TimeOut;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;

@Extension
public class Lifecycle {
    private static final Logger log = Logger.getLogger(Lifecycle.class.getName());
    private final ScheduledExecutorService scheduler;

    public Lifecycle() {
        this(null);
    }

    @Inject
    public Lifecycle(@TimeOut ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Terminator
    public void shutdown() {
        log.fine(() -> "Shutting down Global TimeOut ScheduledExecutorService...");
        List<Runnable> timeOuts = this.scheduler.shutdownNow();
        log.info(() -> String.format("Shutdown complete - Global TimeOut ScheduledExecutorService had %d tasks pending", timeOuts.size()));
    }
}

