/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline;

import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildGrid;
import au.com.centrumsystems.hudson.plugin.buildpipeline.BuildPipelineView;
import au.com.centrumsystems.hudson.plugin.buildpipeline.DefaultBuildGridImpl;
import au.com.centrumsystems.hudson.plugin.buildpipeline.DefaultProjectGridImpl;
import au.com.centrumsystems.hudson.plugin.buildpipeline.PipelineBuild;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectForm;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectGrid;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectGridBuilder;
import au.com.centrumsystems.hudson.plugin.buildpipeline.ProjectGridBuilderDescriptor;
import au.com.centrumsystems.hudson.plugin.buildpipeline.extension.PipelineHeaderExtension;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.AdaptedIterator;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DownstreamProjectGridBuilder
extends ProjectGridBuilder {
    private String firstJob;
    private String firstJobLink;

    @DataBoundConstructor
    public DownstreamProjectGridBuilder(String firstJob) {
        this.firstJob = firstJob;
    }

    public String getFirstJob() {
        return this.firstJob;
    }

    public String getFirstJobLink() {
        return this.firstJobLink;
    }

    public AbstractProject<?, ?> getFirstJob(BuildPipelineView owner) {
        try {
            return (AbstractProject)Jenkins.getInstance().getItem(this.firstJob, owner.getOwnerItemGroup(), AbstractProject.class);
        }
        catch (AccessDeniedException ex) {
            return null;
        }
    }

    @Override
    public boolean hasBuildPermission(BuildPipelineView owner) {
        AbstractProject<?, ?> job = this.getFirstJob(owner);
        return job != null && job.hasPermission(Item.BUILD);
    }

    @Override
    public boolean startsWithParameters(BuildPipelineView owner) {
        AbstractProject<?, ?> firstJob = this.getFirstJob(owner);
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)firstJob.getProperty(ParametersDefinitionProperty.class);
        return pdp != null;
    }

    @Override
    @RequirePOST
    public HttpResponse doBuild(StaplerRequest req, @AncestorInPath BuildPipelineView owner) throws IOException {
        final AbstractProject<?, ?> p = this.getFirstJob(owner);
        if (p == null) {
            return HttpResponses.error((int)400, (String)("No such project: " + this.getFirstJob()));
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.sendRedirect("..");
                rsp.setStatus(200);
                try {
                    p.doBuild(req, rsp, new TimeDuration(0L));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public ProjectGrid build(BuildPipelineView owner) {
        AbstractProject project = (AbstractProject)Jenkins.getInstance().getItem(this.firstJob, owner.getOwnerItemGroup(), AbstractProject.class);
        this.firstJobLink = project != null ? project.getUrl() : "";
        return new GridImpl(owner.getColumnHeaders(), owner.getOwnerItemGroup(), this.getFirstJob(owner));
    }

    @Override
    public void onJobRenamed(BuildPipelineView owner, Item item, String oldName, String newName) throws IOException {
        if (item instanceof AbstractProject && oldName != null && oldName.equals(this.firstJob)) {
            this.firstJob = newName;
            owner.save();
        }
    }

    private static final class GridImpl
    extends DefaultProjectGridImpl {
        private final AbstractProject<?, ?> start;
        private final ItemGroup context;
        private final Iterable<BuildGrid> builds = new Iterable<BuildGrid>(){

            @Override
            public Iterator<BuildGrid> iterator() {
                if (start == null) {
                    return Collections.emptyList().iterator();
                }
                Iterator base = start.getBuilds().iterator();
                return new AdaptedIterator<AbstractBuild<?, ?>, BuildGrid>(base){

                    protected BuildGrid adapt(AbstractBuild<?, ?> item) {
                        return new BuildGridImpl(new BuildForm(context, new PipelineBuild(item)));
                    }
                };
            }
        };

        private GridImpl(PipelineHeaderExtension columnHeaders, ItemGroup context, AbstractProject<?, ?> start) {
            this.context = context;
            this.start = start;
            this.placeProjectInGrid(0, 0, ProjectForm.as(start, columnHeaders));
        }

        private void placeProjectInGrid(int startingRow, int startingColumn, ProjectForm projectForm) {
            if (projectForm == null) {
                return;
            }
            int row = this.getNextAvailableRow(startingRow, startingColumn);
            this.set(row, startingColumn, projectForm);
            int childrensColumn = startingColumn + 1;
            for (ProjectForm downstreamProject : projectForm.getDependencies()) {
                this.placeProjectInGrid(row, childrensColumn, downstreamProject);
                ++row;
            }
        }

        @Override
        public Iterable<BuildGrid> builds() {
            return this.builds;
        }
    }

    @Extension(ordinal=1000.0)
    public static class DescriptorImpl
    extends ProjectGridBuilderDescriptor {
        public String getDisplayName() {
            return "Based on upstream/downstream relationship";
        }

        public ListBoxModel doFillFirstJobItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel options = new ListBoxModel();
            for (AbstractProject p : Jenkins.getInstance().getAllItems(AbstractProject.class)) {
                options.add(p.getFullDisplayName(), p.getRelativeNameFrom(context));
            }
            return options;
        }
    }

    private static final class BuildGridImpl
    extends DefaultBuildGridImpl {
        private BuildGridImpl(BuildForm start) {
            this.placeBuildInGrid(0, 0, start);
        }

        private void placeBuildInGrid(int startingRow, int startingColumn, BuildForm buildForm) {
            int row = this.getNextAvailableRow(startingRow, startingColumn);
            this.set(row, startingColumn, buildForm);
            int childrensColumn = startingColumn + 1;
            for (BuildForm downstreamProject : buildForm.getDependencies()) {
                this.placeBuildInGrid(row, childrensColumn, downstreamProject);
                ++row;
            }
        }
    }
}

