/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch.buildstrategies.basic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import java.util.concurrent.TimeUnit;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.buildstrategies.basic.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class TagBuildStrategyImpl
extends BranchBuildStrategy {
    private final long atLeastMillis;
    private final long atMostMillis;

    @DataBoundConstructor
    public TagBuildStrategyImpl(@CheckForNull String atLeastDays, @CheckForNull String atMostDays) {
        this(TimeUnit.DAYS, Long.parseLong(StringUtils.defaultIfBlank((String)atLeastDays, (String)"-1")), Long.parseLong(StringUtils.defaultIfBlank((String)atMostDays, (String)"-1")));
    }

    public TagBuildStrategyImpl(@NonNull TimeUnit unit, @CheckForNull Number atLeast, @CheckForNull Number atMost) {
        this.atLeastMillis = atLeast == null || atLeast.longValue() < 0L ? -1L : unit.toMillis(atLeast.longValue());
        this.atMostMillis = atMost == null || atMost.longValue() < 0L ? -1L : unit.toMillis(atMost.longValue());
    }

    @Restricted(value={DoNotUse.class})
    @NonNull
    public String getAtLeastDays() {
        return this.atLeastMillis >= 0L ? Long.toString(TimeUnit.MILLISECONDS.toDays(this.atLeastMillis)) : "";
    }

    @Restricted(value={DoNotUse.class})
    @NonNull
    public String getAtMostDays() {
        return this.atMostMillis >= 0L ? Long.toString(TimeUnit.MILLISECONDS.toDays(this.atMostMillis)) : "";
    }

    public long getAtLeastMillis() {
        return this.atLeastMillis;
    }

    public long getAtMostMillis() {
        return this.atMostMillis;
    }

    @CheckForNull
    public Long getAtLeast(@NonNull TimeUnit unit) {
        return this.atLeastMillis >= 0L ? Long.valueOf(unit.convert(this.atLeastMillis, TimeUnit.MILLISECONDS)) : null;
    }

    @CheckForNull
    public Long getAtMost(@NonNull TimeUnit unit) {
        return this.atMostMillis >= 0L ? Long.valueOf(unit.convert(this.atMostMillis, TimeUnit.MILLISECONDS)) : null;
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, @CheckForNull SCMRevision prevRevision) {
        if (!(head instanceof TagSCMHead)) {
            return false;
        }
        if (this.atLeastMillis >= 0L || this.atMostMillis >= 0L) {
            if (this.atMostMillis >= 0L && this.atLeastMillis > this.atMostMillis) {
                return false;
            }
            long tagAge = System.currentTimeMillis() - ((TagSCMHead)head).getTimestamp();
            if (this.atMostMillis >= 0L && tagAge > this.atMostMillis) {
                return false;
            }
            if (this.atLeastMillis >= 0L && tagAge < this.atLeastMillis) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TagBuildStrategyImpl that = (TagBuildStrategyImpl)((Object)o);
        if (this.atLeastMillis != that.atLeastMillis) {
            return false;
        }
        return this.atMostMillis == that.atMostMillis;
    }

    public int hashCode() {
        int result = (int)(this.atLeastMillis ^ this.atLeastMillis >>> 32);
        result = 31 * result + (int)(this.atMostMillis ^ this.atMostMillis >>> 32);
        return result;
    }

    public String toString() {
        return "TagBuildStrategyImpl{atLeast=" + (this.atLeastMillis >= 0L ? Util.getPastTimeString((long)this.atLeastMillis) : "n/a") + ", atMost=" + (this.atMostMillis >= 0L ? Util.getPastTimeString((long)this.atMostMillis) : "n/a") + '}';
    }

    @Symbol(value={"buildTags"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.TagBuildStrategyImpl_displayName();
        }
    }
}

