/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch.buildstrategies.basic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.BranchBuildStrategyDescriptor;
import jenkins.branch.buildstrategies.basic.Messages;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class NamedBranchBuildStrategyImpl
extends BranchBuildStrategy {
    @NonNull
    private final List<NameFilter> filters;

    @DataBoundConstructor
    public NamedBranchBuildStrategyImpl(List<NameFilter> filters) {
        this.filters = new ArrayList<NameFilter>(Util.fixNull(filters));
    }

    public boolean isAutomaticBuild(@NonNull SCMSource source, @NonNull SCMHead head, @NonNull SCMRevision currRevision, SCMRevision prevRevision) {
        if (head instanceof ChangeRequestSCMHead) {
            return false;
        }
        if (head instanceof TagSCMHead) {
            return false;
        }
        String name = head.getName();
        for (NameFilter filter : this.filters) {
            if (!filter.isMatch(name)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public List<NameFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NamedBranchBuildStrategyImpl that = (NamedBranchBuildStrategyImpl)((Object)o);
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public String toString() {
        return "NamedBranchBuildStrategyImpl{filters=" + this.filters + '}';
    }

    public static class WildcardsNameFilter
    extends NameFilter {
        @NonNull
        private final String includes;
        @NonNull
        private final String excludes;
        private final boolean caseSensitive;
        private transient Pattern includePattern;
        private transient Pattern excludePattern;

        @DataBoundConstructor
        public WildcardsNameFilter(@CheckForNull String includes, @CheckForNull String excludes, boolean caseSensitive) {
            this.includes = StringUtils.defaultIfBlank((String)includes, (String)"*");
            this.excludes = StringUtils.defaultIfBlank((String)excludes, (String)"");
            this.caseSensitive = caseSensitive;
            this.includePattern = Pattern.compile(this.getPattern(this.includes), caseSensitive ? 0 : 2);
            this.excludePattern = Pattern.compile(this.getPattern(this.excludes), caseSensitive ? 0 : 2);
        }

        @NonNull
        public String getIncludes() {
            return this.includes;
        }

        @NonNull
        public String getExcludes() {
            return this.excludes;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean isMatch(@NonNull String name) {
            if (this.includePattern == null) {
                this.includePattern = Pattern.compile(this.getPattern(this.includes), this.caseSensitive ? 0 : 2);
            }
            if (!this.includePattern.matcher(name).matches()) {
                return false;
            }
            if (StringUtils.isBlank((String)this.excludes)) {
                return true;
            }
            if (this.excludePattern == null) {
                this.excludePattern = Pattern.compile(this.getPattern(this.excludes), this.caseSensitive ? 0 : 2);
            }
            return !this.excludePattern.matcher(name).matches();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WildcardsNameFilter that = (WildcardsNameFilter)((Object)o);
            if (this.caseSensitive != that.caseSensitive) {
                return false;
            }
            if (!this.includes.equals(that.includes)) {
                return false;
            }
            return this.excludes.equals(that.excludes);
        }

        @Override
        public int hashCode() {
            int result = this.includes.hashCode();
            result = 31 * result + this.excludes.hashCode();
            result = 31 * result + (this.caseSensitive ? 1 : 0);
            return result;
        }

        @Override
        public String toString() {
            return "WildcardsNameFilter{includes='" + this.includes + '\'' + ", excludes='" + this.excludes + '\'' + ", caseSensitive=" + this.caseSensitive + '}';
        }

        private String getPattern(String names) {
            StringBuilder quotedBranches = new StringBuilder();
            for (String wildcard : names.split(" ")) {
                StringBuilder quotedBranch = new StringBuilder();
                for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                    if (branch.equals("*")) {
                        quotedBranch.append(".*");
                        continue;
                    }
                    if (branch.isEmpty()) continue;
                    quotedBranch.append(Pattern.quote(branch));
                }
                if (quotedBranches.length() > 0) {
                    quotedBranches.append("|");
                }
                quotedBranches.append((CharSequence)quotedBranch);
            }
            return quotedBranches.toString();
        }

        @Symbol(value={"wildcards"})
        @Extension
        public static class DescriptorImpl
        extends NameFilterDescriptor {
            @Nonnull
            public String getDisplayName() {
                return Messages.NamedBranchBuildStrategyImpl_wildcardDisplayName();
            }
        }
    }

    public static class RegexNameFilter
    extends NameFilter {
        @NonNull
        private final String regex;
        private final boolean caseSensitive;
        private transient Pattern pattern;

        @DataBoundConstructor
        public RegexNameFilter(@CheckForNull String regex, boolean caseSensitive) {
            this.regex = StringUtils.defaultIfBlank((String)regex, (String)"^.*$");
            this.caseSensitive = caseSensitive;
            this.pattern = Pattern.compile(this.regex, caseSensitive ? 0 : 2);
        }

        @NonNull
        public String getRegex() {
            return this.regex;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean isMatch(@NonNull String name) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex, this.caseSensitive ? 0 : 2);
            }
            return this.pattern.matcher(name).matches();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RegexNameFilter that = (RegexNameFilter)((Object)o);
            if (this.caseSensitive != that.caseSensitive) {
                return false;
            }
            return this.regex.equals(that.regex);
        }

        @Override
        public int hashCode() {
            int result = this.regex.hashCode();
            result = 31 * result + (this.caseSensitive ? 1 : 0);
            return result;
        }

        @Override
        public String toString() {
            return "RegexNameFilter{regex=/" + this.regex + '/' + ", caseSensitive=" + this.caseSensitive + '}';
        }

        @Symbol(value={"regex"})
        @Extension
        public static class DescriptorImpl
        extends NameFilterDescriptor {
            @Nonnull
            public String getDisplayName() {
                return Messages.NamedBranchBuildStrategyImpl_regexDisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckRegex(@QueryParameter String value) {
                try {
                    Pattern.compile(value);
                    return FormValidation.ok();
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
        }
    }

    public static class ExactNameFilter
    extends NameFilter {
        @NonNull
        private final String name;
        private final boolean caseSensitive;

        @DataBoundConstructor
        public ExactNameFilter(@CheckForNull String name, boolean caseSensitive) {
            this.name = Util.fixNull((String)name);
            this.caseSensitive = caseSensitive;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean isMatch(@NonNull String name) {
            return this.caseSensitive ? this.name.equals(name) : this.name.equalsIgnoreCase(name);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ExactNameFilter that = (ExactNameFilter)((Object)o);
            if (this.caseSensitive != that.caseSensitive) {
                return false;
            }
            return this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.caseSensitive ? 1 : 0);
            return result;
        }

        @Override
        public String toString() {
            return "ExactNameFilter{name='" + this.name + '\'' + ", caseSensitive=" + this.caseSensitive + '}';
        }

        @Symbol(value={"exact"})
        @Extension
        public static class DescriptorImpl
        extends NameFilterDescriptor {
            @Nonnull
            public String getDisplayName() {
                return Messages.NamedBranchBuildStrategyImpl_exactDisplayName();
            }
        }
    }

    public static abstract class NameFilterDescriptor
    extends Descriptor<NameFilter> {
    }

    public static abstract class NameFilter
    extends AbstractDescribableImpl<NameFilter> {
        public abstract boolean isMatch(@NonNull String var1);

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract String toString();
    }

    @Symbol(value={"buildNamedBranches"})
    @Extension
    public static class DescriptorImpl
    extends BranchBuildStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.NamedBranchBuildStrategyImpl_displayName();
        }
    }
}

